/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.ResizePolicy;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ResizeInteraction
extends Interaction {
    private final ScreenView myScreenView;
    private final NlComponent myComponent;
    private final SegmentType myHorizontalEdge;
    private final SegmentType myVerticalEdge;
    private ResizeHandler myResizeHandler;

    public ResizeInteraction(@NotNull ScreenView screenView, @NotNull NlComponent component, @NotNull SelectionHandle handle) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/surface/ResizeInteraction", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/surface/ResizeInteraction", "<init>"));
        }
        if (handle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handle", "com/android/tools/idea/uibuilder/surface/ResizeInteraction", "<init>"));
        }
        this.myScreenView = screenView;
        this.myComponent = component;
        this.myHorizontalEdge = handle.getHorizontalEdge();
        this.myVerticalEdge = handle.getVerticalEdge();
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        ViewGroupHandler viewGroupHandler;
        super.begin(x, y, startMask);
        NlComponent parent = this.myComponent.getParent();
        if (parent != null && (viewGroupHandler = ViewHandlerManager.get(this.myScreenView.getModel().getFacet()).findLayoutHandler(parent, false)) != null) {
            ViewEditorImpl editor = new ViewEditorImpl(this.myScreenView);
            this.myResizeHandler = viewGroupHandler.createResizeHandler(editor, this.myComponent, this.myHorizontalEdge, this.myVerticalEdge);
            if (this.myResizeHandler != null) {
                int androidX = Coordinates.getAndroidX(this.myScreenView, this.myStartX);
                int androidY = Coordinates.getAndroidY(this.myScreenView, this.myStartY);
                this.myResizeHandler.start(androidX, androidY, startMask);
            }
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        this.moveTo(x, y, modifiers, false);
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        this.moveTo(x, y, modifiers, !canceled);
        if (!canceled) {
            this.myScreenView.getModel().notifyModified(NlModel.ChangeType.RESIZE_END);
        }
    }

    private void moveTo(int x, int y, final @JdkConstants.InputEventMask int modifiers, boolean commit) {
        if (this.myResizeHandler == null) {
            return;
        }
        final int ax = Coordinates.getAndroidX(this.myScreenView, x);
        final int ay = Coordinates.getAndroidY(this.myScreenView, y);
        int deltaX = Coordinates.getAndroidDimension(this.myScreenView, x - this.myStartX);
        int deltaY = Coordinates.getAndroidDimension(this.myScreenView, y - this.myStartY);
        final Rectangle newBounds = this.getNewBounds(new Rectangle(this.myComponent.x, this.myComponent.y, this.myComponent.w, this.myComponent.h), deltaX, deltaY);
        this.myResizeHandler.update(ax, ay, modifiers, newBounds);
        if (commit) {
            NlModel model = this.myScreenView.getModel();
            Project project = model.getFacet().getModule().getProject();
            XmlFile file = model.getFile();
            String label = "Resize";
            WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/surface/ResizeInteraction$1", "run"));
                    }
                    ResizeInteraction.this.myResizeHandler.commit(ax, ay, modifiers, newBounds);
                }
            };
            action.execute();
            model.notifyModified(NlModel.ChangeType.RESIZE_COMMIT);
        }
        this.myScreenView.getSurface().repaint();
    }

    private Rectangle getNewBounds(Rectangle b, int deltaX, int deltaY) {
        boolean isBottom;
        int x = b.x;
        int y = b.y;
        int w = b.width;
        int h = b.height;
        if (deltaX == 0 && deltaY == 0) {
            return b;
        }
        ResizePolicy mResizePolicy = ResizePolicy.full();
        boolean isLeft = this.myVerticalEdge == SegmentType.LEFT || this.myVerticalEdge == SegmentType.START;
        boolean isRight = this.myVerticalEdge == SegmentType.RIGHT || this.myVerticalEdge == SegmentType.END;
        boolean isTop = this.myHorizontalEdge == SegmentType.TOP;
        boolean bl = isBottom = this.myHorizontalEdge == SegmentType.BOTTOM;
        if (mResizePolicy.isAspectPreserving() && w != 0 && h != 0) {
            double aspectRatio = (double)w / (double)h;
            int newW = Math.abs(b.width + (isLeft ? -deltaX : deltaX));
            int newH = Math.abs(b.height + (isTop ? -deltaY : deltaY));
            double newAspectRatio = (double)newW / (double)newH;
            if (newH == 0 || newAspectRatio > aspectRatio) {
                deltaY = (int)((double)deltaX / aspectRatio);
            } else {
                deltaX = (int)((double)deltaY * aspectRatio);
            }
        }
        if (isLeft) {
            int nx1 = b.x + deltaX;
            int x2 = b.x + b.width;
            if (nx1 <= x2) {
                x = nx1;
                w = x2 - x;
            } else {
                w = 0;
                x = x2;
            }
        } else if (isRight) {
            int nx2 = b.x + b.width + deltaX;
            w = nx2 >= b.x ? nx2 - b.x : 0;
        } else assert (this.myVerticalEdge == null) : this.myVerticalEdge;
        if (isTop) {
            int ny1 = b.y + deltaY;
            int y2 = b.y + b.height;
            if (ny1 < y2) {
                y = ny1;
                h = y2 - y;
            } else {
                h = 0;
                y = y2;
            }
        } else if (isBottom) {
            int ny2 = b.y + b.height + deltaY;
            h = ny2 >= b.y ? ny2 - b.y : 0;
        } else assert (this.myHorizontalEdge == null) : this.myHorizontalEdge;
        return new Rectangle(x, y, w, h);
    }

    @Override
    public List<Layer> createOverlays() {
        return Collections.singletonList(new ResizeLayer());
    }

    private class ResizeLayer
    extends Layer {
        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/ResizeInteraction$ResizeLayer", "paint"));
            }
            if (ResizeInteraction.this.myResizeHandler != null) {
                ResizeInteraction.this.myResizeHandler.paint(new NlGraphics(gc, ResizeInteraction.this.myScreenView));
            }
        }
    }
}

