/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.androidstudio.actions;

import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.androidstudio.actions.CreateNewClassDialogValidatorEx;
import com.intellij.androidstudio.actions.CreateNewClassDialogValidatorExImpl;
import com.intellij.androidstudio.actions.Kind;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaCreateFromTemplateHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileFromTemplateDialog
extends DialogWrapper {
    private static final String ATTRIBUTE_INTERFACES = "INTERFACES";
    private static final String ATTRIBUTE_VISIBILITY = "VISIBILITY";
    private static final String ATTRIBUTE_SUPERCLASS = "SUPERCLASS";
    private static final String ATTRIBUTE_FINAL = "FINAL";
    private static final String ATTRIBUTE_ABSTRACT = "ABSTRACT";
    private static final String ATTRIBUTE_IMPORT_BLOCK = "IMPORT_BLOCK";
    private static final String HELP_URL = "https://developer.android.com/r/studio-ui/newjclass.html";
    private static final String HELP_ID = "create.file.from.template";
    private JPanel myPanel;
    private JLabel myNameLabel;
    private EditorTextField myNameField;
    private JLabel myKindLabel;
    private TemplateKindCombo myKindCombo;
    private JLabel mySuperclassLabel;
    private JPanel mySuperclassFieldPlaceholder;
    private EditorTextField mySuperclassField;
    private JLabel myInterfacesLabel;
    private JPanel myInterfacesFieldPlaceholder;
    private EditorTextField myInterfacesField;
    private JLabel myPackageLabel;
    private JPanel myPackageFieldPlaceholder;
    private EditorTextField myPackageField;
    private JLabel myVisibilityLabel;
    private JRadioButton myPublicRadioButton;
    private JRadioButton myPackagePrivateRadioButton;
    private JLabel myModifiersLabel;
    private JRadioButton myNoModifierRadioButton;
    private JRadioButton myAbstractRadioButton;
    private JRadioButton myFinalRadioButton;
    private JSeparator myOverridesSeparator;
    private JCheckBox myShowSelectOverridesDialogCheckBox;
    private ElementCreator myCreator;
    private CreateNewClassDialogValidatorEx myInputValidator;
    private final Project myProject;
    private final PsiPackage myDefaultPsiPackage;
    private final JavaCodeFragmentFactory myFragmentFactory;
    private final PsiDocumentManager myPsiDocumentManager;
    private final Map<String, String> myCreationOptions;

    protected CreateFileFromTemplateDialog(@NotNull Project project, @NotNull PsiDirectory defaultDirectory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "<init>"));
        }
        if (defaultDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultDirectory", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.myCreationOptions = new HashMap<String, String>();
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), this.myPanel);
        this.setTitle(IdeBundle.message((String)"action.create.new.class", (Object[])new Object[0]));
        this.myKindLabel.setLabelFor((Component)this.myKindCombo);
        this.myVisibilityLabel.setLabelFor(this.myPublicRadioButton);
        this.myModifiersLabel.setLabelFor(this.myNoModifierRadioButton);
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        this.myProject = project;
        this.myInputValidator = new CreateNewClassDialogValidatorExImpl(this.myProject);
        this.myDefaultPsiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(JavaDirectoryService.getInstance().getPackage(defaultDirectory).getQualifiedName());
        this.myFragmentFactory = JavaCodeFragmentFactory.getInstance((Project)project);
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        this.mySuperclassField = this.initAutocompleteEditorTextField("", "The superclass to explicitly extend, if any.");
        this.mySuperclassField.setName("superclass_editor_text_field");
        this.mySuperclassFieldPlaceholder.add((Component)this.mySuperclassField);
        this.mySuperclassLabel.setLabelFor((Component)this.mySuperclassField);
        this.myInterfacesField = this.initAutocompleteEditorTextField("", "The interface to implement, if any.");
        this.myInterfacesField.setName("interfaces_editor_text_field");
        this.myInterfacesFieldPlaceholder.add((Component)this.myInterfacesField);
        this.myInterfacesLabel.setLabelFor((Component)this.myInterfacesField);
        this.myPackageField = this.initAutocompleteEditorTextField(this.myDefaultPsiPackage.getQualifiedName(), "The package to create the item in.");
        this.myPackageFieldPlaceholder.add((Component)this.myPackageField);
        this.myPackageLabel.setLabelFor((Component)this.myPackageField);
        this.setKindComponentsVisible(false);
        this.init();
        this.initKindCombo();
        if (this.myKindCombo.getComboBox().getItemCount() > 1) {
            this.setKindComponentsVisible(true);
        }
    }

    @NotNull
    private EditorTextField initAutocompleteEditorTextField(@NotNull String defaultText, @NotNull String tooltip) {
        if (defaultText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultText", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "initAutocompleteEditorTextField"));
        }
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "initAutocompleteEditorTextField"));
        }
        PsiJavaCodeReferenceCodeFragment fragment = this.myFragmentFactory.createReferenceCodeFragment(defaultText, (PsiElement)this.myDefaultPsiPackage, true, true);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        Document doc = this.myPsiDocumentManager.getDocument((PsiFile)fragment);
        EditorTextField editorTextField = new EditorTextField(doc, this.myProject, (FileType)StdFileTypes.JAVA);
        editorTextField.setToolTipText(tooltip);
        EditorTextField editorTextField2 = editorTextField;
        if (editorTextField2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "initAutocompleteEditorTextField"));
        }
        return editorTextField2;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myInputValidator != null) {
            String nameText = this.myNameField.getText();
            String superclassAsString = this.mySuperclassField.getText();
            String packageText = this.myPackageField.getText();
            if (!this.myInputValidator.checkInput(nameText)) {
                String errorText = LangBundle.message((String)"incorrect.name", (Object[])new Object[0]);
                String message = this.myInputValidator.getErrorText(nameText);
                if (message != null) {
                    errorText = message;
                }
                return new ValidationInfo(errorText, (JComponent)this.myNameField);
            }
            if (!superclassAsString.isEmpty()) {
                Type superclassAsType = Type.newType(superclassAsString, this.myProject);
                if (!(!this.mySuperclassField.isVisible() || superclassAsType.canUseAsClass() && this.myInputValidator.checkSuperclass(superclassAsString))) {
                    return new ValidationInfo(this.myInputValidator.getSuperclassErrorText(superclassAsString), (JComponent)this.mySuperclassField);
                }
            }
            for (String interfaceAsString : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)this.getInterfaces())) {
                Type interfaceAsType = Type.newType(interfaceAsString, this.myProject);
                if (interfaceAsType.canUseAsInterface() && this.myInputValidator.checkInterface(interfaceAsString)) continue;
                return new ValidationInfo(this.myInputValidator.getInterfacesErrorText(interfaceAsString), (JComponent)this.myInterfacesField);
            }
            if (!this.myInputValidator.checkPackage(packageText)) {
                return new ValidationInfo(this.myInputValidator.getPackageErrorText(packageText), (JComponent)this.myPackageField);
            }
        }
        return super.doValidate();
    }

    private void configureComponents(@Nullable Kind kind) {
        boolean isClassKind;
        boolean bl = isClassKind = kind != null && kind == Kind.CLASS;
        if (isClassKind) {
            this.mySuperclassLabel.setVisible(true);
            this.mySuperclassFieldPlaceholder.setVisible(true);
            this.mySuperclassField.setFocusable(true);
            this.myModifiersLabel.setVisible(true);
            this.myNoModifierRadioButton.setSelected(true);
            this.myNoModifierRadioButton.setVisible(true);
            this.myAbstractRadioButton.setVisible(true);
            this.myFinalRadioButton.setVisible(true);
            this.myOverridesSeparator.setVisible(true);
            this.myShowSelectOverridesDialogCheckBox.setVisible(true);
        } else {
            this.mySuperclassLabel.setVisible(false);
            this.mySuperclassField.setText("");
            this.mySuperclassField.setFocusable(false);
            this.mySuperclassFieldPlaceholder.setVisible(false);
            this.myModifiersLabel.setVisible(false);
            this.myNoModifierRadioButton.setSelected(true);
            this.myNoModifierRadioButton.setVisible(false);
            this.myAbstractRadioButton.setVisible(false);
            this.myFinalRadioButton.setVisible(false);
            this.myOverridesSeparator.setVisible(false);
            this.myShowSelectOverridesDialogCheckBox.setSelected(false);
            this.myShowSelectOverridesDialogCheckBox.setVisible(false);
        }
    }

    private String getName() {
        String text = this.myNameField.getText().trim();
        this.myNameField.setText(text);
        return text;
    }

    public String getSuperclass() {
        String superclass = this.mySuperclassField.getText().trim();
        this.mySuperclassField.setText(superclass);
        return superclass;
    }

    public void setSuperclass(String superclass) {
        this.mySuperclassField.setText(superclass);
    }

    private String getPackage() {
        String packageName = this.myPackageField.getText().replace(" ", "");
        this.myPackageField.setText(packageName);
        return packageName;
    }

    public void setPackage(String packageName) {
        this.myPackageField.setText(packageName);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        ArrayList<String> imports = new ArrayList<String>();
        String localPackage = this.getPackage();
        String superclassAsString = this.getSuperclass();
        if (!superclassAsString.isEmpty()) {
            Type superclassAsType = Type.newType(superclassAsString, this.myProject);
            this.myCreationOptions.put(ATTRIBUTE_SUPERCLASS, superclassAsType.getClassWithNesting());
            if (superclassAsType.requiresImport(localPackage)) {
                imports.add(superclassAsType.getClassToImport());
            }
        } else {
            this.myCreationOptions.put(ATTRIBUTE_SUPERCLASS, "");
        }
        ArrayList<String> interfacesToUse = new ArrayList<String>();
        for (String interfaceAsString : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)this.getInterfaces())) {
            Type interfaceAsType = Type.newType(interfaceAsString, this.myProject);
            interfacesToUse.add(interfaceAsType.getClassWithNesting());
            if (!interfaceAsType.requiresImport(localPackage)) continue;
            imports.add(interfaceAsType.getClassToImport());
        }
        this.myCreationOptions.put(ATTRIBUTE_INTERFACES, Joiner.on((String)", ").join(interfacesToUse));
        this.myCreationOptions.put("PACKAGE_NAME", localPackage);
        Visibility visibility = this.myPublicRadioButton.isSelected() ? Visibility.PUBLIC : Visibility.PACKAGE_PRIVATE;
        this.myCreationOptions.put(ATTRIBUTE_VISIBILITY, visibility.toString());
        this.myCreationOptions.put(ATTRIBUTE_ABSTRACT, Boolean.toString(this.myAbstractRadioButton.isSelected()).toUpperCase(Locale.ROOT));
        this.myCreationOptions.put(ATTRIBUTE_FINAL, Boolean.toString(this.myFinalRadioButton.isSelected()).toUpperCase(Locale.ROOT));
        this.myCreationOptions.put(ATTRIBUTE_IMPORT_BLOCK, CreateFileFromTemplateDialog.formatImports(imports));
        if (this.myCreator != null && this.myCreator.tryCreate(this.getName()).length == 0) {
            return;
        }
        super.doOKAction();
    }

    @NotNull
    protected String getHelpId() {
        if (HELP_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "getHelpId"));
        }
        return HELP_ID;
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)HELP_URL);
    }

    @NotNull
    private static String formatImports(Iterable<String> imports) {
        StringBuilder importBlock = new StringBuilder();
        for (String entry : imports) {
            importBlock.append("import ").append(entry).append(";\n");
        }
        String string = importBlock.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "formatImports"));
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private void setKindComponentsVisible(boolean visible) {
        this.myKindCombo.setVisible(visible);
        this.myKindLabel.setVisible(visible);
    }

    private void addKind(@NotNull Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "addKind"));
        }
        this.myKindCombo.addItem(kind.getName(), kind.getIcon(), kind.getTemplateName());
    }

    private void addKind(@NotNull FileTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "addKind"));
        }
        this.myKindCombo.addItem(template.getName(), JavaFileType.INSTANCE.getIcon(), template.getName());
    }

    PsiClass show(final @NotNull FileCreator creator) throws FailedToCreateFileException {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog", "show"));
        }
        final Ref ref = Ref.create(null);
        this.myCreator = new ElementCreator(this.myProject, IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0])){

            protected PsiElement[] create(String newName) throws Exception {
                PsiElement[] psiElementArray;
                PsiClass element = creator.createFile(CreateFileFromTemplateDialog.this.getName(), CreateFileFromTemplateDialog.this.myCreationOptions, CreateFileFromTemplateDialog.this.myKindCombo.getSelectedName());
                ref.set((Object)element);
                if (element == null) {
                    psiElementArray = PsiElement.EMPTY_ARRAY;
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = element;
                }
                return psiElementArray;
            }

            protected String getActionName(String newName) {
                return creator.getActionName(newName, CreateFileFromTemplateDialog.this.myKindCombo.getSelectedName());
            }
        };
        this.show();
        if (this.getExitCode() == 0) {
            return (PsiClass)ref.get();
        }
        throw new FailedToCreateFileException("Create returned a null object.");
    }

    boolean isShowSelectOverridesDialogCheckBoxSelected() {
        return this.myShowSelectOverridesDialogCheckBox.isSelected();
    }

    String getInterfaces() {
        return this.myInterfacesField.getText();
    }

    void setInterfaces(String newInterface) {
        this.myInterfacesField.setText(newInterface);
    }

    public void initKindCombo() {
        this.myKindCombo.registerUpDownHint((JComponent)this.myNameField);
        this.myKindCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(CreateFileFromTemplateDialog.this.myKindCombo.getComboBox())) {
                    CreateFileFromTemplateDialog.this.configureComponents(Kind.valueOfText(CreateFileFromTemplateDialog.this.myKindCombo.getSelectedName()));
                }
            }
        });
        this.addKind(Kind.CLASS);
        this.addKind(Kind.INTERFACE);
        if (LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            this.addKind(Kind.ENUM);
            this.addKind(Kind.ANNOTATION);
        }
        JavaCreateFromTemplateHandler handler = new JavaCreateFromTemplateHandler();
        for (FileTemplate template : FileTemplateManager.getInstance((Project)this.myProject).getAllTemplates()) {
            if (!handler.handlesTemplate(template)) continue;
            this.addKind(template);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JSeparator jSeparator;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JLabel jLabel;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JLabel jLabel2;
        JPanel jPanel;
        JLabel jLabel3;
        JPanel jPanel2;
        JLabel jLabel4;
        JPanel jPanel3;
        JLabel jLabel5;
        TemplateKindCombo templateKindCombo;
        JLabel jLabel6;
        EditorTextField editorTextField;
        JLabel jLabel7;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(12, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setPreferredSize(new Dimension(505, 339));
        jPanel4.setMinimumSize(new Dimension(500, 339));
        this.myNameLabel = jLabel7 = new JLabel();
        jLabel7.setText("Name:");
        jLabel7.setDisplayedMnemonic('N');
        jLabel7.setDisplayedMnemonicIndex(0);
        jLabel7.setToolTipText("The name of the new item.");
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 27), new Dimension(-1, 27)));
        this.myNameField = editorTextField = new EditorTextField();
        jPanel4.add((Component)editorTextField, new GridConstraints(0, 1, 1, 3, 0, 1, 3, 3, null, new Dimension(280, -1), new Dimension(-1, 23)));
        this.myKindLabel = jLabel6 = new JLabel();
        jLabel6.setText("Kind:");
        jLabel6.setDisplayedMnemonic('K');
        jLabel6.setDisplayedMnemonicIndex(0);
        jLabel6.setToolTipText("The type of item to create.");
        jPanel4.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 27), new Dimension(-1, 27)));
        this.myKindCombo = templateKindCombo = new TemplateKindCombo();
        templateKindCombo.setToolTipText("The type of item to create.");
        jPanel4.add((Component)templateKindCombo, new GridConstraints(1, 1, 1, 4, 0, 1, 3, 3, null, null, null));
        this.mySuperclassLabel = jLabel5 = new JLabel();
        jLabel5.setText("Superclass:");
        jLabel5.setDisplayedMnemonic('S');
        jLabel5.setDisplayedMnemonicIndex(0);
        jLabel5.setToolTipText("The superclass to explicitly extend, if any.");
        jPanel4.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 27), new Dimension(-1, 27)));
        this.mySuperclassFieldPlaceholder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel3).setEnabled(true);
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setName("superclass_background_panel");
        jPanel3.setAlignmentX(0.0f);
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 1, 1, 3, 0, 3, 2, 2, null, null, new Dimension(-1, 23)));
        this.myInterfacesLabel = jLabel4 = new JLabel();
        jLabel4.setText("Interface(s):");
        jLabel4.setDisplayedMnemonic('I');
        jLabel4.setDisplayedMnemonicIndex(0);
        jLabel4.setToolTipText("A comma separated list of the interfaces to implement or extend, if any.");
        jPanel4.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 27), new Dimension(-1, 27)));
        this.myInterfacesFieldPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setName("interfaces_background_panel");
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 1, 1, 3, 0, 3, 2, 2, null, null, new Dimension(-1, 23)));
        this.myPackageLabel = jLabel3 = new JLabel();
        jLabel3.setText("Package:");
        jLabel3.setDisplayedMnemonic('P');
        jLabel3.setDisplayedMnemonicIndex(0);
        jLabel3.setToolTipText("The package to create the item in.");
        jPanel4.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 27), new Dimension(-1, 27)));
        this.myPackageFieldPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setEnabled(true);
        jPanel.setAlignmentY(0.0f);
        jPanel.setName("package_background_panel");
        jPanel.setAlignmentX(0.0f);
        jPanel4.add((Component)jPanel, new GridConstraints(4, 1, 1, 3, 0, 3, 2, 2, null, null, new Dimension(-1, 23)));
        this.myVisibilityLabel = jLabel2 = new JLabel();
        jLabel2.setText("Visibility:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jLabel2.setToolTipText("The visibility of the new item.");
        jPanel4.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPublicRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setName("public_radio_button");
        jRadioButton5.setText("Public");
        jRadioButton5.setMnemonic('U');
        jRadioButton5.setDisplayedMnemonicIndex(1);
        jRadioButton5.setToolTipText("Make the new item public.");
        jRadioButton5.setActionCommand("visibility_public");
        jRadioButton5.setSelected(true);
        jRadioButton5.setHorizontalAlignment(10);
        jPanel4.add((Component)jRadioButton5, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPackagePrivateRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setName("package_private_radio_button");
        jRadioButton4.setText("Package Private");
        jRadioButton4.setMnemonic('R');
        jRadioButton4.setDisplayedMnemonicIndex(9);
        jRadioButton4.setToolTipText("Make the new item package private.");
        jRadioButton4.setActionCommand("visibility_package_private");
        jRadioButton4.setHorizontalAlignment(10);
        jPanel4.add((Component)jRadioButton4, new GridConstraints(5, 2, 1, 2, 8, 0, 7, 0, null, null, null));
        this.myModifiersLabel = jLabel = new JLabel();
        jLabel.setText("Modifiers:");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jLabel.setToolTipText("The visibility of the new item.");
        jLabel.setName("modifiers_label");
        jPanel4.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNoModifierRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setName("none_radio_button");
        jRadioButton3.setText("None");
        jRadioButton3.setMnemonic('O');
        jRadioButton3.setDisplayedMnemonicIndex(1);
        jRadioButton3.setActionCommand("modifier_none");
        jRadioButton3.setSelected(true);
        jRadioButton3.setLabel("None");
        jPanel4.add((Component)jRadioButton3, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAbstractRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setName("abstract_radio_button");
        jRadioButton2.setText("Abstract");
        jRadioButton2.setMnemonic('A');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jRadioButton2.setActionCommand("modifier_abstract");
        jPanel4.add((Component)jRadioButton2, new GridConstraints(6, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFinalRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setName("final_radio_button");
        jRadioButton.setText("Final");
        jRadioButton.setMnemonic('F');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jRadioButton.setActionCommand("modifier_final");
        jRadioButton.setLabel("Final");
        jPanel4.add((Component)jRadioButton, new GridConstraints(6, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("      ");
        jPanel4.add((Component)jLabel8, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOverridesSeparator = jSeparator = new JSeparator();
        jSeparator.setName("overrides_separator");
        jPanel4.add((Component)jSeparator, new GridConstraints(8, 0, 1, 4, 0, 1, 0, 7, null, null, null));
        this.myShowSelectOverridesDialogCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText("Show the dialog to select methods to override after creating the class.");
        jCheckBox.setIconTextGap(4);
        jCheckBox.setHorizontalAlignment(10);
        jCheckBox.setName("overrides_check_box");
        jCheckBox.setAlignmentX(0.5f);
        jCheckBox.setText("Show Select Overrides Dialog");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(22);
        jPanel4.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("      ");
        jPanel4.add((Component)jLabel9, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(11, 1, 1, 3, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static class FailedToCreateFileException
    extends Exception {
        FailedToCreateFileException(String message) {
            super(message);
        }
    }

    private static class StringBackedType
    extends Type {
        private final String myPackage;
        private final String myClass;

        private StringBackedType(@NotNull String className) {
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$StringBackedType", "<init>"));
            }
            if (className.isEmpty()) {
                throw new IllegalArgumentException("className is empty.");
            }
            int lastDotIndex = className.lastIndexOf(".");
            if (lastDotIndex != -1) {
                this.myPackage = className.substring(0, lastDotIndex);
                this.myClass = className.substring(lastDotIndex + 1);
            } else {
                this.myPackage = "";
                this.myClass = className;
            }
        }

        @Override
        @NotNull
        String getClassWithNesting() {
            String string = this.myClass;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$StringBackedType", "getClassWithNesting"));
            }
            return string;
        }

        @Override
        String getClassToImport() {
            return this.getQualifiedClass();
        }

        @Override
        @NotNull
        String getPackage() {
            String string = this.myPackage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$StringBackedType", "getPackage"));
            }
            return string;
        }

        @NotNull
        String getQualifiedClass() {
            String string = this.myPackage.isEmpty() ? this.myClass : this.myPackage + "." + this.myClass;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$StringBackedType", "getQualifiedClass"));
            }
            return string;
        }

        @Override
        boolean canUseAsClass() {
            return true;
        }

        @Override
        boolean canUseAsInterface() {
            return true;
        }
    }

    private static class PsiBackedType
    extends Type {
        private final PsiClass myPsiClass;
        private final PsiPackage myPsiPackage;
        private final JavaDirectoryService myJavaDirectoryService;
        private final String myClassNameWithNesting;
        private final String myNameOfClassToImport;

        private PsiBackedType(@NotNull String className, @NotNull Project project) {
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$PsiBackedType", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$PsiBackedType", "<init>"));
            }
            this.myJavaDirectoryService = JavaDirectoryService.getInstance();
            this.myPsiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
            if (this.myPsiClass == null) {
                throw new IllegalArgumentException(className);
            }
            PsiPackage psiPackage = null;
            for (PsiElement parent = this.myPsiClass.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof PsiDirectory)) continue;
                PsiDirectory psiDirectory = (PsiDirectory)parent;
                psiPackage = this.myJavaDirectoryService.getPackage(psiDirectory);
                break;
            }
            String classToImport = null;
            ArrayDeque<String> containingClasses = new ArrayDeque<String>();
            for (PsiClass psiClass = this.myPsiClass; psiClass != null; psiClass = psiClass.getContainingClass()) {
                classToImport = psiClass.getName();
                containingClasses.addFirst(psiClass.getName());
            }
            this.myClassNameWithNesting = Joiner.on((String)".").join(containingClasses);
            this.myPsiPackage = psiPackage;
            this.myNameOfClassToImport = classToImport;
        }

        @Override
        String getClassWithNesting() {
            return this.myClassNameWithNesting;
        }

        @Override
        String getClassToImport() {
            return this.myPsiPackage.getQualifiedName() + "." + this.myNameOfClassToImport;
        }

        @Override
        String getPackage() {
            if (this.myPsiPackage != null) {
                return this.myPsiPackage.getQualifiedName();
            }
            throw new IllegalStateException("myPsiPackage cannot be null for a PsiBackedType.");
        }

        @Override
        boolean canUseAsClass() {
            return !this.myPsiClass.isInterface() && !this.myPsiClass.isEnum() && !this.myPsiClass.isAnnotationType();
        }

        @Override
        boolean canUseAsInterface() {
            return this.myPsiClass.isInterface();
        }
    }

    public static abstract class Type {
        private static final String JAVA_LANG_PACKAGE = "java.lang";

        abstract String getClassWithNesting();

        abstract String getClassToImport();

        abstract String getPackage();

        abstract boolean canUseAsClass();

        abstract boolean canUseAsInterface();

        private static Type newType(@NotNull String qualifiedName, @NotNull Project project) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$Type", "newType"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/androidstudio/actions/CreateFileFromTemplateDialog$Type", "newType"));
            }
            try {
                return new PsiBackedType(qualifiedName, project);
            }
            catch (IllegalArgumentException e) {
                return new StringBackedType(qualifiedName);
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Type) {
                Type qualifiedClass = (Type)object;
                return this.getClassWithNesting().equals(qualifiedClass.getClassWithNesting()) && this.getPackage().equals(qualifiedClass.getPackage());
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = 31 * hashCode + this.getClassWithNesting().hashCode();
            hashCode = 31 * hashCode + this.getPackage().hashCode();
            return hashCode;
        }

        private boolean requiresImport(String localPackage) {
            return !this.getPackage().equals(localPackage) && !this.getPackage().equals(JAVA_LANG_PACKAGE);
        }
    }

    public static enum Visibility {
        PUBLIC,
        PACKAGE_PRIVATE;

    }

    static interface FileCreator {
        @Nullable
        public PsiClass createFile(@NotNull String var1, @NotNull Map<String, String> var2, @NotNull String var3);

        @NotNull
        public String getActionName(@NotNull String var1, @NotNull String var2);
    }
}

