/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;

public class ListEditForm {
    JPanel contentPanel;
    ListTable table;

    public ListEditForm(String title, List<String> stringList) {
        this.table = new ListTable(new ListWrappingTableModel(stringList, title));
        this.contentPanel = ToolbarDecorator.createDecorator(this.table).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListWrappingTableModel tableModel = ListEditForm.this.table.getModel();
                tableModel.addRow();
                EventQueue.invokeLater(() -> {
                    int lastRowIndex = tableModel.getRowCount() - 1;
                    Rectangle rectangle = ListEditForm.this.table.getCellRect(lastRowIndex, 0, true);
                    ListEditForm.this.table.scrollRectToVisible(rectangle);
                    ListEditForm.this.table.editCellAt(lastRowIndex, 0);
                    ListSelectionModel selectionModel = ListEditForm.this.table.getSelectionModel();
                    selectionModel.setSelectionInterval(lastRowIndex, lastRowIndex);
                    TableCellEditor editor = ListEditForm.this.table.getCellEditor();
                    Component component = editor.getTableCellEditorComponent(ListEditForm.this.table, null, true, lastRowIndex, 0);
                    component.requestFocus();
                });
            }
        }).setRemoveAction(button -> TableUtil.removeSelectedItems((JTable)this.table)).disableUpDownActions().createPanel();
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }
}

