/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicNodesGroup
extends NodesGroup {
    private String myGroupName;
    private NodesGroup myParent;
    private boolean myClosed;

    public BasicNodesGroup(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/openapi/graph/builder/components/BasicNodesGroup", "<init>"));
        }
        this(groupName, null);
    }

    public BasicNodesGroup(String groupName, NodesGroup parent) {
        this.myGroupName = groupName;
        this.myParent = parent;
        this.myClosed = true;
    }

    @Override
    @NotNull
    public String getGroupName() {
        String string = this.myGroupName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/components/BasicNodesGroup", "getGroupName"));
        }
        return string;
    }

    @Override
    @Nullable
    public GroupNodeRealizer getGroupNodeRealizer() {
        GroupNodeRealizer groupNodeRealizer = GraphManager.getGraphManager().createGroupNodeRealizer();
        groupNodeRealizer.setInnerGraphDisplayEnabled(true);
        groupNodeRealizer.setAutoBoundsEnabled(true);
        groupNodeRealizer.setLabelText(this.getGroupName());
        groupNodeRealizer.setOpenGroupIcon(PlatformIcons.PACKAGE_ICON);
        groupNodeRealizer.setClosedGroupIcon(PlatformIcons.PACKAGE_ICON);
        groupNodeRealizer.setFillColor(UIUtil.getLabelBackground());
        NodeLabel label = groupNodeRealizer.getLabel();
        label.setBackgroundColor((Color)JBColor.lightGray);
        label.setTextColor(JBColor.foreground());
        return groupNodeRealizer;
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.myClosed = closed;
    }

    @Override
    @Nullable
    public NodesGroup getParent() {
        return this.myParent;
    }

    public void setParent(NodesGroup parent) {
        this.myParent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicNodesGroup that = (BasicNodesGroup)o;
        return this.myGroupName.equals(that.myGroupName);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myGroupName.hashCode();
    }
}

