/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxRootTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxSetterAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticSetterAttributeDescriptor;

public abstract class JavaFxClassTagDescriptorBase
implements XmlElementDescriptor,
Validator<XmlTag> {
    private final String myName;

    public JavaFxClassTagDescriptorBase(String name) {
        this.myName = name;
    }

    public abstract PsiClass getPsiClass();

    public String getQualifiedName() {
        PsiClass psiClass = this.getPsiClass();
        return psiClass != null ? psiClass.getQualifiedName() : this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        PsiClass psiClass;
        if (context != null && (psiClass = this.getPsiClass()) != null) {
            ArrayList<XmlElementDescriptor> children = new ArrayList<XmlElementDescriptor>();
            this.collectWritableProperties(children, member -> new JavaFxPropertyTagDescriptor(psiClass, PropertyUtil.getPropertyName((PsiMember)member), false));
            JavaFxPropertyTagDescriptor defaultPropertyDescriptor = this.getDefaultPropertyDescriptor();
            if (defaultPropertyDescriptor != null) {
                Collections.addAll(children, defaultPropertyDescriptor.getElementsDescriptors(context));
            } else {
                for (String name : FxmlConstants.FX_BUILT_IN_TAGS) {
                    children.add(new JavaFxBuiltInTagDescriptor(name, null));
                }
            }
            JavaFxClassTagDescriptorBase.collectStaticElementDescriptors(context, children);
            if (!children.isEmpty()) {
                return children.toArray(new XmlElementDescriptor[children.size()]);
            }
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    private JavaFxPropertyTagDescriptor getDefaultPropertyDescriptor() {
        Object value;
        PsiAnnotationMemberValue defaultPropertyAttributeValue;
        PsiClass psiClass = this.getPsiClass();
        PsiAnnotation defaultProperty = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton("javafx.beans.DefaultProperty"));
        if (defaultProperty != null && (defaultPropertyAttributeValue = defaultProperty.findAttributeValue("value")) instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)defaultPropertyAttributeValue).getValue()) instanceof String) {
            return new JavaFxPropertyTagDescriptor(psiClass, (String)value, false);
        }
        return null;
    }

    static void collectStaticAttributesDescriptors(@Nullable XmlTag context, List<XmlAttributeDescriptor> simpleAttrs) {
        if (context == null) {
            return;
        }
        JavaFxClassTagDescriptorBase.collectParentStaticProperties(context.getParentTag(), simpleAttrs, method -> new JavaFxSetterAttributeDescriptor((PsiMethod)method, method.getContainingClass()));
    }

    protected static void collectStaticElementDescriptors(XmlTag context, List<XmlElementDescriptor> children) {
        JavaFxClassTagDescriptorBase.collectParentStaticProperties(context, children, method -> {
            PsiClass aClass = method.getContainingClass();
            return new JavaFxPropertyTagDescriptor(aClass, PropertyUtil.getPropertyName((String)method.getName()), true);
        });
    }

    private static <T> void collectParentStaticProperties(XmlTag context, List<T> children, Function<PsiMethod, T> factory) {
        for (XmlTag tag = context; tag != null; tag = tag.getParentTag()) {
            PsiElement element;
            XmlElementDescriptor descr = tag.getDescriptor();
            if (!(descr instanceof JavaFxClassTagDescriptorBase) || !((element = descr.getDeclaration()) instanceof PsiClass)) continue;
            List setters = (List)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                ArrayList<PsiMethod> meths = new ArrayList<PsiMethod>();
                for (PsiMethod method : ((PsiClass)element).getAllMethods()) {
                    PsiParameter[] parameters;
                    if (!method.hasModifierProperty("static") || !method.getName().startsWith("set") || (parameters = method.getParameterList().getParameters()).length != 2 || !InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"javafx.scene.Node")) continue;
                    meths.add(method);
                }
                return CachedValueProvider.Result.create(meths, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            });
            for (PsiMethod setter : setters) {
                children.add(factory.fun((Object)setter));
            }
        }
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        String parentTagName;
        PsiClass psiClass;
        String name = childTag.getName();
        if (FxmlConstants.FX_BUILT_IN_TAGS.contains(name)) {
            return new JavaFxBuiltInTagDescriptor(name, childTag);
        }
        if ("fx:root".equals(name)) {
            return new JavaFxRootTagDescriptor(childTag);
        }
        String shortName = StringUtil.getShortName((String)name);
        if (!name.equals(shortName)) {
            PsiMethod propertySetter = JavaFxPsiUtil.findStaticPropertySetter(name, childTag);
            if (propertySetter != null) {
                return new JavaFxPropertyTagDescriptor(propertySetter.getContainingClass(), shortName, true);
            }
            Project project = childTag.getProject();
            if (JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project)) == null) {
                return null;
            }
        }
        if ((psiClass = this.getPsiClass()) != null && !"fx:define".equals(parentTagName = contextTag.getName())) {
            if ("fx:root".equals(parentTagName)) {
                Map<String, PsiMember> properties = JavaFxPsiUtil.collectWritableProperties(psiClass);
                if (properties.get(name) != null) {
                    return new JavaFxPropertyTagDescriptor(psiClass, name, false);
                }
            } else {
                XmlElementDescriptor childDescriptor;
                String defaultPropertyName;
                JavaFxPropertyTagDescriptor defaultPropertyDescriptor = this.getDefaultPropertyDescriptor();
                if (defaultPropertyDescriptor != null && StringUtil.equalsIgnoreCase((CharSequence)(defaultPropertyName = defaultPropertyDescriptor.getName()), (CharSequence)name) && !StringUtil.equals((CharSequence)defaultPropertyName, (CharSequence)name) && (childDescriptor = defaultPropertyDescriptor.getElementDescriptor(childTag, contextTag)) != null) {
                    return childDescriptor;
                }
                Map<String, PsiMember> properties = JavaFxPsiUtil.collectWritableProperties(psiClass);
                if (properties.get(name) != null) {
                    return new JavaFxPropertyTagDescriptor(psiClass, name, false);
                }
            }
        }
        if (name.length() != 0 && Character.isLowerCase(name.charAt(0))) {
            return new JavaFxPropertyTagDescriptor(psiClass, name, false);
        }
        return new JavaFxClassTagDescriptor(name, childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        PsiClass psiClass;
        String name;
        if (context != null && Comparing.equal((String)(name = context.getName()), (String)this.getName()) && (psiClass = this.getPsiClass()) != null) {
            ArrayList<XmlAttributeDescriptor> descriptors = new ArrayList<XmlAttributeDescriptor>();
            this.collectInstanceProperties(descriptors);
            JavaFxClassTagDescriptorBase.collectStaticAttributesDescriptors(context, descriptors);
            for (String builtInAttributeName : FxmlConstants.FX_BUILT_IN_ATTRIBUTES) {
                descriptors.add((XmlAttributeDescriptor)JavaFxBuiltInAttributeDescriptor.create(builtInAttributeName, psiClass));
            }
            return descriptors.isEmpty() ? XmlAttributeDescriptor.EMPTY : descriptors.toArray(XmlAttributeDescriptor.EMPTY);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    protected void collectInstanceProperties(List<XmlAttributeDescriptor> simpleAttrs) {
        this.collectWritableProperties(simpleAttrs, member -> new JavaFxPropertyAttributeDescriptor(PropertyUtil.getPropertyName((PsiMember)member), this.getPsiClass()));
    }

    private <T> void collectWritableProperties(List<T> children, Function<PsiMember, T> factory) {
        Map<String, PsiMember> fieldList = JavaFxPsiUtil.collectWritableProperties(this.getPsiClass());
        for (PsiMember field : fieldList.values()) {
            children.add(factory.fun((Object)field));
        }
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return null;
        }
        if (FxmlConstants.FX_BUILT_IN_ATTRIBUTES.contains(attributeName)) {
            return JavaFxBuiltInAttributeDescriptor.create(attributeName, psiClass);
        }
        PsiMethod propertySetter = JavaFxPsiUtil.findStaticPropertySetter(attributeName, context);
        if (propertySetter != null) {
            return new JavaFxStaticSetterAttributeDescriptor(propertySetter, attributeName);
        }
        PsiMember psiMember = JavaFxPsiUtil.collectWritableProperties(psiClass).get(attributeName);
        if (psiMember != null) {
            return new JavaFxPropertyAttributeDescriptor(attributeName, psiClass);
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.getPsiClass();
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        boolean needInstantiate;
        XmlAttribute attribute;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "validate"));
        }
        XmlTag parentTag = context.getParentTag();
        if (parentTag != null && (attribute = context.getAttribute("fx:controller")) != null) {
            host.addMessage((PsiElement)attribute.getNameElement(), "fx:controller can only be applied to root element", Validator.ValidationHost.ErrorType.ERROR);
        }
        Pair<PsiClass, Boolean> tagValueClassInfo = JavaFxPsiUtil.getTagValueClass(context, this.getPsiClass());
        PsiClass aClass = (PsiClass)tagValueClassInfo.getFirst();
        JavaFxPsiUtil.isClassAcceptable(parentTag, aClass, (errorMessage, errorType) -> {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "lambda$validate$5"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "lambda$validate$5"));
            }
            host.addMessage(context.getNavigationElement(), errorMessage, errorType);
        });
        boolean bl = needInstantiate = (Boolean)tagValueClassInfo.getSecond() == false;
        if (needInstantiate && aClass != null && aClass.isValid()) {
            JavaFxPsiUtil.isAbleToInstantiate(aClass, errorMessage -> {
                if (host == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "lambda$validate$6"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "lambda$validate$6"));
                }
                host.addMessage((PsiElement)context, errorMessage, Validator.ValidationHost.ErrorType.ERROR);
            });
        }
    }

    public boolean isReadOnlyAttribute(String attributeName) {
        PsiClass psiClass = this.getPsiClass();
        return psiClass != null && !JavaFxPsiUtil.collectWritableProperties(psiClass).containsKey(attributeName);
    }

    @NotNull
    public static XmlElementDescriptor createTagDescriptor(XmlTag xmlTag) {
        String name = xmlTag.getName();
        if (FxmlConstants.FX_BUILT_IN_TAGS.contains(name)) {
            JavaFxBuiltInTagDescriptor javaFxBuiltInTagDescriptor = new JavaFxBuiltInTagDescriptor(name, xmlTag);
            if (javaFxBuiltInTagDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "createTagDescriptor"));
            }
            return javaFxBuiltInTagDescriptor;
        }
        if ("fx:root".equals(name)) {
            JavaFxRootTagDescriptor javaFxRootTagDescriptor = new JavaFxRootTagDescriptor(xmlTag);
            if (javaFxRootTagDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "createTagDescriptor"));
            }
            return javaFxRootTagDescriptor;
        }
        JavaFxClassTagDescriptor javaFxClassTagDescriptor = new JavaFxClassTagDescriptor(name, xmlTag);
        if (javaFxClassTagDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassTagDescriptorBase", "createTagDescriptor"));
        }
        return javaFxClassTagDescriptor;
    }
}

