/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.mxunit;

import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.impl.CfmlFunctionImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagFunctionImpl;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlUnitQualifiedNameLocationProvider
implements SMTestLocator,
DumbAware {
    private static final String PROTOCOL_ID = "cfml_qn";
    public static final CfmlUnitQualifiedNameLocationProvider INSTANCE = new CfmlUnitQualifiedNameLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        PsiElement element;
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/coldFusion/mxunit/CfmlUnitQualifiedNameLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/coldFusion/mxunit/CfmlUnitQualifiedNameLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coldFusion/mxunit/CfmlUnitQualifiedNameLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/coldFusion/mxunit/CfmlUnitQualifiedNameLocationProvider", "getLocation"));
        }
        if (PROTOCOL_ID.equals(protocol) && (element = CfmlUnitQualifiedNameLocationProvider.findElement(path, project)) != null) {
            List<PsiLocation> list = Collections.singletonList(new PsiLocation(project, element));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/mxunit/CfmlUnitQualifiedNameLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/mxunit/CfmlUnitQualifiedNameLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private static PsiElement findElement(String link, Project project) {
        Object result;
        String[] location = link.split("::");
        int tokensNumber = location.length;
        if (tokensNumber <= 0 || tokensNumber > 3) {
            return null;
        }
        String filePath = location[0];
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile != null) {
            result = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (result == null || !(result instanceof CfmlFile)) {
                return null;
            }
            CfmlTag[] tags = (CfmlTag[])PsiTreeUtil.getChildrenOfType((PsiElement)result, CfmlTag.class);
            if (tags == null || tags.length == 0) {
                return result;
            }
            for (CfmlTag tag : tags) {
                if (!"cfcomponent".equals(tag.getTagName().toLowerCase(Locale.ENGLISH))) continue;
                result = tag;
                break;
            }
        } else {
            return null;
        }
        if (tokensNumber > 1) {
            CfmlFunctionImpl[] scriptFunctions;
            String functionName = location[1];
            CfmlTagFunctionImpl[] functions = (CfmlTagFunctionImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)result, CfmlTagFunctionImpl.class);
            if (functions != null) {
                for (CfmlTagFunctionImpl function : functions) {
                    if (!functionName.equals(function.getName())) continue;
                    result = function.getNavigationElement();
                    break;
                }
            }
            if ((scriptFunctions = (CfmlFunctionImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)result, CfmlFunctionImpl.class)) != null) {
                for (CfmlFunctionImpl function : scriptFunctions) {
                    if (!functionName.equals(function.getName())) continue;
                    result = function.getNavigationElement();
                    break;
                }
            }
        }
        return result;
    }
}

