/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.HotfixGate;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ActionType;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MutableErrorTreeView;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class PerforceExceptionsHotFixer
implements VcsExceptionsHotFixer {
    private final MyListChecker myUpdateChecker;

    public PerforceExceptionsHotFixer(Project project) {
        List<MyChecker> myCheckers = Arrays.asList(new MyClobberWriteableChecker(project));
        this.myUpdateChecker = new MyListChecker(myCheckers);
    }

    public Map<HotfixData, List<VcsException>> groupExceptions(ActionType type, List<VcsException> exceptions) {
        if (ActionType.update.equals((Object)type)) {
            return this.myUpdateChecker.process(exceptions);
        }
        return null;
    }

    private static List<VcsException> getOrCreate(Map<HotfixData, List<VcsException>> map, HotfixData data) {
        List<VcsException> list = map.get(data);
        if (list == null) {
            list = new ArrayList<VcsException>();
            map.put(data, list);
        }
        return list;
    }

    private static interface MyHotfixes {
        public static final String FIX_CLOBBER_WRITEABLES = "FIX_CLOBBER_WRITEABLES";
    }

    private static class MyClobberWriteableChecker
    extends MyChecker {
        private static final String ourClobberWriteable = "Can't clobber writable file";
        private final Project myProject;

        private MyClobberWriteableChecker(Project project) {
            super(new HotfixData("FIX_CLOBBER_WRITEABLES", "Can't clobber writable file(s)", " open for edit keeping local changes", (Consumer)new MyClobberWriteableHotfix(project)));
            this.myProject = project;
        }

        @Override
        public VcsException convert(VcsException e) {
            VirtualFile vf = e.getVirtualFile();
            if (vf == null) {
                return e;
            }
            VcsException newE = new VcsException(vf.getPath());
            newE.setVirtualFile(vf);
            return newE;
        }

        @Override
        protected boolean check(VcsException exc) {
            String[] messages = exc.getMessages();
            if (messages != null && messages.length > 0 && messages[0].startsWith(ourClobberWriteable)) {
                File ioFile;
                String filePathCandidate = messages[0].substring(ourClobberWriteable.length(), messages[0].length());
                filePathCandidate = PerforceManager.getInstance(this.myProject).convertP4ParsedPath(null, filePathCandidate);
                filePathCandidate = FileUtil.toSystemDependentName((String)filePathCandidate);
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                VirtualFile vf = lfs.findFileByIoFile(ioFile = new File(filePathCandidate));
                if (vf == null) {
                    vf = lfs.refreshAndFindFileByIoFile(ioFile);
                }
                if (vf != null) {
                    exc.setVirtualFile(vf);
                    return true;
                }
            }
            return false;
        }
    }

    private static class MyClobberWriteableHotfix
    implements Consumer<HotfixGate> {
        private static final String ourClobberWriteable = "Can't clobber writable file(s)";
        private final Project myProject;
        private final VcsDirtyScopeManager myDirtyScopeManager;

        public MyClobberWriteableHotfix(Project project) {
            this.myProject = project;
            this.myDirtyScopeManager = project.isDefault() ? null : VcsDirtyScopeManager.getInstance((Project)this.myProject);
        }

        public void consume(final HotfixGate hotfixGate) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Opening files for edit", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/perforce/application/PerforceExceptionsHotFixer$MyClobberWriteableHotfix$1", "run"));
                    }
                    String name = hotfixGate.getGroupName();
                    List childData = hotfixGate.getView().getGroupChildrenData(name);
                    ArrayList processed = new ArrayList();
                    ArrayList processedFiles = new ArrayList();
                    ArrayList<SimpleErrorData> failed = new ArrayList<SimpleErrorData>();
                    try {
                        this.edit(childData, processed, processedFiles, failed);
                    }
                    catch (ProcessCanceledException e) {
                        for (Object child : childData) {
                            if (!(child instanceof VirtualFile)) continue;
                            VirtualFile vf = (VirtualFile)child;
                            failed.add(this.createErrorData(vf, "Operation canceled"));
                        }
                    }
                    MutableErrorTreeView view = hotfixGate.getView();
                    view.removeGroup(name);
                    if (!processed.isEmpty()) {
                        view.addFixedHotfixGroup(MyClobberWriteableHotfix.ourClobberWriteable, processed);
                        this.refreshVfs(processedFiles);
                    }
                    if (!failed.isEmpty()) {
                        view.addHotfixGroup(new HotfixData("FIX_CLOBBER_WRITEABLES", MyClobberWriteableHotfix.ourClobberWriteable, " open for edit keeping local changes", (Consumer)this), failed);
                    }
                }

                public void onCancel() {
                    this.onSuccess();
                }

                public void onSuccess() {
                    hotfixGate.getView().reload();
                }
            });
        }

        private void refreshVfs(List<VirtualFile> processedFiles) {
            RefreshQueue.getInstance().refresh(true, false, () -> this.myDirtyScopeManager.filesDirty((Collection)processedFiles, null), processedFiles);
        }

        private void edit(List<Object> childData, List<SimpleErrorData> processed, List<VirtualFile> processedFiles, List<SimpleErrorData> failed) {
            PerforceRunner runner = PerforceRunner.getInstance(this.myProject);
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            for (Object child : childData) {
                if (!(child instanceof VirtualFile)) continue;
                VirtualFile vf = (VirtualFile)child;
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                P4File p4File = P4File.create(VcsUtil.getFilePath((VirtualFile)vf));
                try {
                    FStat p4FStat = p4File.getFstat(this.myProject, true);
                    if (FStat.STATUS_ON_SERVER_AND_LOCAL != p4FStat.status) {
                        failed.add(this.createErrorData(vf, "Skipped; should be known to Perforce both on server and locally"));
                        continue;
                    }
                    if (FStat.LOCAL_CHECKED_IN != p4FStat.local) {
                        failed.add(this.createErrorData(vf, "Skipped; not checked in locally"));
                        continue;
                    }
                    String complaint = PerforceVcs.getFileNameComplaint(p4File);
                    if (complaint != null) {
                        failed.add(this.createErrorData(vf, PerforceBundle.message((String)"message.text.filename.non.acceptable", (Object[])new Object[]{complaint})));
                        continue;
                    }
                    runner.edit(p4File);
                    processed.add(this.createFixedData(vf));
                    processedFiles.add(vf);
                }
                catch (VcsException e) {
                    failed.add(this.createErrorData(vf, e.getMessage()));
                }
            }
        }

        private SimpleErrorData createFixedData(VirtualFile vf) {
            return new SimpleErrorData(ErrorTreeElementKind.ERROR, new String[]{vf.getPath()}, vf);
        }

        private SimpleErrorData createErrorData(VirtualFile vf, String comment) {
            return new SimpleErrorData(ErrorTreeElementKind.ERROR, new String[]{vf.getPath() + " (fix failed: " + comment + ")"}, vf);
        }
    }

    private static abstract class MyChecker {
        private final HotfixData myKey;

        public MyChecker(HotfixData key) {
            this.myKey = key;
        }

        protected abstract boolean check(VcsException var1);

        public VcsException convert(VcsException e) {
            return e;
        }

        public HotfixData getKey() {
            return this.myKey;
        }
    }

    private static class MyListChecker {
        private final List<MyChecker> myCheckers;
        private List<VcsException> myDefault;

        private MyListChecker(List<MyChecker> checkers) {
            this.myCheckers = checkers;
        }

        public Map<HotfixData, List<VcsException>> process(List<VcsException> list) {
            this.myDefault = null;
            HashMap<HotfixData, List<VcsException>> result = new HashMap<HotfixData, List<VcsException>>();
            for (VcsException exception : list) {
                boolean found = false;
                for (MyChecker checker : this.myCheckers) {
                    if (!checker.check(exception)) continue;
                    List excList = PerforceExceptionsHotFixer.getOrCreate(result, checker.getKey());
                    excList.add(checker.convert(exception));
                    found = true;
                    break;
                }
                if (found) continue;
                if (this.myDefault == null) {
                    this.myDefault = new ArrayList<VcsException>();
                }
                this.myDefault.add(exception);
            }
            if (this.myDefault != null) {
                result.put(null, this.myDefault);
            }
            return result;
        }
    }
}

