/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.UnversionedScopeScanner;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceUnversionedTracker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceUnversionedTracker");
    private final Set<VirtualFile> myUnversionedFiles = ContainerUtil.newConcurrentSet();
    private final Set<VirtualFile> myIgnoredFiles = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private static final int ourFilesThreshold = 200;
    private boolean myTotalRescanThresholdPassed = true;
    private final Set<FilePath> myDirtyFiles = ContainerUtil.newHashSet();
    private final Object myScannerLock = new Object();
    private final VcsDirtyScopeManager myDirtyScopeManager;
    volatile boolean isActive;

    public PerforceUnversionedTracker(Project project) {
        this.myProject = project;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myDirtyScopeManager.markEverythingDirty();
    }

    public boolean isUnversioned(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/application/PerforceUnversionedTracker", "isUnversioned"));
        }
        return this.myUnversionedFiles.contains(file) && !PerforceChangeProvider.isBrokenSymlink(file);
    }

    public boolean isIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/application/PerforceUnversionedTracker", "isIgnored"));
        }
        return this.myIgnoredFiles.contains(file);
    }

    public void markUnversioned(List<VirtualFile> files) throws VcsException {
        LOG.debug("markUnversioned: " + files);
        MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(files, this.myProject);
        HashSet ignored = ContainerUtil.newHashSet();
        for (P4Connection connection : map.keySet()) {
            ignored.addAll(PerforceUnversionedTracker.getFilesOutsideClientSpec(this.myProject, connection, map.get((Object)connection)));
        }
        for (VirtualFile file : files) {
            if (ignored.contains(file)) {
                this.myIgnoredFiles.add(file);
                continue;
            }
            this.myUnversionedFiles.add(file);
        }
    }

    public void markUnknown(@Nullable VirtualFile file) {
        if (file != null) {
            this.myUnversionedFiles.remove(file);
            this.myIgnoredFiles.remove(file);
        }
    }

    public static Set<VirtualFile> getFilesOutsideClientSpec(Project project, P4Connection connection, Collection<VirtualFile> files) throws VcsException {
        String path;
        if (!SystemProperties.getBooleanProperty((String)"perforce.ignored.check.enabled", (boolean)true)) {
            return Collections.emptySet();
        }
        if ((files = ContainerUtil.filter(files, file -> !file.getPath().contains("..."))).isEmpty()) {
            return Collections.emptySet();
        }
        ExecResult execResult = PerforceRunner.getInstance(project).previewAdd(connection, files);
        LinkedHashSet ignored = ContainerUtil.newLinkedHashSet();
        for (String line : execResult.getStderr().split("\n")) {
            if (line.isEmpty() || line.contains("no permission for operation on file(s)")) continue;
            path = StringUtil.trimEnd((String)line, (String)" - file(s) not in client view.");
            if (path.equals(line)) {
                PerforceRunner.checkError(execResult, PerforceSettings.getSettings(project), null);
                continue;
            }
            ContainerUtil.addIfNotNull((Collection)ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
        }
        for (String line : execResult.getStdout().split("\n")) {
            if (line.isEmpty() || (path = StringUtil.trimEnd((String)line, (String)" - ignored file can't be added.")).equals(line)) continue;
            ContainerUtil.addIfNotNull((Collection)ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
        }
        return ignored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> createScanner() {
        UnversionedScopeScanner scanner = new UnversionedScopeScanner(this.myProject){

            @Override
            protected void checkCanceled() {
                if (!PerforceUnversionedTracker.this.isActive) {
                    throw new ProcessCanceledException();
                }
            }
        };
        Object object = this.myScannerLock;
        synchronized (object) {
            if (this.myTotalRescanThresholdPassed) {
                this.myTotalRescanThresholdPassed = false;
                return () -> scanner.doRescan(UnversionedScopeScanner.createEverythingDirtyScope(this.myProject));
            }
            HashSet dirtyFiles = ContainerUtil.newHashSet(this.myDirtyFiles);
            this.myDirtyFiles.clear();
            return () -> scanner.doRescan(dirtyFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void totalRescan() {
        LOG.debug("totalRescan scheduled");
        Object object = this.myScannerLock;
        synchronized (object) {
            this.myTotalRescanThresholdPassed = true;
            this.myDirtyFiles.clear();
            this.myDirtyScopeManager.markEverythingDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDirtyFile(FilePath holder) {
        Object object = this.myScannerLock;
        synchronized (object) {
            if (this.myTotalRescanThresholdPassed) {
                return false;
            }
            LOG.debug("addDirtyFile: " + holder);
            this.myDirtyFiles.add(holder);
            if (this.myDirtyFiles.size() > 200) {
                this.totalRescan();
                return false;
            }
            return true;
        }
    }

    void reportRecheck(VirtualFile file) {
        this.markUnknown(file);
        if (this.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file))) {
            this.myDirtyScopeManager.fileDirty(file);
        }
    }

    void reportDelete(VirtualFile file) {
        if (this.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file))) {
            this.myDirtyScopeManager.fileDirty(file);
        }
    }

    void reportRecheck(Set<VirtualFile> targets) {
        for (VirtualFile target : targets) {
            if (this.addDirtyFile(VcsUtil.getFilePath((VirtualFile)target))) continue;
            return;
        }
        this.myDirtyScopeManager.filesDirty(targets, null);
    }
}

