/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.io.Serializable;
import java.util.Enumeration;
import org.w3c.util.ArrayEnumeration;

public class LookupTable
implements Cloneable,
Serializable {
    public static final int DEFAULT_CAPACITY = 10;
    private Object[] elements = null;
    private Object[] keys = null;
    private int count = 0;
    private int capacity = 0;

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new ArrayEnumeration(this.keys, this.count);
    }

    public synchronized Enumeration elements() {
        return new ArrayEnumeration(this.elements, this.count);
    }

    public synchronized boolean contains(Object object) {
        return this.contains(this.elements, this.count, object) != -1;
    }

    public synchronized boolean containsKey(Object object) {
        return this.contains(this.keys, this.count, object) != -1;
    }

    private int contains(Object[] objectArray, int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < n; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public synchronized Object get(Object object) {
        int n = this.contains(this.keys, this.count, object);
        if (n != -1) {
            return this.elements[n];
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = this.contains(this.keys, this.count, object);
        if (n == -1) {
            if (this.count >= this.capacity) {
                this.grow();
            }
            this.keys[this.count] = object;
            this.elements[this.count] = object2;
            ++this.count;
            return null;
        }
        Object object3 = this.elements[n];
        this.elements[n] = object2;
        return object3;
    }

    protected void grow() {
        int n = this.capacity * 2 + 1;
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        System.arraycopy(this.elements, 0, objectArray, 0, this.count);
        System.arraycopy(this.keys, 0, objectArray2, 0, this.count);
        this.keys = objectArray2;
        this.elements = objectArray;
        this.capacity = n;
    }

    public synchronized Object remove(Object object) {
        int n = this.contains(this.keys, this.count, object);
        if (n != -1) {
            Object object2 = this.elements[n];
            --this.count;
            this.keys[n] = this.keys[this.count];
            this.elements[n] = this.elements[this.count];
            this.keys[this.count] = null;
            this.elements[this.count] = null;
            return object2;
        }
        return null;
    }

    public synchronized void clear() {
        this.count = 0;
        this.keys = new Object[this.capacity];
        this.elements = new Object[this.capacity];
    }

    public synchronized Object clone() {
        try {
            LookupTable lookupTable = (LookupTable)super.clone();
            lookupTable.keys = new Object[this.capacity];
            System.arraycopy(this.keys, 0, lookupTable.keys, 0, this.count);
            lookupTable.elements = new Object[this.capacity];
            System.arraycopy(this.elements, 0, lookupTable.elements, 0, this.count);
            lookupTable.capacity = this.capacity;
            lookupTable.count = this.count;
            return lookupTable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append("[" + this.keys[i] + "," + this.elements[i] + "]");
        }
        return stringBuffer.toString();
    }

    public LookupTable(int n) {
        this.capacity = n;
        this.elements = new Object[n];
        this.keys = new Object[n];
    }

    public LookupTable() {
        this(10);
    }
}

