/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.web.mvc.views.ViewResolver;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewResolverFactory {
    public static final ExtensionPointName<ViewResolverFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.mvc.viewResolverFactory");

    @NotNull
    public Set<ViewResolver> createResolvers(CommonSpringBean bean, PsiClass beanClass, SpringModel model) {
        Set<ViewResolver> set = this.isMine(bean, beanClass) ? this.doCreate(bean, model) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverFactory", "createResolvers"));
        }
        return set;
    }

    public Set<ViewResolver> handleViewResolverRegistry(String methodName, PsiMethodCallExpression methodCallExpression, SpringModel servletModel) {
        return Collections.emptySet();
    }

    protected boolean isMine(CommonSpringBean bean, PsiClass beanClass) {
        String baseClassName = this.getBeanClass();
        return baseClassName != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)baseClassName);
    }

    @Nullable
    protected abstract String getBeanClass();

    protected abstract Set<ViewResolver> doCreate(CommonSpringBean var1, SpringModel var2);
}

