/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambdaConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaPredicatesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaPredicateConversionRule
extends GuavaLambdaConversionRule {
    private static final String GUAVA_PREDICATES_UTILITY = "com.google.common.base.Predicates";

    protected GuavaPredicateConversionRule() {
        super(GuavaLambda.PREDICATE);
    }

    @Override
    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        Set<String> set = Collections.singleton(GUAVA_PREDICATES_UTILITY);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "getAdditionalUtilityClasses"));
        }
        return set;
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        TypeConversionDescriptorBase descriptor;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "findConversionForMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "findConversionForMethod"));
        }
        if (!(context instanceof PsiMethodCallExpression)) {
            return null;
        }
        if (GuavaPredicateConversionRule.isPredicates((PsiMethodCallExpression)context) && (descriptor = GuavaPredicatesUtil.tryConvertIfPredicates(method, context)) != null) {
            return descriptor;
        }
        return new TypeConversionDescriptorBase(){

            public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) throws IncorrectOperationException {
                return (PsiExpression)expression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::apply", (PsiElement)expression));
            }
        };
    }

    public static boolean isPredicates(PsiMethodCallExpression expression) {
        String methodName = expression.getMethodExpression().getReferenceName();
        if (GuavaPredicatesUtil.PREDICATES_METHOD_NAMES.contains(methodName)) {
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass != null && GUAVA_PREDICATES_UTILITY.equals(aClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }
}

