/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import icons.CoffeescriptIcons;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.coffeescript.highlighter.CoffeeScriptSyntaxHighlighter;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor("Bad character", CoffeeScriptSyntaxHighlighter.BAD_CHARACTER), new AttributesDescriptor("Dot", CoffeeScriptSyntaxHighlighter.DOT), new AttributesDescriptor("Colon", CoffeeScriptSyntaxHighlighter.COLON), new AttributesDescriptor("Comma", CoffeeScriptSyntaxHighlighter.COMMA), new AttributesDescriptor("Semicolon", CoffeeScriptSyntaxHighlighter.SEMICOLON), new AttributesDescriptor("Parenthesis", CoffeeScriptSyntaxHighlighter.PARENTHESIS), new AttributesDescriptor("Brackets", CoffeeScriptSyntaxHighlighter.BRACKETS), new AttributesDescriptor("Braces", CoffeeScriptSyntaxHighlighter.BRACES), new AttributesDescriptor("Line comment", CoffeeScriptSyntaxHighlighter.LINE_COMMENT), new AttributesDescriptor("Block comment", CoffeeScriptSyntaxHighlighter.BLOCK_COMMENT), new AttributesDescriptor("Local variable", CoffeeScriptSyntaxHighlighter.LOCAL_VARIABLE), new AttributesDescriptor("Global variable", CoffeeScriptSyntaxHighlighter.GLOBAL_VARIABLE), new AttributesDescriptor("Class", CoffeeScriptSyntaxHighlighter.CLASS_NAME), new AttributesDescriptor("Function name", CoffeeScriptSyntaxHighlighter.FUNCTION_NAME), new AttributesDescriptor("Function arrow", CoffeeScriptSyntaxHighlighter.FUNCTION_ARROW), new AttributesDescriptor("Function binding arrow", CoffeeScriptSyntaxHighlighter.FUNCTION_BINDING_ARROW), new AttributesDescriptor("Object key", CoffeeScriptSyntaxHighlighter.OBJECT_KEY), new AttributesDescriptor("Number", CoffeeScriptSyntaxHighlighter.NUMBER), new AttributesDescriptor("Boolean", CoffeeScriptSyntaxHighlighter.BOOLEAN), new AttributesDescriptor("String literal", CoffeeScriptSyntaxHighlighter.STRING_LITERAL), new AttributesDescriptor("Expression substitution mark", CoffeeScriptSyntaxHighlighter.EXPRESSIONS_SUBSTITUTION_MARK), new AttributesDescriptor("Escape sequence", CoffeeScriptSyntaxHighlighter.ESCAPE_SEQUENCE), new AttributesDescriptor("This references", CoffeeScriptSyntaxHighlighter.THIS), new AttributesDescriptor("Prototype", CoffeeScriptSyntaxHighlighter.PROTOTYPE), new AttributesDescriptor("Operations", CoffeeScriptSyntaxHighlighter.OPERATIONS), new AttributesDescriptor("Existential operator", CoffeeScriptSyntaxHighlighter.EXISTENTIAL), new AttributesDescriptor("Keyword", CoffeeScriptSyntaxHighlighter.KEYWORD), new AttributesDescriptor("Range", CoffeeScriptSyntaxHighlighter.RANGE), new AttributesDescriptor("Splat", CoffeeScriptSyntaxHighlighter.SPLAT), new AttributesDescriptor("Parameter", CoffeeScriptSyntaxHighlighter.PARAMETER), new AttributesDescriptor("Regular expression id", CoffeeScriptSyntaxHighlighter.REGULAR_EXPRESSION_ID), new AttributesDescriptor("Regular expression content", CoffeeScriptSyntaxHighlighter.REGULAR_EXPRESSION_CONTENT), new AttributesDescriptor("Regular expression flag", CoffeeScriptSyntaxHighlighter.REGULAR_EXPRESSION_FLAG), new AttributesDescriptor("Heredoc id", CoffeeScriptSyntaxHighlighter.HEREDOC_ID), new AttributesDescriptor("Heredoc content", CoffeeScriptSyntaxHighlighter.HEREDOC_CONTENT), new AttributesDescriptor("Heregex id", CoffeeScriptSyntaxHighlighter.HEREGEX_ID), new AttributesDescriptor("Heregex content", CoffeeScriptSyntaxHighlighter.HEREGEX_CONTENT), new AttributesDescriptor("Javascript injection", CoffeeScriptSyntaxHighlighter.JAVASCRIPT_INJECTION), new AttributesDescriptor("Javascript injection quote", CoffeeScriptSyntaxHighlighter.JAVASCRIPT_INJECTION_QUOTE)};
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();

    @NotNull
    public String getDisplayName() {
        if ("CoffeeScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/highlighter/CoffeeScriptColorSettingsPage", "getDisplayName"));
        }
        return "CoffeeScript";
    }

    public Icon getIcon() {
        return CoffeescriptIcons.Coffeescript;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/highlighter/CoffeeScriptColorSettingsPage", "getAttributeDescriptors"));
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/highlighter/CoffeeScriptColorSettingsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public CoffeeScriptSyntaxHighlighter getHighlighter() {
        CoffeeScriptSyntaxHighlighter coffeeScriptSyntaxHighlighter = new CoffeeScriptSyntaxHighlighter();
        if (coffeeScriptSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/highlighter/CoffeeScriptColorSettingsPage", "getHighlighter"));
        }
        return coffeeScriptSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("###\nSome tests\n###\nclass <cl>Animal</cl>\n  <fn>constructor</fn>: (<p>@name</p>) -> \n  <fn>move</fn>: (<p>meters</p>) -> alert @name + \" moved \" + meters + \"m.\"\n\nclass <cl>Snake</cl> extends <cl>Animal</cl>\n  <fn>move</fn>: -> \n    alert 'Slithering...'\n    super 5\n\n<gv>number</gv>   = 42; <gv>opposite</gv> = true\n\n/^a\\/\\\\[a-z/\\n]\\u00A3b$/.test 'a//b'\n\n<gv>square</gv> = (<p>x</p>) -> x * x\n\n<gv>range</gv> = [1..2]\n<gv>list</gv> = [1...5]\n\n<gv>math</gv> =\n  <ok>root</ok>:   Math.sqrt\n  <fn>cube</fn>:   (x) => x * square x\n\n<gv>race</gv> = (<p>winner</p>, <p>runners</p>...) ->\n  print winner, runners\n\nalert \"I knew it!\" if elvis?\n\n<gv>cubes</gv> = math.cube num for <lv>num</lv> in list\n\n<gv>text</gv> = \"\"\"\n Result \n    is #{ @number }\"\"\"\n\n<gv>html</gv> = ''' <body></body>'''\n\nString::dasherize = ->\n  this.replace /_/g, \"-\"\n<gv>SINGERS</gv> = {Jagger: \"Rock\", Elvis: \"Roll\"}\n\n<gv>t</gv> = ///\n[a-z]\n///\n\n$('.shopping_cart').bind 'click', (event) =>\n    @customer.purchase @cart\n\n<gv>hi</gv> = `function() {\n  return [document.title, \"Hello JavaScript\"].join(\": \");\n}`" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/highlighter/CoffeeScriptColorSettingsPage", "getDemoText"));
        }
        return "###\nSome tests\n###\nclass <cl>Animal</cl>\n  <fn>constructor</fn>: (<p>@name</p>) -> \n  <fn>move</fn>: (<p>meters</p>) -> alert @name + \" moved \" + meters + \"m.\"\n\nclass <cl>Snake</cl> extends <cl>Animal</cl>\n  <fn>move</fn>: -> \n    alert 'Slithering...'\n    super 5\n\n<gv>number</gv>   = 42; <gv>opposite</gv> = true\n\n/^a\\/\\\\[a-z/\\n]\\u00A3b$/.test 'a//b'\n\n<gv>square</gv> = (<p>x</p>) -> x * x\n\n<gv>range</gv> = [1..2]\n<gv>list</gv> = [1...5]\n\n<gv>math</gv> =\n  <ok>root</ok>:   Math.sqrt\n  <fn>cube</fn>:   (x) => x * square x\n\n<gv>race</gv> = (<p>winner</p>, <p>runners</p>...) ->\n  print winner, runners\n\nalert \"I knew it!\" if elvis?\n\n<gv>cubes</gv> = math.cube num for <lv>num</lv> in list\n\n<gv>text</gv> = \"\"\"\n Result \n    is #{ @number }\"\"\"\n\n<gv>html</gv> = ''' <body></body>'''\n\nString::dasherize = ->\n  this.replace /_/g, \"-\"\n<gv>SINGERS</gv> = {Jagger: \"Rock\", Elvis: \"Roll\"}\n\n<gv>t</gv> = ///\n[a-z]\n///\n\n$('.shopping_cart').bind 'click', (event) =>\n    @customer.purchase @cart\n\n<gv>hi</gv> = `function() {\n  return [document.title, \"Hello JavaScript\"].join(\": \");\n}`";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    static {
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("cl", CoffeeScriptSyntaxHighlighter.CLASS_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("ok", CoffeeScriptSyntaxHighlighter.OBJECT_KEY);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("fn", CoffeeScriptSyntaxHighlighter.FUNCTION_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("lv", CoffeeScriptSyntaxHighlighter.LOCAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("gv", CoffeeScriptSyntaxHighlighter.GLOBAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("p", CoffeeScriptSyntaxHighlighter.PARAMETER);
    }
}

