/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.refactoring.surround.CoffeeScriptBaseSurrounder;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptWithFunctionSurrounder
extends CoffeeScriptBaseSurrounder {
    @Override
    protected String getStatementTemplate(PsiElement context) {
        return "->\n  body";
    }

    @Override
    @NotNull
    protected ASTNode getNodeToReplace(ASTNode surroundedNode) {
        JSFunction function = (JSFunction)surroundedNode.getPsi().getChildren()[0];
        int bodyIndex = 0;
        if (function.getChildren()[0] instanceof JSParameterList) {
            ++bodyIndex;
        }
        ASTNode aSTNode = function.getChildren()[bodyIndex].getChildren()[0].getNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/refactoring/surround/CoffeeScriptWithFunctionSurrounder", "getNodeToReplace"));
        }
        return aSTNode;
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        int startOffset = statementNode.getPsi().getChildren()[0].getTextOffset();
        int endOffset = startOffset + statementNode.getPsi().getChildren()[0].getTextLength();
        return new TextRange(endOffset, endOffset);
    }

    public String getTemplateDescription() {
        return CsBundle.message("surrounder.function", new Object[0]);
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/coffeescript/refactoring/surround/CoffeeScriptWithFunctionSurrounder", "isApplicable"));
        }
        return true;
    }
}

