/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.run.before;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.UIUtil;
import icons.CoffeescriptIcons;
import java.io.File;
import javax.swing.Icon;
import org.coffeescript.CsBundle;
import org.coffeescript.compiler.CoffeeScriptCompiler;
import org.coffeescript.run.before.CoffeeScriptSourceMapsBeforeRunSettingsDialog;
import org.coffeescript.run.before.CoffeeScriptSourceMapsTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptSourceMapTaskProvider
extends BeforeRunTaskProvider<CoffeeScriptSourceMapsTask> {
    public static final Key<CoffeeScriptSourceMapsTask> ID = Key.create((String)"CoffeeScriptSourceMapTask");

    public Key<CoffeeScriptSourceMapsTask> getId() {
        return ID;
    }

    public String getName() {
        return CsBundle.message("source.maps.task.name", new Object[0]);
    }

    public String getDescription(CoffeeScriptSourceMapsTask task) {
        return CsBundle.message("source.maps.task.description", task.getPathToGenerateSourceMaps());
    }

    @Nullable
    public Icon getIcon() {
        return CoffeescriptIcons.Coffeescript;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public CoffeeScriptSourceMapsTask createTask(RunConfiguration runConfiguration) {
        return new CoffeeScriptSourceMapsTask();
    }

    public boolean configureTask(RunConfiguration runConfiguration, CoffeeScriptSourceMapsTask task) {
        String relativePath = CoffeeScriptSourceMapsBeforeRunSettingsDialog.showDialog(runConfiguration.getProject(), task.getPathToGenerateSourceMaps());
        if (StringUtil.isEmpty((String)relativePath)) {
            task.setRelativePathToGenerateSourceMaps("");
            return false;
        }
        task.setRelativePathToGenerateSourceMaps(relativePath);
        return true;
    }

    public boolean canExecuteTask(RunConfiguration configuration, CoffeeScriptSourceMapsTask task) {
        File directoryToGenerateSourceMaps = new File(task.getPathToGenerateSourceMaps());
        return directoryToGenerateSourceMaps.exists() && directoryToGenerateSourceMaps.isDirectory();
    }

    public boolean executeTask(DataContext context, final RunConfiguration configuration, ExecutionEnvironment env, CoffeeScriptSourceMapsTask task) {
        PsiManager psiManager = PsiManager.getInstance((Project)configuration.getProject());
        File directoryToGenerateSourceMaps = new File(task.getPathToGenerateSourceMaps());
        assert (directoryToGenerateSourceMaps.exists() && directoryToGenerateSourceMaps.isDirectory());
        final VirtualFile vFile = VfsUtil.findFileByIoFile((File)directoryToGenerateSourceMaps, (boolean)true);
        assert (vFile != null);
        final Ref refPsiDirectory = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> refPsiDirectory.set((Object)psiManager.findDirectory(vFile)));
        assert (refPsiDirectory.get() != null);
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)new Task.Modal(configuration.getProject(), CsBundle.message("source.maps.task.execution.description", vFile.getPath()), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/coffeescript/run/before/CoffeeScriptSourceMapTaskProvider$1$1", "run"));
                        }
                        CoffeeScriptCompiler.compileDirectory((PsiDirectory)refPsiDirectory.get(), indicator);
                    }
                });
            }
        });
        return true;
    }
}

