/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.deleteattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.deleteattribute.DeleteAttribute;
import com.sixrr.xrp.deleteattribute.DeleteAttributeUsageViewDescriptor;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DeleteAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final Context context;

    DeleteAttributeProcessor(XmlAttribute attribute, Context context, boolean previewUsages) {
        super(attribute.getProject(), previewUsages);
        this.attribute = attribute;
        this.context = context;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/deleteattribute/DeleteAttributeProcessor", "createUsageViewDescriptor"));
        }
        DeleteAttributeUsageViewDescriptor deleteAttributeUsageViewDescriptor = new DeleteAttributeUsageViewDescriptor(this.attribute, usageInfos);
        if (deleteAttributeUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/deleteattribute/DeleteAttributeProcessor", "createUsageViewDescriptor"));
        }
        return deleteAttributeUsageViewDescriptor;
    }

    @Override
    public void findUsages(List<XRPUsageInfo> usages) {
        XmlTag tag = this.attribute.getParent();
        String tagName = tag.getName();
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (xmlTag.getAttribute(attributeName, attributeNamespace) == null) continue;
            usages.add(new DeleteAttribute(xmlTag, attributeName, attributeNamespace));
        }
    }

    protected String getCommandName() {
        return "Delete attribute " + this.attribute.getName();
    }
}

