/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;

class RequestMappingUtil {
    RequestMappingUtil() {
    }

    static RequestMethod[] getAllRequestMethods(RequestMapping.Method requestMapping) {
        Object[] methods = requestMapping.getLocalMethods();
        RequestMapping<PsiClass> classLevelMapping = requestMapping.getClassLevelMapping();
        if (classLevelMapping == null) {
            return methods;
        }
        LinkedHashSet allRequestMethods = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAll((Collection)allRequestMethods, (Object[])classLevelMapping.getMethods());
        ContainerUtil.addAll((Collection)allRequestMethods, (Object[])methods);
        return (RequestMethod[])ArrayUtil.toObjectArray((Collection)allRequestMethods, RequestMethod.class);
    }

    static RequestMapping<PsiClass> getClassLevelMapping(RequestMapping.Method requestMapping) {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType(requestMapping.getPsiElement(), PsiClass.class);
        if (containingClass == null) {
            return null;
        }
        return (RequestMapping)JamService.getJamService((Project)containingClass.getProject()).getJamElement(RequestMapping.CLASS_JAM_KEY, (PsiElement)containingClass);
    }
}

