/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.admin.JavaeeAdminClientImpl;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatModuleDeploymentModel;
import org.jetbrains.idea.tomcat.admin.TomEEAgentAdminServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminServerBase;
import org.jetbrains.idea.tomcat.server.TomcatIntegration;
import org.jetbrains.idea.tomcat.server.tomee.TomeeExtensions;

public abstract class TomcatServerModel
extends JavaeeServerModel {
    @NonNls
    private static final String TOMCAT_LOCALHOST_LOG_NAME = "Tomcat Localhost";
    @NonNls
    private static final String TOMCAT_LOCALHOST_LOG_ID = "Tomcat";
    @NonNls
    protected static final String COMPATIBLE_TOMCAT_LOCALHOST_LOG_ID = "TOMCAT_LOCALHOST_LOG_ID";
    public static final int DEFAULT_JNDI_PORT = 1099;

    protected String getDefaultUsername() {
        return "";
    }

    protected String getDefaultPassword() {
        return "";
    }

    protected int getServerPort() {
        return this.getJndiPort();
    }

    public int getPingPort() {
        return this.isUseJmx() ? this.getServerPort() : this.getCommonModel().getPort();
    }

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        TomEEAgentAdminServerImpl tomEEAgent = this.isTomEE() ? new TomEEAgentAdminServerImpl((AgentProxyFactory)new ProcessAgentProxyFactory(serverInstance), this.getLibraries()) : null;
        return new JavaeeAdminClientImpl(this.createTomcatServerAdmin(serverInstance, tomEEAgent));
    }

    protected List<File> getLibraries() throws ExecutionException {
        List libraries = super.getLibraries();
        libraries.add(this.getPathUnderHome("lib"));
        return libraries;
    }

    protected abstract TomcatAdminServerBase<?> createTomcatServerAdmin(JavaeeServerInstance var1, TomEEAgentAdminServerImpl var2) throws Exception;

    protected String getLogFileId() {
        return TOMCAT_LOCALHOST_LOG_ID;
    }

    protected List<JavaeeServerModel.LogFileFactory> getLogFileFactories() {
        return Arrays.asList(new JavaeeServerModel.LogFileFactory[]{new TomcatDefaultLocalhostLogFileFactory(), new TomcatCompatibleLocalhostLogFileFactory()});
    }

    public Project getProject() {
        return this.getCommonModel().getProject();
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        HashSet<String> contexts = new HashSet<String>();
        boolean tomEE = this.isTomEE();
        for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
            Artifact artifact;
            TomcatModuleDeploymentModel model = (TomcatModuleDeploymentModel)deploymentModel;
            if (model.isEEArtifact()) {
                if (!tomEE) {
                    throw new RuntimeConfigurationError(TomcatBundle.message("error.unsupported.artifact.type", new Object[0]));
                }
            } else if (!contexts.add(model.CONTEXT_PATH)) {
                throw new RuntimeConfigurationError(TomcatBundle.message("error.duplicate.context.path.text", model.CONTEXT_PATH));
            }
            if ((artifact = model.getArtifact()) == null || !ExplodedEarArtifactType.getInstance().equals(artifact.getArtifactType())) continue;
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.getProject());
            final PackagingElementResolvingContext resolvingContext = artifactManager.getResolvingContext();
            final Ref errorRef = new Ref();
            Processor processor = new Processor<PackagingElement<?>>(){

                public boolean process(PackagingElement<?> element) {
                    DirectoryPackagingElement packagingDir;
                    if (element instanceof DirectoryPackagingElement && this.isContainingExplodedWar(packagingDir = (DirectoryPackagingElement)element, resolvingContext)) {
                        String packageDirName = packagingDir.getDirectoryName();
                        if (TomeeExtensions.getInstance().isValidExtension((ArtifactType)WarArtifactType.getInstance(), FileUtilRt.getExtension((String)packageDirName))) {
                            String message = TomcatBundle.message("error.wrong.exploded.war.dir.name", packageDirName);
                            RuntimeConfigurationError error = new RuntimeConfigurationError(message);
                            error.setQuickFix(() -> ModulesConfigurator.showArtifactSettings((Project)TomcatServerModel.this.getCommonModel().getProject(), (Artifact)artifact));
                            errorRef.set((Object)error);
                        }
                    }
                    return true;
                }

                private boolean isContainingExplodedWar(DirectoryPackagingElement packagingDir, PackagingElementResolvingContext context) {
                    for (PackagingElement packagingElement : packagingDir.getChildren()) {
                        Artifact nestedArtifact;
                        if (!(packagingElement instanceof ArtifactPackagingElement) || (nestedArtifact = ((ArtifactPackagingElement)packagingElement).findArtifact(context)) == null || !ExplodedWarArtifactType.getInstance().equals(nestedArtifact.getArtifactType())) continue;
                        return true;
                    }
                    return false;
                }
            };
            ArtifactUtil.processRecursivelySkippingIncludedArtifacts((Artifact)artifact, (Processor)processor, (PackagingElementResolvingContext)resolvingContext);
            if (errorRef.isNull()) continue;
            throw (RuntimeConfigurationError)errorRef.get();
        }
    }

    public ApplicationServer getApplicationServer() {
        return this.getCommonModel().getApplicationServer();
    }

    public boolean versionHigher(int major, int minor, int micro) {
        return new Version(this.getVersion()).compare(major, minor, micro) >= 0;
    }

    public boolean isVersion5OrHigher() {
        return this.versionHigher(5, 0, 0);
    }

    public boolean isVersion7OrHigher() {
        return this.versionHigher(7, 0, 0);
    }

    public boolean isVersion8OrHigher() {
        return this.versionHigher(8, 0, 0);
    }

    public boolean isUseJmx() {
        return this.isVersion5OrHigher();
    }

    public boolean isTomEE() {
        return TomcatIntegration.isTomEE(this.getHome());
    }

    public boolean undeployBeforeDeploy(DeploymentModel deploymentModel) {
        return this.isTomEE() && this.useTomEEDeployer(deploymentModel);
    }

    public boolean useTomEEDeployer(DeploymentModel deploymentModel) {
        return this.versionHigher(7, 0, 34) || ((TomcatModuleDeploymentModel)deploymentModel).isEEArtifact();
    }

    public boolean isVersionHigher6032() throws IOException {
        return this.versionHigher(6, 0, 32);
    }

    protected abstract int getJndiPort();

    private class TomcatCompatibleLocalhostLogFileFactory
    extends TomcatDefaultLocalhostLogFileFactory {
        private TomcatCompatibleLocalhostLogFileFactory() {
        }

        public String getId() {
            return TomcatServerModel.COMPATIBLE_TOMCAT_LOCALHOST_LOG_ID;
        }
    }

    private class TomcatDefaultLocalhostLogFileFactory
    extends JavaeeServerModel.DefaultLogFileFactory {
        private TomcatDefaultLocalhostLogFileFactory() {
            super((JavaeeServerModel)TomcatServerModel.this);
        }

        protected String getName() {
            return TomcatServerModel.TOMCAT_LOCALHOST_LOG_NAME;
        }
    }
}

