/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.SetupFlexModuleWizardStep;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.ui.CreateHtmlWrapperTemplateDialog;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunConfigurationType;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FlexModuleBuilder
extends ModuleBuilder {
    private TargetPlatform myTargetPlatform = TargetPlatform.Web;
    private boolean isPureActionScript = false;
    private OutputType myOutputType = OutputType.Application;
    private boolean myAndroidEnabled;
    private boolean myIOSEnabled;
    private Sdk myFlexSdk;
    private String myTargetPlayer;
    private boolean myCreateSampleApp;
    private String mySampleAppName;
    private boolean myCreateHtmlWrapperTemplate;
    private boolean myEnableHistory;
    private boolean myCheckPlayerVersion;
    private boolean myExpressInstall;

    public ModuleType getModuleType() {
        return FlexModuleType.getInstance();
    }

    public void setTargetPlatform(TargetPlatform targetPlatform) {
        this.myTargetPlatform = targetPlatform;
    }

    public void setPureActionScript(boolean pureActionScript) {
        this.isPureActionScript = pureActionScript;
    }

    public void setOutputType(OutputType outputType) {
        this.myOutputType = outputType;
    }

    public void setAndroidEnabled(boolean enabled) {
        this.myAndroidEnabled = enabled;
    }

    public void setIOSEnabled(boolean enabled) {
        this.myIOSEnabled = enabled;
    }

    public void setFlexSdk(Sdk flexSdk) {
        this.myFlexSdk = flexSdk;
    }

    public void setTargetPlayer(String targetPlayer) {
        this.myTargetPlayer = targetPlayer;
    }

    public void setCreateSampleApp(boolean createSampleApp) {
        this.myCreateSampleApp = createSampleApp;
    }

    public void setSampleAppName(String sampleAppName) {
        this.mySampleAppName = sampleAppName;
    }

    public void setCreateHtmlWrapperTemplate(boolean createHtmlWrapperTemplate) {
        this.myCreateHtmlWrapperTemplate = createHtmlWrapperTemplate;
    }

    public void setHtmlWrapperTemplateParameters(boolean enableHistory, boolean checkPlayerVersion, boolean expressInstall) {
        this.myEnableHistory = enableHistory;
        this.myCheckPlayerVersion = checkPlayerVersion;
        this.myExpressInstall = expressInstall;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        ContentEntry contentEntry = this.doAddContentEntry(modifiableRootModel);
        if (contentEntry == null) {
            return;
        }
        VirtualFile sourceRoot = this.createSourceRoot(contentEntry);
        Module module = modifiableRootModel.getModule();
        FlexProjectConfigurationEditor currentFlexEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        boolean needToCommitFlexEditor = currentFlexEditor == null;
        FlexProjectConfigurationEditor flexConfigEditor = currentFlexEditor != null ? currentFlexEditor : FlexProjectConfigurationEditor.createEditor(module.getProject(), Collections.singletonMap(module, modifiableRootModel), null, null);
        ModifiableFlexBuildConfiguration[] configurations = flexConfigEditor.getConfigurations(module);
        assert (configurations.length == 1);
        ModifiableFlexBuildConfiguration bc = configurations[0];
        this.setupBC(modifiableRootModel, bc);
        if (bc.getOutputType() == OutputType.Application) {
            FlexModuleBuilder.createRunConfiguration(module, bc);
        }
        if (sourceRoot != null && this.myCreateSampleApp && this.myFlexSdk != null) {
            try {
                boolean flex4 = !FlexSdkUtils.isAirSdkWithoutFlex(this.myFlexSdk) && StringUtil.compareVersionNumbers((String)this.myFlexSdk.getVersionString(), (String)"4") >= 0;
                FlexUtils.createSampleApp(module.getProject(), sourceRoot, this.mySampleAppName, this.myTargetPlatform, flex4);
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex.getMessage());
            }
        }
        if (this.myCreateHtmlWrapperTemplate && this.myFlexSdk != null) {
            String path = VfsUtilCore.urlToPath((String)contentEntry.getUrl()) + "/" + "html-template";
            if (CreateHtmlWrapperTemplateDialog.createHtmlWrapperTemplate(module.getProject(), this.myFlexSdk, path, this.myEnableHistory, this.myCheckPlayerVersion, this.myExpressInstall)) {
                bc.setUseHtmlWrapper(true);
                bc.setWrapperTemplatePath(path);
            }
        }
        if (needToCommitFlexEditor) {
            flexConfigEditor.commit();
        }
    }

    private void setupBC(ModifiableRootModel modifiableRootModel, ModifiableFlexBuildConfiguration bc) {
        Module module = modifiableRootModel.getModule();
        bc.setName(module.getName());
        bc.setTargetPlatform(this.myTargetPlatform);
        bc.setPureAs(this.isPureActionScript);
        bc.setOutputType(this.myOutputType);
        BuildConfigurationNature nature = bc.getNature();
        if (this.myCreateSampleApp) {
            String className = FileUtil.getNameWithoutExtension((String)this.mySampleAppName);
            bc.setMainClass(className);
            bc.setOutputFileName(className + (this.myOutputType == OutputType.Library ? ".swc" : ".swf"));
            if (nature.isApp()) {
                if (nature.isDesktopPlatform()) {
                    bc.getAirDesktopPackagingOptions().setPackageFileName(className);
                } else if (nature.isMobilePlatform()) {
                    bc.getAndroidPackagingOptions().setEnabled(this.myAndroidEnabled);
                    bc.getAndroidPackagingOptions().setPackageFileName(className);
                    bc.getIosPackagingOptions().setEnabled(this.myIOSEnabled);
                    bc.getIosPackagingOptions().setPackageFileName(className);
                }
            }
        } else {
            String fileName = PathUtil.suggestFileName((String)module.getName());
            bc.setOutputFileName(fileName + (this.myOutputType == OutputType.Library ? ".swc" : ".swf"));
            if (nature.isApp()) {
                if (nature.isDesktopPlatform()) {
                    bc.getAirDesktopPackagingOptions().setPackageFileName(fileName);
                } else if (nature.isMobilePlatform()) {
                    bc.getAndroidPackagingOptions().setEnabled(this.myAndroidEnabled);
                    bc.getAndroidPackagingOptions().setPackageFileName(fileName);
                    bc.getIosPackagingOptions().setEnabled(this.myIOSEnabled);
                    bc.getIosPackagingOptions().setPackageFileName(fileName);
                }
            }
        }
        bc.setOutputFolder(VfsUtilCore.urlToPath((String)((CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl()));
        bc.getDependencies().setSdkEntry(this.myFlexSdk != null ? Factory.createSdkEntry(this.myFlexSdk.getName()) : null);
        if (this.myTargetPlayer != null) {
            bc.getDependencies().setTargetPlayer(this.myTargetPlayer);
        }
    }

    public static void createRunConfiguration(Module module, FlexBuildConfiguration bc) {
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)module.getProject());
        List existingConfigurations = runManager.getConfigurationsList((ConfigurationType)FlashRunConfigurationType.getInstance());
        for (RunConfiguration configuration : existingConfigurations) {
            FlashRunnerParameters parameters = ((FlashRunConfiguration)configuration).getRunnerParameters();
            if (!module.getName().equals(parameters.getModuleName()) || !bc.getName().equals(parameters.getBCName())) continue;
            return;
        }
        RunnerAndConfigurationSettings settings = runManager.createConfiguration("", FlashRunConfigurationType.getFactory());
        FlashRunConfiguration runConfiguration = (FlashRunConfiguration)settings.getConfiguration();
        FlashRunnerParameters params = runConfiguration.getRunnerParameters();
        params.setModuleName(module.getName());
        params.setBCName(bc.getName());
        if (bc.getNature().isMobilePlatform()) {
            if (bc.getAndroidPackagingOptions().isEnabled()) {
                params.setAppDescriptorForEmulator(FlashRunnerParameters.AppDescriptorForEmulator.Android);
            } else if (bc.getIosPackagingOptions().isEnabled()) {
                params.setAppDescriptorForEmulator(FlashRunnerParameters.AppDescriptorForEmulator.IOS);
            }
        }
        settings.setName(params.suggestUniqueName(existingConfigurations));
        settings.setTemporary(false);
        runManager.addConfiguration(settings, false);
        runManager.setSelectedConfiguration(settings);
    }

    @Nullable
    private VirtualFile createSourceRoot(ContentEntry contentEntry) {
        final VirtualFile contentRoot = contentEntry.getFile();
        if (contentRoot == null) {
            return null;
        }
        VirtualFile sourceRoot = VfsUtil.findRelativeFile((VirtualFile)contentRoot, (String[])new String[]{"src"});
        if (sourceRoot == null) {
            sourceRoot = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<VirtualFile>(){

                public VirtualFile compute() {
                    try {
                        return contentRoot.createChildDirectory((Object)this, "src");
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        if (sourceRoot != null) {
            contentEntry.addSourceFolder(sourceRoot, false);
            return sourceRoot;
        }
        return null;
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new SetupFlexModuleWizardStep(this);
    }

    public String getParentGroup() {
        return "Static Web";
    }
}

