/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexUnitSupport {
    private static final Logger LOG = Logger.getInstance((String)FlexUnitSupport.class.getName());
    @NotNull
    public final JSClass flexUnit1TestClass;
    @Nullable
    public final JSClass flunitTestClass;
    @Nullable
    private final JSClass flunitTestSuite;
    public final boolean flexUnit4Present;
    private final JSClass flexUnit1TestSuite;
    public static final String FLEX_UNIT_1_TESTCASE_CLASS = "flexunit.framework.TestCase";
    public static final String FLEX_UNIT_1_TESTSUITE_CLASS = "flexunit.framework.TestSuite";
    public static final String FLEX_UNIT_4_CORE_CLASS = "org.flexunit.runner.FlexUnitCore";
    public static final String FLUNIT_TESTCASE_CLASS = "net.digitalprimates.fluint.tests.TestCase";
    public static final String FLUNIT_TESTSUITE_CLASS = "net.digitalprimates.fluint.tests.TestSuite";
    public static final String TEST_ATTRIBUTE = "Test";
    static final String IGNORE_ATTRIBUTE = "Ignore";
    public static final String SUITE_ATTRIBUTE = "Suite";
    public static final String RUN_WITH_ATTRIBUTE = "RunWith";
    public static final String SUITE_RUNNER = "org.flexunit.runners.Suite";

    private FlexUnitSupport(@NotNull JSClass flexUnit1TestClass, @NotNull JSClass flexUnit1TestSuiteClass, @Nullable JSClass flunitTestClass, @Nullable JSClass flunitTestSuite, boolean flexUnit4Present) {
        if (flexUnit1TestClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flexUnit1TestClass", "com/intellij/lang/javascript/flex/flexunit/FlexUnitSupport", "<init>"));
        }
        if (flexUnit1TestSuiteClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flexUnit1TestSuiteClass", "com/intellij/lang/javascript/flex/flexunit/FlexUnitSupport", "<init>"));
        }
        this.flexUnit1TestClass = flexUnit1TestClass;
        this.flexUnit1TestSuite = flexUnit1TestSuiteClass;
        this.flunitTestClass = flunitTestClass;
        this.flunitTestSuite = flunitTestSuite;
        this.flexUnit4Present = flexUnit4Present;
    }

    @Nullable
    public static Pair<Module, FlexUnitSupport> getModuleAndSupport(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/flex/flexunit/FlexUnitSupport", "getModuleAndSupport"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)context);
        FlexUnitSupport support = FlexUnitSupport.getSupport(module);
        return support != null ? Pair.create((Object)module, (Object)support) : null;
    }

    @Nullable
    public static FlexUnitSupport getSupport(@Nullable FlexBuildConfiguration bc, Module module) {
        if (bc == null) {
            return null;
        }
        return FlexUnitSupport.getSupport((GlobalSearchScope)FlexUtils.getModuleWithDependenciesAndLibrariesScope(module, bc, true));
    }

    @Nullable
    public static FlexUnitSupport getSupport(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        if (ModuleType.get((Module)module) != FlexModuleType.getInstance() || FlexUtils.getSdkForActiveBC(module) == null) {
            return null;
        }
        return FlexUnitSupport.getSupport(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }

    private static FlexUnitSupport getSupport(GlobalSearchScope searchScope) {
        PsiElement flexUnit1TestClass = ActionScriptClassResolver.findClassByQNameStatic(FLEX_UNIT_1_TESTCASE_CLASS, searchScope);
        if (!(flexUnit1TestClass instanceof JSClass)) {
            return null;
        }
        PsiElement flexUnit1TestSuiteClass = ActionScriptClassResolver.findClassByQNameStatic(FLEX_UNIT_1_TESTSUITE_CLASS, searchScope);
        if (!(flexUnit1TestSuiteClass instanceof JSClass)) {
            LOG.warn("flexunit.framework.TestCase class is present but flexunit.framework.TestSuite is not");
            return null;
        }
        boolean flexUnit4Present = ActionScriptClassResolver.findClassByQNameStatic(FLEX_UNIT_4_CORE_CLASS, searchScope) instanceof JSClass;
        PsiElement flunitTestClass = flexUnit4Present ? ActionScriptClassResolver.findClassByQNameStatic(FLUNIT_TESTCASE_CLASS, searchScope) : null;
        JSClass flunitTestSuiteClass = flunitTestClass instanceof JSClass ? (JSClass)ActionScriptClassResolver.findClassByQNameStatic(FLUNIT_TESTSUITE_CLASS, searchScope) : null;
        return new FlexUnitSupport((JSClass)flexUnit1TestClass, (JSClass)flexUnit1TestSuiteClass, (JSClass)flunitTestClass, flunitTestSuiteClass, flexUnit4Present);
    }

    public boolean isFlexUnit1Subclass(JSClass clazz) {
        return JSInheritanceUtil.isParentClass((JSClass)clazz, (JSClass)this.flexUnit1TestClass);
    }

    public boolean isFlexUnit1SuiteSubclass(JSClass clazz) {
        return JSInheritanceUtil.isParentClass((JSClass)clazz, (JSClass)this.flexUnit1TestSuite);
    }

    public boolean isFlunitSubclass(JSClass clazz) {
        return this.flunitTestClass != null && JSInheritanceUtil.isParentClass((JSClass)clazz, (JSClass)this.flunitTestClass);
    }

    public boolean isFlunitSuiteSubclass(JSClass clazz) {
        return this.flunitTestSuite != null && JSInheritanceUtil.isParentClass((JSClass)clazz, (JSClass)this.flunitTestSuite);
    }

    public boolean isPotentialTestClass(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/flex/flexunit/FlexUnitSupport", "isPotentialTestClass"));
        }
        if (this.isFlexUnit1Subclass(clazz) || this.isFlunitSubclass(clazz)) {
            return true;
        }
        for (JSFunction method : clazz.getFunctions()) {
            if (!this.isPotentialTestMethod(method)) continue;
            return true;
        }
        return false;
    }

    public boolean isPotentialTestMethod(JSFunction method) {
        if (method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
            return false;
        }
        PsiElement parent = method.getParent();
        if (parent instanceof JSClass && (this.isFlunitSubclass((JSClass)parent) || this.isFlexUnit1Subclass((JSClass)parent)) && method.getName() != null && method.getName().startsWith("test")) {
            return true;
        }
        return method.getAttributeList() != null && method.getAttributeList().getAttributesByName(TEST_ATTRIBUTE).length > 0 && method.getAttributeList().getAttributesByName(IGNORE_ATTRIBUTE).length == 0;
    }

    public boolean isTestClass(@NotNull JSClass clazz, boolean allowSuite) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/flex/flexunit/FlexUnitSupport", "isTestClass"));
        }
        if (clazz instanceof XmlBackedJSClassImpl) {
            return false;
        }
        if (clazz.getAttributeList() == null) {
            return false;
        }
        if (clazz.getAttributeList().getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        if (allowSuite && this.isSuite(clazz)) {
            return true;
        }
        boolean flexUnit1Subclass = this.isFlexUnit1Subclass(clazz);
        if (!flexUnit1Subclass && !this.flexUnit4Present) {
            return false;
        }
        if (FlexUnitSupport.getCustomRunner(clazz) == null) {
            for (JSFunction method : clazz.getFunctions()) {
                if (method.getKind() != JSFunction.FunctionKind.CONSTRUCTOR || !ValidateTypesUtil.hasRequiredParameters((JSFunction)method)) continue;
                return false;
            }
        }
        if (!flexUnit1Subclass && !this.isFlunitSubclass(clazz)) {
            boolean hasTests = false;
            for (JSFunction method : clazz.getFunctions()) {
                if (!this.isTestMethod(method)) continue;
                hasTests = true;
                break;
            }
            if (!hasTests) {
                return false;
            }
        }
        return true;
    }

    public boolean isSuite(JSClass clazz) {
        if (this.isFlexUnit1SuiteSubclass(clazz) || this.isFlunitSuiteSubclass(clazz)) {
            return true;
        }
        return this.flexUnit4Present && clazz.getAttributeList() != null && clazz.getAttributeList().getAttributesByName(SUITE_ATTRIBUTE).length > 0;
    }

    @Nullable
    public static String getCustomRunner(JSClass clazz) {
        JSAttribute[] attrs = clazz.getAttributeList().getAttributesByName(RUN_WITH_ATTRIBUTE);
        if (attrs.length == 0) {
            return null;
        }
        JSAttributeNameValuePair attr = attrs[0].getValueByName(null);
        return attr == null ? null : attr.getSimpleValue();
    }

    public boolean isTestMethod(JSFunction method) {
        if (!(method.getParent() instanceof JSClass) || method.getParent() instanceof XmlBackedJSClassImpl) {
            return false;
        }
        JSClass clazz = (JSClass)method.getParent();
        if (method.getName() == null) {
            return false;
        }
        if (this.flexUnit4Present && FlexUnitSupport.getCustomRunner(clazz) != null) {
            return true;
        }
        if (method.getAttributeList() == null) {
            return false;
        }
        if (method.getAttributeList().getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        if (method.getKind() != JSFunction.FunctionKind.SIMPLE) {
            return false;
        }
        if (method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC)) {
            return false;
        }
        if (ValidateTypesUtil.hasRequiredParameters((JSFunction)method)) {
            return false;
        }
        if (this.isFlexUnit1Subclass(clazz)) {
            if (!method.getName().startsWith("test")) {
                return false;
            }
        } else if (this.isFlunitSubclass(clazz)) {
            if (!method.getName().startsWith("test") && method.getAttributeList().getAttributesByName(TEST_ATTRIBUTE).length == 0) {
                return false;
            }
        } else {
            if (!this.flexUnit4Present) {
                return false;
            }
            JSType returnType = method.getReturnType();
            if (returnType != null && !(returnType instanceof JSVoidType)) {
                return false;
            }
            if (method.getAttributeList().getAttributesByName(IGNORE_ATTRIBUTE).length > 0) {
                return false;
            }
            if (method.getAttributeList().getAttributesByName(TEST_ATTRIBUTE).length == 0) {
                return false;
            }
        }
        return true;
    }

    public Collection<JSClass> getSuiteTestClasses(JSClass suiteClass) {
        if (!SUITE_RUNNER.equals(FlexUnitSupport.getCustomRunner(suiteClass))) {
            return Collections.emptyList();
        }
        ArrayList<JSClass> result = new ArrayList<JSClass>();
        for (JSField field : suiteClass.getFields()) {
            PsiElement type;
            PsiElement typeElement;
            if (field.getAttributeList() == null || field.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC) || field.getAttributeList().getAccessType() != JSAttributeList.AccessType.PUBLIC || !((typeElement = field.getTypeElement()) instanceof JSReferenceExpression) || !((type = ((JSReferenceExpression)typeElement).resolve()) instanceof JSClass)) continue;
            result.add((JSClass)type);
        }
        return result;
    }
}

