/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.presentation;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.javascript.flex.presentation.FlexTreeStructureProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FlexClassMemberNode
extends ProjectViewNode<JSElement> {
    public FlexClassMemberNode(JSElement element, ViewSettings settings) {
        super(element.getProject(), (Object)element, settings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/presentation/FlexClassMemberNode", "contains"));
        }
        return false;
    }

    public boolean canRepresent(Object element) {
        JSElement value = (JSElement)this.getValue();
        return value != null && value.isValid() && element instanceof JSElement && value.isEquivalentTo((PsiElement)element);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/presentation/FlexClassMemberNode", "getChildren"));
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        JSElement value = (JSElement)this.getValue();
        if (value == null || !value.isValid()) {
            return;
        }
        String text = value instanceof JSFunction ? JSFormatUtil.formatMethod((JSFunction)((JSFunction)value), (int)263, (int)2) : (value instanceof JSVariable ? JSFormatUtil.formatField((JSTypeDeclarationOwner)((JSVariable)value), (int)7) : value.getName());
        presentation.setPresentableText(text);
        presentation.setIcon(value.getIcon(1));
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        JSElement value = (JSElement)this.getValue();
        if (value != null && value.isValid()) {
            value.navigate(true);
        }
    }

    public int getTypeSortWeight(boolean sortByType) {
        int weight;
        if (sortByType && (weight = FlexTreeStructureProvider.getElementWeight((JSElement)this.getValue())) != -1) {
            return weight;
        }
        return super.getTypeSortWeight(sortByType);
    }
}

