/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.library.FlexLibraryProperties;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.FlexBCConfigurator;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.FlexCompositeSdk;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableSharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.AirDesktopPackagingOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.AndroidPackagingOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.BuildConfigurationEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationChangeListener;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationManagerImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexLibraryIdGenerator;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.IosPackagingOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.ModuleLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.NonStructuralModifiableBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.SharedLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexProjectConfigurationEditor
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)FlexProjectConfigurationEditor.class.getName());
    private boolean myDisposed;
    private final ProjectModifiableModelProvider myProvider;
    @Nullable
    private final Project myProject;
    private final Map<Module, List<Editor>> myModule2Editors = new HashMap();
    private final EventDispatcher<ModulesModelChangeListener> myModulesModelChangeEventDispatcher = EventDispatcher.create(ModulesModelChangeListener.class);

    public FlexProjectConfigurationEditor(@Nullable Project project, ProjectModifiableModelProvider provider) {
        this.myProject = project;
        this.myProvider = provider;
        provider.addListener(new FlexBCConfigurator.Listener(){

            @Override
            public void moduleRemoved(Module module) {
                if (!FlexProjectConfigurationEditor.isFlex(module)) {
                    return;
                }
                LOG.assertTrue(FlexProjectConfigurationEditor.this.myModule2Editors.containsKey(module), (Object)("Unknown module: " + module));
                FlexProjectConfigurationEditor.this.myModule2Editors.remove(module);
            }

            @Override
            public void buildConfigurationRemoved(FlexBCConfigurable configurable) {
                FlexProjectConfigurationEditor.this.configurationRemoved(configurable.getEditableObject());
            }

            @Override
            public void natureChanged(FlexBCConfigurable configurable) {
            }

            @Override
            public void buildConfigurationRenamed(FlexBCConfigurable configurable) {
            }
        }, this);
        for (Module module : provider.getModules()) {
            if (!FlexProjectConfigurationEditor.isFlex(module)) continue;
            this.addEditorsForModule(module);
        }
    }

    public static FlexProjectConfigurationEditor createEditor(Project project, Map<Module, ModifiableRootModel> moduleToModifiableModel, @Nullable LibraryTable.ModifiableModel projectLibrariesModel, @Nullable LibraryTable.ModifiableModel globalLibrariesModel) {
        LOG.assertTrue(FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor() == null, (Object)"Don't create FlexProjectConfigurationEditor when Project Structure dialog is open. Use FlexBCConfigurator.getConfigEditor()");
        ProjectModifiableModelProvider provider = FlexProjectConfigurationEditor.createModelProvider(moduleToModifiableModel, projectLibrariesModel, globalLibrariesModel);
        return new FlexProjectConfigurationEditor(project, provider);
    }

    public static ProjectModifiableModelProvider createModelProvider(final Map<Module, ModifiableRootModel> moduleToModifiableModel, final @Nullable LibraryTable.ModifiableModel projectLibrariesModel, final @Nullable LibraryTable.ModifiableModel globalLibrariesModel) {
        return new ProjectModifiableModelProvider(){

            @Override
            public Module[] getModules() {
                Set modules = moduleToModifiableModel.keySet();
                return modules.toArray(new Module[modules.size()]);
            }

            @Override
            public ModifiableRootModel getModuleModifiableModel(Module module) {
                ModifiableRootModel model = (ModifiableRootModel)moduleToModifiableModel.get(module);
                LOG.assertTrue(model != null, (Object)("No model for module " + module.getName()));
                return model;
            }

            @Override
            public void addListener(FlexBCConfigurator.Listener listener, Disposable parentDisposable) {
            }

            @Override
            public void commitModifiableModels() throws ConfigurationException {
            }

            @Override
            @Nullable
            public Library findSourceLibrary(String name, String level) {
                if ("application".equals(level)) {
                    return globalLibrariesModel.getLibraryByName(name);
                }
                if ("project".equals(level)) {
                    LOG.assertTrue(projectLibrariesModel != null);
                    return projectLibrariesModel.getLibraryByName(name);
                }
                LOG.error("Unexpected argument: " + level);
                return null;
            }

            @Override
            public Library findSourceLibraryForLiveName(String name, String level) {
                return this.findSourceLibrary(name, level);
            }
        };
    }

    public void configurationRemoved(@NotNull ModifiableFlexBuildConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexProjectConfigurationEditor", "configurationRemoved"));
        }
        this.assertAlive();
        Editor editor = (Editor)configuration;
        List<Editor> editors = this.myModule2Editors.get(editor.myModule);
        boolean contained = editors.remove(editor);
        LOG.assertTrue(contained);
    }

    public void addModulesModelChangeListener(ModulesModelChangeListener listener, Disposable parentDisposable) {
        this.myModulesModelChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    private void addEditorsForModule(Module module) {
        FlexBuildConfiguration[] buildConfigurations = FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations();
        ArrayList<Editor> configEditors = new ArrayList<Editor>(buildConfigurations.length);
        for (FlexBuildConfiguration buildConfiguration : buildConfigurations) {
            configEditors.add(new Editor(module, (FlexBuildConfigurationImpl)buildConfiguration, true));
        }
        this.myModule2Editors.put(module, configEditors);
    }

    public void dispose() {
        this.myDisposed = true;
        this.myModule2Editors.clear();
    }

    public ModifiableFlexBuildConfiguration[] getConfigurations(Module module) {
        this.assertAlive();
        List<Editor> editors = this.myModule2Editors.get(module);
        if (editors == null) {
            this.addEditorsForModule(module);
            editors = this.myModule2Editors.get(module);
        }
        return editors.toArray(new ModifiableFlexBuildConfiguration[editors.size()]);
    }

    private void assertAlive() {
        LOG.assertTrue(!this.myDisposed, (Object)"Already disposed");
    }

    public ModifiableFlexBuildConfiguration createConfiguration(Module module) {
        this.assertAlive();
        List<Editor> editors = this.myModule2Editors.get(module);
        Editor newConfig = new Editor(module, null, false);
        editors.add(newConfig);
        return newConfig;
    }

    public ModifiableFlexBuildConfiguration copyConfiguration(ModifiableFlexBuildConfiguration configuration, BuildConfigurationNature newNature) {
        this.assertAlive();
        Module module = ((Editor)configuration).myModule;
        List<Editor> editors = this.myModule2Editors.get(module);
        FlexBuildConfigurationImpl copy = ((Editor)configuration).getCopy();
        DependencyEntry[] entries = copy.getDependencies().getEntries();
        ModifiableRootModel modifiableModel = this.myProvider.getModuleModifiableModel(module);
        for (int i = 0; i < entries.length; ++i) {
            ModuleLibraryEntryImpl e;
            LibraryEx library;
            if (!(entries[i] instanceof ModuleLibraryEntryImpl) || (library = FlexProjectConfigurationEditor.findLibrary(modifiableModel, (e = (ModuleLibraryEntryImpl)entries[i]).getLibraryId())) == null) continue;
            LibraryEx libraryCopy = FlexProjectConfigurationEditor.copyModuleLibrary(modifiableModel, library);
            ModuleLibraryEntryImpl entryCopy = new ModuleLibraryEntryImpl(FlexProjectRootsUtil.getLibraryId((Library)libraryCopy));
            e.getDependencyType().applyTo(entryCopy.getDependencyType());
            copy.getDependencies().getModifiableEntries().set(i, entryCopy);
        }
        Editor newConfig = new Editor(module, copy, false);
        newConfig.setNature(newNature);
        FlexProjectConfigurationEditor.resetNonApplicableValuesToDefaults(newConfig);
        editors.add(newConfig);
        return newConfig;
    }

    private static LibraryEx copyModuleLibrary(ModifiableRootModel modifiableModel, LibraryEx library) {
        LibraryTable.ModifiableModel librariesModifiableModel = FlexProjectConfigurationEditor.getTableModifiableModel(modifiableModel);
        LibraryEx libraryCopy = (LibraryEx)librariesModifiableModel.createLibrary(library.getName(), library.getKind());
        LibraryEx.ModifiableModelEx libraryCopyModel = libraryCopy.getModifiableModel();
        LibraryEditingUtil.copyLibrary((LibraryEx)library, Collections.emptyMap(), (LibraryEx.ModifiableModelEx)libraryCopyModel);
        libraryCopyModel.setProperties((LibraryProperties)new FlexLibraryProperties(FlexLibraryIdGenerator.generateId()));
        libraryCopyModel.commit();
        return libraryCopy;
    }

    public static void resetNonApplicableValuesToDefaults(ModifiableFlexBuildConfiguration bc) {
        FlexBuildConfigurationImpl defaultConfiguration = new FlexBuildConfigurationImpl();
        BuildConfigurationNature nature = bc.getNature();
        if (bc.getOutputType() != OutputType.RuntimeLoadedModule) {
            bc.setOptimizeFor(defaultConfiguration.getOptimizeFor());
        }
        if (nature.isLib()) {
            bc.setMainClass(defaultConfiguration.getMainClass());
        }
        if (!nature.isWebPlatform() || !nature.isApp()) {
            bc.setUseHtmlWrapper(defaultConfiguration.isUseHtmlWrapper());
            bc.setWrapperTemplatePath(defaultConfiguration.getWrapperTemplatePath());
        }
        if (!BCUtils.canHaveRLMsAndRuntimeStylesheets(bc)) {
            bc.setRLMs(defaultConfiguration.getRLMs());
            bc.setCssFilesToCompile(defaultConfiguration.getCssFilesToCompile());
        }
        if (!ArrayUtil.contains((Object)bc.getDependencies().getFrameworkLinkage(), (Object[])BCUtils.getSuitableFrameworkLinkages(nature))) {
            bc.getDependencies().setFrameworkLinkage(defaultConfiguration.getDependencies().getFrameworkLinkage());
        }
        if (!nature.isWebPlatform()) {
            bc.getDependencies().setTargetPlayer(defaultConfiguration.getDependencies().getTargetPlayer());
        }
        if (nature.isMobilePlatform() || bc.isPureAs()) {
            bc.getDependencies().setComponentSet(defaultConfiguration.getDependencies().getComponentSet());
        }
        Iterator<ModifiableDependencyEntry> i = bc.getDependencies().getModifiableEntries().iterator();
        while (i.hasNext()) {
            FlexBuildConfiguration dependencyBC;
            ModifiableDependencyEntry entry = i.next();
            if (!(entry instanceof BuildConfigurationEntry) || (dependencyBC = ((BuildConfigurationEntry)((Object)entry)).findBuildConfiguration()) != null && FlexCommonUtils.checkDependencyType((OutputType)bc.getOutputType(), (OutputType)dependencyBC.getOutputType(), (LinkageType)entry.getDependencyType().getLinkageType())) continue;
            i.remove();
        }
        if (bc.getTargetPlatform() != TargetPlatform.Desktop || bc.getOutputType() != OutputType.Application) {
            ((AirDesktopPackagingOptionsImpl)defaultConfiguration.getAirDesktopPackagingOptions()).applyTo((AirDesktopPackagingOptionsImpl)bc.getAirDesktopPackagingOptions());
        }
        if (bc.getTargetPlatform() != TargetPlatform.Mobile || bc.getOutputType() != OutputType.Application) {
            ((AndroidPackagingOptionsImpl)defaultConfiguration.getAndroidPackagingOptions()).applyTo((AndroidPackagingOptionsImpl)bc.getAndroidPackagingOptions());
            ((IosPackagingOptionsImpl)defaultConfiguration.getIosPackagingOptions()).applyTo((IosPackagingOptionsImpl)bc.getIosPackagingOptions());
        }
        if (!nature.isLib()) {
            bc.getCompilerOptions().setFilesToIncludeInSWC(Collections.emptyList());
        }
    }

    public Module getModule(ModifiableFlexBuildConfiguration configuration) {
        this.assertAlive();
        return ((Editor)configuration).myModule;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void checkCanCommit() throws ConfigurationException {
        for (Module module : this.myModule2Editors.keySet()) {
            List<Editor> editors = this.myModule2Editors.get(module);
            HashSet<String> names = new HashSet<String>();
            for (Editor editor : editors) {
                if (names.add(editor.getName())) continue;
                throw new ConfigurationException("Duplicate build configuration name '" + editor.getName() + "' in module '" + module.getName() + "'");
            }
        }
    }

    public void commit() throws ConfigurationException {
        HashMap renamedConfigs = new HashMap();
        for (Module module2 : this.myModule2Editors.keySet()) {
            int n;
            ModifiableRootModel modifiableModel = this.myProvider.getModuleModifiableModel(module2);
            ArrayList<String> usedModulesLibrariesIds = new ArrayList<String>();
            LinkedHashMap<Object, Boolean> librariesToAdd = new LinkedHashMap<Object, Boolean>();
            HashSet<String> sdkNames = new HashSet<String>();
            for (Editor editor : this.myModule2Editors.get(module2)) {
                OrderEntry[] sdkEntry = editor.getDependencies().getSdkEntry();
                if (sdkEntry != null) {
                    sdkNames.add(sdkEntry.getName());
                }
                DependencyEntry[] dependencyEntryArray = editor.getDependencies().getEntries();
                int n2 = dependencyEntryArray.length;
                for (n = 0; n < n2; ++n) {
                    SharedLibraryEntry sharedLibraryEntry;
                    Library library;
                    DependencyEntry dependencyEntry = dependencyEntryArray[n];
                    if (dependencyEntry instanceof ModuleLibraryEntry) {
                        ModuleLibraryEntry moduleLibraryEntry = (ModuleLibraryEntry)dependencyEntry;
                        usedModulesLibrariesIds.add(moduleLibraryEntry.getLibraryId());
                    }
                    if (!(dependencyEntry instanceof SharedLibraryEntry) || (library = this.myProvider.findSourceLibraryForLiveName((sharedLibraryEntry = (SharedLibraryEntry)dependencyEntry).getLibraryName(), sharedLibraryEntry.getLibraryLevel())) == null) continue;
                    librariesToAdd.put(library, true);
                }
                String originalName = editor.getOriginalName();
                if (originalName == null || originalName.equals(editor.getName())) continue;
                renamedConfigs.put(Pair.create((Object)module2.getName(), (Object)originalName), editor.getName());
            }
            Object sdk = sdkNames.isEmpty() ? null : (sdkNames.size() == 1 ? FlexSdkUtils.findFlexOrFlexmojosSdk((String)sdkNames.iterator().next()) : new FlexCompositeSdk(ArrayUtil.toStringArray(sdkNames)));
            modifiableModel.setSdk(sdk);
            ArrayList<OrderEntry> entriesToRemove = new ArrayList<OrderEntry>();
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                LibraryEx library;
                if (!(orderEntry instanceof LibraryOrderEntry)) continue;
                if (((LibraryOrderEntry)orderEntry).isModuleLevel()) {
                    library = (LibraryEx)((LibraryOrderEntry)orderEntry).getLibrary();
                    if (!FlexProjectRootsUtil.isFlexLibrary((Library)library) || usedModulesLibrariesIds.contains(FlexProjectRootsUtil.getLibraryId((Library)library))) continue;
                    entriesToRemove.add(orderEntry);
                    continue;
                }
                library = (LibraryEx)((LibraryOrderEntry)orderEntry).getLibrary();
                if (librariesToAdd.containsKey(library)) {
                    librariesToAdd.put(library, false);
                    continue;
                }
                if (library == null || !FlexProjectRootsUtil.isFlexLibrary((Library)library)) continue;
                entriesToRemove.add(orderEntry);
            }
            for (OrderEntry e : entriesToRemove) {
                modifiableModel.removeOrderEntry(e);
            }
            for (Library library : librariesToAdd.keySet()) {
                if (((LibraryEx)library).isDisposed() || !((Boolean)librariesToAdd.get(library)).booleanValue() || this.myProvider.findSourceLibrary(library.getName(), library.getTable().getTableLevel()) == null) continue;
                modifiableModel.addLibraryEntry(library);
            }
            THashSet modulesToAdd = new THashSet();
            for (Editor editor : this.myModule2Editors.get(module2)) {
                for (DependencyEntry dependencyEntry : editor.getDependencies().getEntries()) {
                    Module dependencyModule;
                    if (!(dependencyEntry instanceof BuildConfigurationEntry) || (dependencyModule = this.findModuleWithBC((BuildConfigurationEntry)dependencyEntry)) == null || dependencyModule == module2) continue;
                    modulesToAdd.add(dependencyModule);
                }
            }
            List moduleOrderEntriesToRemove = ContainerUtil.filter((Object[])modifiableModel.getOrderEntries(), arg_0 -> FlexProjectConfigurationEditor.lambda$commit$0((Set)modulesToAdd, arg_0));
            for (OrderEntry orderEntry : moduleOrderEntriesToRemove) {
                modifiableModel.removeOrderEntry(orderEntry);
            }
            for (Module moduleToAdd : modulesToAdd) {
                modifiableModel.addModuleOrderEntry(moduleToAdd);
            }
            OrderEntry[] orderEntryArray = modifiableModel.getOrderEntries();
            n = orderEntryArray.length;
            for (int i = 0; i < n; ++i) {
                OrderEntry entry = orderEntryArray[i];
                if (!(entry instanceof ExportableOrderEntry)) continue;
                ((ExportableOrderEntry)entry).setExported(true);
            }
        }
        List modulesWithChangedModifiableModel = ContainerUtil.findAll(this.myModule2Editors.keySet(), module -> this.myProvider.getModuleModifiableModel((Module)module).isChanged());
        if (!modulesWithChangedModifiableModel.isEmpty()) {
            this.myProvider.commitModifiableModels();
            ((ModulesModelChangeListener)this.myModulesModelChangeEventDispatcher.getMulticaster()).modulesModelsChanged(modulesWithChangedModifiableModel);
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$commit$3((Map)renamedConfigs));
    }

    public boolean isModified() {
        if (this.myDisposed) {
            return false;
        }
        for (Module module : this.myModule2Editors.keySet()) {
            List<Editor> currentConfigurations;
            if (this.myProvider.getModuleModifiableModel(module).isChanged()) {
                return true;
            }
            FlexBuildConfiguration[] originalConfigurations = FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations();
            if (originalConfigurations.length != (currentConfigurations = this.myModule2Editors.get(module)).size()) {
                return true;
            }
            for (Editor currentConfiguration : currentConfigurations) {
                if (!currentConfiguration.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFlex(Module module) {
        return ModuleType.get((Module)module) == FlexModuleType.getInstance();
    }

    public ModifiableBuildConfigurationEntry createBcEntry(ModifiableDependencies dependant, ModifiableFlexBuildConfiguration dependency, @Nullable String dependencyCurrentName) {
        this.assertAlive();
        Module dependencyModule = ((Editor)dependency).myModule;
        BuildConfigurationEntryImpl e = new BuildConfigurationEntryImpl(dependencyModule, dependencyCurrentName != null ? dependencyCurrentName : dependency.getName());
        return e;
    }

    public ModifiableBuildConfigurationEntry createBcEntry(ModifiableDependencies dependant, String moduleName, String bcName) {
        this.assertAlive();
        Module dependantModule = this.getEditor(dependant).myModule;
        return new BuildConfigurationEntryImpl(dependantModule.getProject(), moduleName, bcName);
    }

    public ModifiableModuleLibraryEntry createModuleLibraryEntry(ModifiableDependencies dependant, String dependencyLibraryId) {
        this.assertAlive();
        ModuleLibraryEntryImpl e = new ModuleLibraryEntryImpl(dependencyLibraryId);
        Module dependantModule = this.getEditor(dependant).myModule;
        ModifiableRootModel modifiableModel = this.myProvider.getModuleModifiableModel(dependantModule);
        if (FlexProjectConfigurationEditor.findLibrary(modifiableModel, dependencyLibraryId) == null) {
            LOG.warn("Module library used in build configuration is missing");
        }
        return e;
    }

    public ModifiableDependencyEntry createSharedLibraryEntry(ModifiableDependencies dependencies, String libraryName, String libraryLevel) {
        this.assertAlive();
        return new SharedLibraryEntryImpl(libraryName, libraryLevel);
    }

    @Nullable
    private static LibraryEx findLibrary(ModifiableRootModel modifiableModel, String libraryId) {
        for (Library library : modifiableModel.getModuleLibraryTable().getLibraries()) {
            if (((LibraryEx)library).getKind() != FlexLibraryType.FLEX_LIBRARY || !libraryId.equals(FlexProjectRootsUtil.getLibraryId(library))) continue;
            return (LibraryEx)library;
        }
        return null;
    }

    public void setEntries(ModifiableDependencies dependant, List<? extends ModifiableDependencyEntry> newEntries) {
        this.assertAlive();
        HashMap existingModuleLibrariesEntries = new HashMap();
        HashMap existingBcEntries = new HashMap();
        HashMap existingSharedLibrariesEntries = new HashMap();
        for (ModifiableDependencyEntry entry : dependant.getModifiableEntries()) {
            ModifiableDependencyEntry e;
            if (entry instanceof ModuleLibraryEntry) {
                existingModuleLibrariesEntries.put(((ModuleLibraryEntry)((Object)entry)).getLibraryId(), entry);
                continue;
            }
            if (entry instanceof ModifiableSharedLibraryEntry) {
                e = (ModifiableSharedLibraryEntry)entry;
                existingSharedLibrariesEntries.put(Pair.create((Object)e.getLibraryLevel(), (Object)e.getLibraryName()), e);
                continue;
            }
            if (entry instanceof ModifiableBuildConfigurationEntry) {
                e = (ModifiableBuildConfigurationEntry)entry;
                existingBcEntries.put(Pair.create((Object)e.getModuleName(), (Object)e.getBcName()), e);
                continue;
            }
            assert (false) : entry;
        }
        ArrayList<ModifiableDependencyEntry> entriesToRemove = new ArrayList<ModifiableDependencyEntry>(dependant.getModifiableEntries());
        Iterator<? extends ModifiableDependencyEntry> i = newEntries.iterator();
        while (i.hasNext()) {
            ModifiableDependencyEntry newEntry = i.next();
            ModifiableDependencyEntry existingEntry = null;
            if (newEntry instanceof ModuleLibraryEntry) {
                existingEntry = (ModifiableDependencyEntry)existingModuleLibrariesEntries.get(((ModuleLibraryEntry)((Object)newEntry)).getLibraryId());
            } else if (newEntry instanceof SharedLibraryEntry) {
                SharedLibraryEntry sharedLibraryEntry = (SharedLibraryEntry)((Object)newEntry);
                existingEntry = (ModifiableDependencyEntry)existingSharedLibrariesEntries.get(Pair.create((Object)sharedLibraryEntry.getLibraryLevel(), (Object)sharedLibraryEntry.getLibraryName()));
            } else if (newEntry instanceof BuildConfigurationEntry) {
                BuildConfigurationEntry buildConfigurationEntry = (BuildConfigurationEntry)((Object)newEntry);
                existingEntry = (ModifiableDependencyEntry)existingBcEntries.get(Pair.create((Object)buildConfigurationEntry.getModuleName(), (Object)buildConfigurationEntry.getBcName()));
            } else assert (false) : newEntry;
            if (existingEntry == null) continue;
            entriesToRemove.remove(existingEntry);
            existingEntry.getDependencyType().copyFrom(newEntry.getDependencyType());
            i.remove();
        }
        Editor dependantEditor = this.getEditor(dependant);
        ModifiableRootModel dependantModifiableModel = this.myProvider.getModuleModifiableModel(dependantEditor.myModule);
        for (DependencyEntry dependencyEntry : entriesToRemove) {
            ModuleLibraryEntry libraryEntry;
            LibraryEx dependencyLibrary;
            if (!(dependencyEntry instanceof ModuleLibraryEntry) || (dependencyLibrary = FlexProjectConfigurationEditor.findLibrary(dependantModifiableModel, (libraryEntry = (ModuleLibraryEntry)dependencyEntry).getLibraryId())) == null) continue;
            ArrayList<Editor> otherEditors = new ArrayList<Editor>((Collection)this.myModule2Editors.get(dependantEditor.myModule));
            otherEditors.remove(dependantEditor);
            if (FlexProjectConfigurationEditor.libraryIsUsed(libraryEntry.getLibraryId(), otherEditors)) continue;
            LibraryOrderEntry orderEntry = dependantModifiableModel.findLibraryOrderEntry((Library)dependencyLibrary);
            LOG.assertTrue(orderEntry != null);
            dependantModifiableModel.removeOrderEntry((OrderEntry)orderEntry);
        }
        dependant.getModifiableEntries().removeAll(entriesToRemove);
        dependant.getModifiableEntries().addAll(newEntries);
    }

    private static boolean libraryIsUsed(String libraryId, List<Editor> editors) {
        for (Editor editor : editors) {
            for (ModifiableDependencyEntry entry : editor.getDependencies().getModifiableEntries()) {
                if (!(entry instanceof ModuleLibraryEntry) || !libraryId.equals(((ModuleLibraryEntry)((Object)entry)).getLibraryId())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected Module findModuleWithBC(BuildConfigurationEntry bcEntry) {
        Module dependencyModule = (Module)ContainerUtil.find(this.myModule2Editors.keySet(), module -> bcEntry.getModuleName().equals(module.getName()));
        if (dependencyModule == null) {
            return null;
        }
        Editor dependencyBC = (Editor)ContainerUtil.find((Iterable)this.myModule2Editors.get(dependencyModule), editor -> editor.getName().equals(bcEntry.getBcName()));
        return dependencyBC == null ? null : dependencyModule;
    }

    @Nullable
    public LibraryOrderEntry findLibraryOrderEntry(ModifiableDependencies dependencies, ModuleLibraryEntry moduleLibraryEntry) {
        this.assertAlive();
        ModifiableRootModel modifiableModel = this.myProvider.getModuleModifiableModel(this.getEditor(dependencies).myModule);
        LibraryEx library = FlexProjectConfigurationEditor.findLibrary(modifiableModel, moduleLibraryEntry.getLibraryId());
        return library != null ? modifiableModel.findLibraryOrderEntry((Library)library) : null;
    }

    public LibraryOrderEntry findLibraryOrderEntry(ModifiableDependencies dependencies, Library library) {
        ModifiableRootModel modifiableModel = this.myProvider.getModuleModifiableModel(this.getEditor(dependencies).myModule);
        return modifiableModel.findLibraryOrderEntry(library);
    }

    private Editor getEditor(ModifiableDependencies dependencies) {
        for (List<Editor> editors : this.myModule2Editors.values()) {
            for (Editor editor : editors) {
                if (editor.getDependencies() != dependencies) continue;
                return editor;
            }
        }
        throw new IllegalArgumentException("unknown dependencies instance");
    }

    public Module getModule(ModifiableDependencies dependencies) {
        this.assertAlive();
        return this.getEditor(dependencies).myModule;
    }

    public ModifiableRootModel getModifiableRootModel(Module module) {
        return this.myProvider.getModuleModifiableModel(module);
    }

    public LibraryTable.ModifiableModel getLibraryModel(ModifiableDependencies dependencies) {
        this.assertAlive();
        ModifiableRootModel modifiableModel = this.myProvider.getModuleModifiableModel(this.getEditor(dependencies).myModule);
        return FlexProjectConfigurationEditor.getTableModifiableModel(modifiableModel);
    }

    private static LibraryTable.ModifiableModel getTableModifiableModel(ModifiableRootModel modifiableModel) {
        return modifiableModel.getModuleLibraryTable().getModifiableModel();
    }

    public void addSdkListListener(ChangeListener changeListener, Disposable parentDisposable) {
    }

    @Nullable
    public FlexBuildConfiguration findCurrentConfiguration(Module module, String originalBCName) {
        return (FlexBuildConfiguration)ContainerUtil.find((Iterable)this.myModule2Editors.get(module), editor -> ((Editor)editor).myOrigin.getName().equals(originalBCName));
    }

    public static void makeNonStructuralModification(FlexBuildConfiguration bc, Consumer<NonStructuralModifiableBuildConfiguration> consumer) {
        consumer.consume((Object)new NonStructuralModifiableBuildConfiguration((FlexBuildConfigurationImpl)bc));
    }

    private /* synthetic */ void lambda$commit$3(Map renamedConfigs) {
        for (Module module : this.myModule2Editors.keySet()) {
            Function f = editor -> editor.commit();
            FlexBuildConfigurationImpl[] current = (FlexBuildConfigurationImpl[])ContainerUtil.map2Array((Collection)this.myModule2Editors.get(module), FlexBuildConfigurationImpl.class, (Function)f);
            ((FlexBuildConfigurationManagerImpl)FlexBuildConfigurationManager.getInstance(module)).setBuildConfigurations(current);
        }
        if (this.myProject != null) {
            FlexBuildConfigurationManagerImpl.resetHighlighting(this.myProject);
            if (!renamedConfigs.isEmpty()) {
                ((FlexBuildConfigurationChangeListener)this.myProject.getMessageBus().syncPublisher(FlexBuildConfigurationChangeListener.TOPIC)).buildConfigurationsRenamed(renamedConfigs);
            }
        }
    }

    private static /* synthetic */ boolean lambda$commit$0(Set modulesToAdd, OrderEntry orderEntry) {
        return orderEntry instanceof ModuleOrderEntry && !modulesToAdd.remove(((ModuleOrderEntry)orderEntry).getModule());
    }

    public static interface ModulesModelChangeListener
    extends EventListener {
        public void modulesModelsChanged(Collection<Module> var1);
    }

    public static interface ProjectModifiableModelProvider {
        public Module[] getModules();

        public ModifiableRootModel getModuleModifiableModel(Module var1);

        public void addListener(FlexBCConfigurator.Listener var1, Disposable var2);

        public void commitModifiableModels() throws ConfigurationException;

        @Nullable
        public Library findSourceLibraryForLiveName(String var1, String var2);

        @Nullable
        public Library findSourceLibrary(String var1, String var2);
    }

    private static class Editor
    extends FlexBuildConfigurationImpl {
        private final Module myModule;
        private final FlexBuildConfigurationImpl myOrigin;
        @Nullable
        private final String myOriginalName;

        Editor(Module module, @Nullable FlexBuildConfigurationImpl origin, boolean storeOriginalName) {
            this.myOrigin = origin != null ? origin : new FlexBuildConfigurationImpl();
            this.myOriginalName = storeOriginalName && origin != null ? origin.getName() : null;
            this.myModule = module;
            this.myOrigin.applyTo(this);
        }

        public FlexBuildConfigurationImpl commit() {
            this.applyTo(this.myOrigin);
            return this.myOrigin;
        }

        public boolean isModified() {
            return !this.isEqual(this.myOrigin);
        }

        @Nullable
        public String getOriginalName() {
            return this.myOriginalName;
        }
    }
}

