/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddBuildConfigurationDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myBCNameTextField;
    private JLabel myUpDownHint;
    private JComboBox myTargetPlatformCombo;
    private NonFocusableCheckBox myPureActionScriptCheckBox;
    private JComboBox myOutputTypeCombo;
    private JLabel myTargetDevicesLabel;
    private JCheckBox myAndroidCheckBox;
    private JCheckBox myIOSCheckBox;
    private final Collection<String> myUsedNames;

    public AddBuildConfigurationDialog(Project project, String dialogTitle, Collection<String> usedNames, BuildConfigurationNature defaultNature, boolean bcNameEditable) {
        super(project);
        this.myUsedNames = usedNames;
        this.$$$setupUI$$$();
        this.setTitle(dialogTitle);
        this.initCombos();
        this.myTargetPlatformCombo.setSelectedItem(defaultNature.targetPlatform);
        this.myPureActionScriptCheckBox.setSelected(defaultNature.pureAS);
        this.myOutputTypeCombo.setSelectedItem(defaultNature.outputType);
        this.myBCNameTextField.setEditable(bcNameEditable);
        this.myUpDownHint.setVisible(bcNameEditable);
        if (bcNameEditable) {
            this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
            this.myUpDownHint.setToolTipText(FlexBundle.message("bc.dialog.up.down.tooltip", new Object[0]));
            AnAction arrow = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (e.getInputEvent() instanceof KeyEvent) {
                        KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                        int code = keyEvent.getKeyCode();
                        AddBuildConfigurationDialog.this.scrollBy(code == 40 ? 1 : (code == 38 ? -1 : 0), (keyEvent.getModifiers() & 1) != 0);
                    }
                }
            };
            KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
            KeyboardShortcut upShift = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 64), null);
            KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
            KeyboardShortcut downShift = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 64), null);
            arrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down, upShift, downShift}), (JComponent)this.myBCNameTextField);
        }
        this.init();
        this.updateControls();
    }

    private void updateControls() {
        boolean mobile = this.myTargetPlatformCombo.getSelectedItem() == TargetPlatform.Mobile;
        boolean app = this.myOutputTypeCombo.getSelectedItem() == OutputType.Application;
        boolean targetDeviceWasEnabled = this.myTargetDevicesLabel.isEnabled();
        this.myTargetDevicesLabel.setEnabled(mobile && app);
        this.myAndroidCheckBox.setEnabled(mobile && app);
        this.myIOSCheckBox.setEnabled(mobile && app);
        if (this.myTargetDevicesLabel.isEnabled() && !targetDeviceWasEnabled) {
            this.myAndroidCheckBox.setSelected(true);
            this.myIOSCheckBox.setSelected(true);
        }
        if (!this.myTargetDevicesLabel.isEnabled()) {
            this.myAndroidCheckBox.setSelected(mobile);
            this.myIOSCheckBox.setSelected(mobile);
        }
    }

    private void scrollBy(int delta, boolean shiftPressed) {
        if (delta == 0) {
            return;
        }
        JComboBox combo = shiftPressed ? this.myOutputTypeCombo : this.myTargetPlatformCombo;
        int size = combo.getModel().getSize();
        int next = combo.getSelectedIndex() + delta;
        if (next < 0 || next >= size) {
            if (!UISettings.getInstance().CYCLE_SCROLLING) {
                return;
            }
            next = (next + size) % size;
        }
        combo.setSelectedIndex(next);
    }

    private void initCombos() {
        BCUtils.initTargetPlatformCombo(this.myTargetPlatformCombo);
        BCUtils.initOutputTypeCombo(this.myOutputTypeCombo);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddBuildConfigurationDialog.this.updateControls();
            }
        };
        this.myTargetPlatformCombo.addActionListener(actionListener);
        this.myOutputTypeCombo.addActionListener(actionListener);
    }

    public void reset(String bcName, boolean androidEnabled, boolean iosEnabled) {
        this.myBCNameTextField.setText(bcName);
        this.myAndroidCheckBox.setSelected(androidEnabled);
        this.myIOSCheckBox.setSelected(iosEnabled);
        this.updateControls();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBCNameTextField.isEditable() ? this.myBCNameTextField : this.myTargetPlatformCombo;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected ValidationInfo doValidate() {
        String name = this.getBCName();
        if (name.isEmpty()) {
            return new ValidationInfo("Empty name", (JComponent)this.myBCNameTextField);
        }
        for (String usedName : this.myUsedNames) {
            if (!name.equals(usedName)) continue;
            return new ValidationInfo(MessageFormat.format("Name ''{0}'' is already used", name), (JComponent)this.myBCNameTextField);
        }
        return null;
    }

    public String getBCName() {
        return this.myBCNameTextField.getText().trim();
    }

    public BuildConfigurationNature getNature() {
        TargetPlatform targetPlatform = (TargetPlatform)this.myTargetPlatformCombo.getSelectedItem();
        boolean isPureAs = this.myPureActionScriptCheckBox.isSelected();
        OutputType outputType = (OutputType)this.myOutputTypeCombo.getSelectedItem();
        return new BuildConfigurationNature(targetPlatform, isPureAs, outputType);
    }

    public boolean isAndroidEnabled() {
        return this.myAndroidCheckBox.isSelected();
    }

    public boolean isIOSEnabled() {
        return this.myIOSCheckBox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JLabel jLabel2;
        JComboBox jComboBox;
        JTextField jTextField;
        NonFocusableCheckBox nonFocusableCheckBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Target platform:");
        jLabel3.setDisplayedMnemonic('P');
        jLabel3.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetPlatformCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Web");
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPureActionScriptCheckBox = nonFocusableCheckBox = new NonFocusableCheckBox();
        nonFocusableCheckBox.setText("Pure ActionScript");
        nonFocusableCheckBox.setMnemonic('U');
        nonFocusableCheckBox.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)nonFocusableCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Configuration name:");
        jLabel4.setDisplayedMnemonic('N');
        jLabel4.setDisplayedMnemonicIndex(14);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBCNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Output type:");
        jLabel5.setDisplayedMnemonic('O');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputTypeCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("Application (*.swf)");
        jComboBox.setModel(defaultComboBoxModel2);
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myUpDownHint = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetDevicesLabel = jLabel = new JLabel();
        jLabel.setText("Target devices:");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAndroidCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Android");
        jCheckBox2.setMnemonic('A');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIOSCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("iOS");
        jCheckBox.setMnemonic('I');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        jLabel3.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jTextField);
        jLabel5.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

