/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\b\u00a8\u0006\t"}, d2={"createSynthesizedFunctionWithFirstParameterAsReceiver", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "createSynthesizedInvokes", "", "functions", "isSynthesizedInvoke", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolution"})
public final class SynthesizedInvokesKt {
    @NotNull
    public static final Collection<FunctionDescriptor> createSynthesizedInvokes(@NotNull Collection<? extends FunctionDescriptor> functions2) {
        Intrinsics.checkParameterIsNotNull(functions2, (String)"functions");
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>(1);
        for (FunctionDescriptor functionDescriptor : functions2) {
            FunctionDescriptor functionDescriptor2;
            if (!(functionDescriptor instanceof FunctionInvokeDescriptor) || functionDescriptor.getValueParameters().isEmpty()) continue;
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof FunctionClassDescriptor)) {
                declarationDescriptor = null;
            }
            FunctionClassDescriptor functionClassDescriptor = (FunctionClassDescriptor)declarationDescriptor;
            if (Intrinsics.areEqual((Object)((Object)(functionClassDescriptor != null ? functionClassDescriptor.getFunctionKind() : null)), (Object)((Object)FunctionClassDescriptor.Kind.Function))) {
                functionDescriptor2 = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor);
            } else {
                FunctionDescriptor invokeDeclaration;
                FunctionDescriptor functionDescriptor3 = invokeDeclaration = (FunctionDescriptor)CollectionsKt.single((Iterable)functionDescriptor.getOverriddenDescriptors());
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"invokeDeclaration");
                FunctionDescriptor synthesizedSuperFun = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor3);
                FunctionDescriptor fakeOverride = synthesizedSuperFun.copy(functionDescriptor.getContainingDeclaration(), synthesizedSuperFun.getModality(), synthesizedSuperFun.getVisibility(), CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
                DescriptorUtilsKt.setSingleOverridden(fakeOverride, synthesizedSuperFun);
                FunctionDescriptor functionDescriptor4 = fakeOverride;
                functionDescriptor2 = functionDescriptor4;
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor4, (String)"fakeOverride");
            }
            FunctionDescriptor synthesized = functionDescriptor2;
            ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getDispatchReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            FunctionDescriptor functionDescriptor5 = synthesized.substitute(TypeSubstitutor.create(receiverParameterDescriptor.getType()));
            if (functionDescriptor5 == null) {
                continue;
            }
            result2.add(functionDescriptor5);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FunctionDescriptor createSynthesizedFunctionWithFirstParameterAsReceiver(FunctionDescriptor descriptor2) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        SimpleFunctionDescriptorImpl result2 = SimpleFunctionDescriptorImpl.create(descriptor2.getContainingDeclaration(), descriptor2.getAnnotations(), descriptor2.getName(), CallableMemberDescriptor.Kind.SYNTHESIZED, descriptor2.getSource());
        FunctionDescriptor original = descriptor2.getOriginal();
        Iterable iterable = CollectionsKt.drop((Iterable)original.getValueParameters(), (int)1);
        List<TypeParameterDescriptor> list3 = original.getTypeParameters();
        ReceiverParameterDescriptor receiverParameterDescriptor = original.getDispatchReceiverParameter();
        KotlinType kotlinType = ((ValueParameterDescriptor)CollectionsKt.first(original.getValueParameters())).getType();
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = result2;
        void var4_8 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            list2 = destination$iv$iv;
            CallableDescriptor callableDescriptor = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"result");
            ValueParameterDescriptor valueParameterDescriptor2 = null;
            int n = p.getIndex() - 1;
            Annotations annotations2 = p.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotations2, (String)"p.annotations");
            Name name2 = Name.identifier("p" + (p.getIndex() + 1));
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"p${p.index + 1}\")");
            KotlinType kotlinType2 = p.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"p.type");
            boolean bl = p.declaresDefaultValue();
            boolean bl2 = p.isCrossinline();
            boolean bl3 = p.isNoinline();
            KotlinType kotlinType3 = p.getVarargElementType();
            SourceElement sourceElement = p.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"p.source");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, valueParameterDescriptor2, n, annotations2, name2, kotlinType2, bl, bl2, bl3, kotlinType3, sourceElement);
            list2.add(valueParameterDescriptorImpl);
        }
        list2 = (List)destination$iv$iv;
        simpleFunctionDescriptorImpl.initialize(kotlinType, receiverParameterDescriptor, list3, list2, original.getReturnType(), original.getModality(), original.getVisibility());
        result2.setOperator(original.isOperator());
        result2.setInfix(original.isInfix());
        result2.setExternal(original.isExternal());
        result2.setInline(original.isInline());
        result2.setTailrec(original.isTailrec());
        result2.setHasStableParameterNames(false);
        result2.setHasSynthesizedParameterNames(true);
        FunctionDescriptor functionDescriptor = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"result");
        return functionDescriptor;
    }

    public static final boolean isSynthesizedInvoke(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE) ^ true || !(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor real = (FunctionDescriptor)descriptor2;
        while (!real.getKind().isReal()) {
            if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)real.getOverriddenDescriptors()) != null) continue;
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)real.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) && real.getContainingDeclaration() instanceof FunctionClassDescriptor;
    }
}

