package com.intellij.psi.css.resolve;

import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import org.jetbrains.annotations.NotNull;

public abstract class CssElementProcessor {
  public boolean process(@NotNull PsiFile file) {
    return true;
  }
  
  public boolean process(@NotNull CssRuleset ruleset) {
    return true;
  }

  public boolean process(@NotNull CssDeclaration declaration) {
    return true;
  }

  public boolean process(@NotNull CssStylesheet stylesheet) {
    return true;
  }
}
