/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.factories;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public abstract class SpringFactoryBeansManager {

  public static final String FACTORY_BEAN_SUFFIX = "FactoryBean";

  public static SpringFactoryBeansManager getInstance() {
    return ServiceManager.getService(SpringFactoryBeansManager.class);
  }

  public abstract Set<PsiClass> getKnownBeanFactories(@NotNull final Project project);

  public abstract boolean isKnownBeanFactory(@Nullable final String factoryClass);

  public abstract boolean isFactoryBeanClass(@NotNull final PsiClass psiClass);

  public abstract boolean isValidFactoryMethod(@NotNull final PsiMethod psiMethod, final boolean isBeansXmlFactoryBean);

  /**
   * FactoryBean can produce PsiArrayType, primitive types, etc.
   *
   * @since 2016.2
   */
  @NotNull
  public abstract PsiType[] getObjectTypes(@NotNull final PsiClass factoryClass, @Nullable final CommonSpringBean context);

  /**
   * @deprecated use {@link #getObjectTypes(PsiClass, CommonSpringBean)} instead. To remove in 2017.2
   */
  @NotNull
  @Deprecated
  public abstract PsiClass[] getProductTypes(@NotNull PsiClass factoryClass, @Nullable CommonSpringBean context);
}
