/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.actions.patterns.frameworks.util;

import com.intellij.openapi.components.ServiceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.net.URL;
import java.util.Set;

/**
 * @author Yann C&eacute;bron
 */
public abstract class StandardBeansDocLinksManager {

  @NotNull
  public static StandardBeansDocLinksManager getInstance() {
    return ServiceManager.getService(StandardBeansDocLinksManager.class);
  }

  protected abstract Set<URL> getDocLinkResources();

  @Nullable
  public abstract String getApiLink(String beanId);

  @Nullable
  public abstract String getReferenceLink(String beanId);
}
