import Project = ts.server.Project;
export function initCommandNames(TypeScriptCommandNames: typeof ts.server.CommandNames) {
    TypeScriptCommandNames.IDEChangeFiles = "ideChangeFiles";
    TypeScriptCommandNames.IDECompile = "ideCompile";
    TypeScriptCommandNames.IDEGetErrors = "ideGetErr";
    TypeScriptCommandNames.IDEGetAllErrors = "ideGetAllErr";
    TypeScriptCommandNames.IDECompletions = "ideCompletions";
    TypeScriptCommandNames.IDEGetMainFileErrors = "ideGetMainFileErr";
    TypeScriptCommandNames.IDEGetProjectErrors = "ideGetProjectErr";
    if (TypeScriptCommandNames.ReloadProjects == undefined) {
        (<any>TypeScriptCommandNames).ReloadProjects = "reloadProjects";
    }
}

export declare abstract class IDETypeScriptSession extends ts.server.Session {
    getChangeSeq(): number;

    updateProjectStructureEx(): void;

    abstract refreshStructureEx(): void;

    abstract closeClientFileEx(normalizedFileName: string): void;

    updateFilesEx(args: ts.server.protocol.IDEUpdateFilesContentArgs): Response;

    abstract changeFileEx(fileName: string, content: string, tsconfig?: string): void;

    getTime(): number;

    abstract getProjectForFileEx(fileName: string, projectFile?: string): ts.server.Project;

    compileFileEx(req: ts.server.protocol.IDECompileFileRequestArgs): Response;

    getCompletionEx(request: ts.server.protocol.Request): {response: any; responseRequired: boolean};

    abstract lineOffsetToPosition(project: ts.server.Project, fileName: string, line: number, offset: number): number;

    getLanguageService(project: ts.server.Project): ts.LanguageService;

    getDiagnosticsEx(fileNames: string[], commonProject?: ts.server.Project, reqOpen?: boolean): ts.server.protocol.DiagnosticEventBody[];

    abstract containsFileEx(project: ts.server.Project, file: string, reqOpen: boolean): boolean;

    abstract getProjectName(project: ts.server.Project): string | undefined | null;

    abstract getProjectConfigPathEx(project: ts.server.Project): string| null;

    abstract positionToLineOffset(project: ts.server.Project, fileName: string, position: number): ts.server.ILineInfo;

    formatDiagnostic(fileName: string, project: ts.server.Project, diagnostic: ts.Diagnostic): ts.server.protocol.Diagnostic;

    getMainFileDiagnosticsForFileEx(fileName: string): ts.server.protocol.DiagnosticEventBody[];

    getProjectDiagnosticsForFileEx(fileName: string): ts.server.protocol.DiagnosticEventBody[];

    getProjectDiagnosticsEx(project: ts.server.Project): ts.server.protocol.DiagnosticEventBody[];

    abstract afterCompileProcess(project: ts.server.Project, requestedFile: string, wasOpened: boolean): void;

    abstract needRecompile(project: ts.server.Project): boolean;

    abstract getProjectForCompileRequest(req: ts.server.protocol.IDECompileFileRequestArgs, normalizedRequestedFile: string): {project: ts.server.Project; wasOpened: boolean};

    abstract setNewLine(project: ts.server.Project, options: ts.CompilerOptions): void;

    abstract getCompileOptionsEx(project: ts.server.Project): ts.CompilerOptions;

    abstract beforeFirstMessage(): void;

    abstract appendProjectErrors(result: ts.server.protocol.DiagnosticEventBody[],
                                 processedProjects: {[p: string]: ts.server.Project },
                                 empty: boolean): ts.server.protocol.DiagnosticEventBody[];
}

export const DETAILED_COMPLETION_COUNT: number = 30;

export const DETAILED_MAX_TIME: number = 150;

export function isTypeScript15(ts_impl: typeof ts): boolean {
    return checkVersion(ts_impl, "1.5");
}

export function isTypeScript16(ts_impl: typeof ts): boolean {
    return checkVersion(ts_impl, "1.6");
}

export function isTypeScript17(ts_impl: typeof ts): boolean {
    return checkVersion(ts_impl, "1.7");
}

function checkVersion(ts_impl: typeof ts, versionText: string) {
    return ts_impl.version && (ts_impl.version == versionText || ts_impl.version.indexOf(versionText) == 0)
}

/**
 * Default tsserver implementation doesn't return response in most cases ("open", "close", etc.)
 * we want to override the behaviour and send empty-response holder
 */
export const doneRequest: Response = {
    responseRequired: true,
    response: "done"
}

export type Response = {response?: any; responseRequired?: boolean};

export class DiagnosticsContainer {
    value: {[p: string]: ts.server.protocol.Diagnostic[]} = {}

    reset() {
        this.value = {};
    }
}


export function extendEx(ObjectToExtend: typeof ts.server.ProjectService, name: string, func: (oldFunction: any, args: any) => any) {
    let proto: any = ObjectToExtend.prototype;

    let oldFunction = proto[name];

    proto[name] = function (this: ts.server.ProjectService) {
        return func.apply(this, [oldFunction, arguments]);
    }
}


export function isFunctionKind(kind: string) {
    return kind == "method" ||
        kind == "local function" ||
        kind == "function" ||
        kind == "call" ||
        kind == "construct";
}