/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.coverage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSerializationUtils {
    private static final String SOURCE_FILE_PREFIX = "SF:";
    private static final String LINE_HIT_PREFIX = "DA:";
    private static final String END_OF_RECORD = "end_of_record";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LcovCoverageReport readLCOV(@Nullable File basePath, @NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/coverage/CoverageSerializationUtils", "readLCOV"));
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            String currentFileName = null;
            ArrayList lineDataList = null;
            LcovCoverageReport report = new LcovCoverageReport();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(SOURCE_FILE_PREFIX)) {
                    currentFileName = line.substring(SOURCE_FILE_PREFIX.length());
                    lineDataList = Lists.newArrayList();
                    continue;
                }
                if (line.startsWith(LINE_HIT_PREFIX)) {
                    if (lineDataList == null) {
                        throw new RuntimeException("lineDataList is null!");
                    }
                    String[] values = line.substring(LINE_HIT_PREFIX.length()).split(",");
                    Preconditions.checkState((values.length == 2 ? 1 : 0) != 0);
                    int lineNum = Integer.parseInt(values[0]);
                    int hitCount = Integer.parseInt(values[1]);
                    LcovCoverageReport.LineHits lineHits = new LcovCoverageReport.LineHits(lineNum, hitCount);
                    lineDataList.add(lineHits);
                    continue;
                }
                if (!END_OF_RECORD.equals(line)) continue;
                if (lineDataList == null) {
                    throw new RuntimeException("lineDataList is null!");
                }
                Preconditions.checkNotNull((Object)currentFileName);
                report.mergeFileReport(basePath, currentFileName, lineDataList);
                currentFileName = null;
                lineDataList = null;
            }
            Preconditions.checkState((lineDataList == null && currentFileName == null ? 1 : 0) != 0);
            LcovCoverageReport lcovCoverageReport = report;
            return lcovCoverageReport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLCOV(@NotNull LcovCoverageReport report, @NotNull File outputFile) throws IOException {
        if (report == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "com/intellij/javascript/testFramework/coverage/CoverageSerializationUtils", "writeLCOV"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/javascript/testFramework/coverage/CoverageSerializationUtils", "writeLCOV"));
        }
        try (PrintWriter out = new PrintWriter(outputFile);){
            for (Map.Entry<String, List<LcovCoverageReport.LineHits>> entry : report.getInfo().entrySet()) {
                out.print(SOURCE_FILE_PREFIX);
                out.println(entry.getKey());
                for (LcovCoverageReport.LineHits lineHits : entry.getValue()) {
                    out.print(LINE_HIT_PREFIX);
                    out.print(lineHits.getLineNumber());
                    out.print(',');
                    out.println(lineHits.getHits());
                }
                out.println(END_OF_RECORD);
            }
        }
    }
}

