/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.provider;

import aQute.bnd.http.HttpRequestException;
import aQute.bnd.service.url.TaggedData;
import aQute.lib.io.IO;
import aQute.libg.command.Command;
import aQute.maven.api.Archive;
import aQute.maven.api.Release;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenBackingRepository;
import aQute.maven.provider.MavenRepository;
import aQute.maven.provider.MetadataParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

class Releaser
implements Release {
    final List<Archive> upload = new ArrayList<Archive>();
    final MavenRepository home;
    final Revision revision;
    final MetadataParser.RevisionMetadata programMetadata = new MetadataParser.RevisionMetadata();
    boolean force;
    boolean aborted;
    private File dir;
    protected boolean localOnly;
    protected MavenBackingRepository repo;
    private Properties context;

    Releaser(MavenRepository home, Revision revision, MavenBackingRepository repo, Properties context) throws Exception {
        this.home = home;
        this.revision = revision;
        this.repo = repo;
        this.context = context;
        this.dir = home.toLocalFile(revision.path);
        IO.delete(this.dir);
        this.check();
        this.dir.mkdirs();
    }

    protected void check() {
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.aborted) {
                if (!this.localOnly) {
                    this.uploadAll(this.upload.iterator());
                    this.updateMetadata();
                }
                this.home.clear(this.revision);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void updateMetadata() throws Exception, InterruptedException {
        if (!this.isUpdateProgramMetadata()) {
            return;
        }
        int n = 0;
        while (true) {
            try {
                MetadataParser.ProgramMetadata metadata;
                File metafile = this.home.toLocalFile(this.revision.program.metadata(this.repo.id));
                TaggedData tag = this.repo.fetch(this.revision.program.metadata(), metafile);
                switch (tag.getState()) {
                    case NOT_FOUND: {
                        metadata = new MetadataParser.ProgramMetadata();
                        break;
                    }
                    case OTHER: {
                        throw new HttpRequestException((HttpURLConnection)tag.getConnection());
                    }
                    default: {
                        metadata = MetadataParser.parseProgramMetadata(metafile);
                    }
                }
                long lastModified = metafile.lastModified();
                if (metadata.versions.contains(this.revision.version)) {
                    if (this.force || this.revision.isSnapshot()) {
                        return;
                    }
                    throw new IllegalStateException("Revision already exists on remote system " + this.revision + " " + this.repo);
                }
                metadata.versions.add(this.revision.version);
                IO.store((Object)metadata.toString(), metafile);
                this.repo.store(metafile, this.revision.program.metadata());
                return;
            }
            catch (Exception e) {
                if (n++ > 3) {
                    throw e;
                }
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    protected boolean isUpdateProgramMetadata() {
        return this.repo.isFile();
    }

    void uploadAll(Iterator<Archive> iterator) throws Exception {
        if (!iterator.hasNext()) {
            return;
        }
        Archive archive = iterator.next();
        File f = this.home.toLocalFile(archive);
        try {
            this.repo.store(f, archive.remotePath);
            this.sign(archive, f);
            this.uploadAll(iterator);
        }
        catch (Exception e) {
            try {
                this.repo.delete(archive.remotePath);
            }
            catch (Exception ee) {
                throw e;
            }
        }
    }

    public void sign(Archive archive, File f) throws Exception {
    }

    @Override
    public void add(Archive archive, InputStream in) throws Exception {
        try {
            archive = this.resolve(archive);
            this.home.store(archive, in);
            this.upload.add(archive);
        }
        catch (Exception e) {
            this.aborted = true;
            throw e;
        }
    }

    protected Archive resolve(Archive archive) throws Exception {
        return archive;
    }

    @Override
    public void add(Archive archive, File in) throws Exception {
        try (FileInputStream fin = new FileInputStream(in);){
            this.add(archive, fin);
        }
        catch (Exception e) {
            this.aborted = true;
            throw e;
        }
    }

    @Override
    public void abort() {
        this.aborted = true;
    }

    public void force() {
        this.force = true;
    }

    @Override
    public void add(String extension, String classifier, InputStream in) throws Exception {
        Archive a = this.revision.archive(extension, classifier);
        this.add(a, in);
    }

    @Override
    public void setBuild(long timestamp, String build) {
        throw new IllegalArgumentException("This is not a snapshot release so you cannot set the timestamp");
    }

    @Override
    public void setBuild(String timestamp, String build) {
    }

    @Override
    public void setLocalOnly() {
        this.localOnly = true;
    }

    File sign(File file) throws Exception {
        File asc = new File(file.getParentFile(), file.getName() + ".asc");
        asc.delete();
        Command command = new Command();
        command.setTrace();
        command.add(this.context.getProperty("gpg", "gpg"));
        String passphrase = this.getPassphrase();
        if (passphrase == null) {
            throw new IOException("gpg signing %s failed because no passphrase was set (either context, System property `gpg.passphrase`, or env var GPG_PASSPHRASE");
        }
        command.add("--passphrase", passphrase);
        command.add("-ab", "--sign");
        command.add(file.getAbsolutePath());
        System.err.println(command);
        StringBuilder stdout = new StringBuilder();
        StringBuilder stderr = new StringBuilder();
        int result = command.execute(stdout, stderr);
        if (result != 0) {
            throw new IOException("gpg signing %s failed because " + file + stdout + stderr);
        }
        return asc;
    }

    private String getPassphrase() {
        return this.context.getProperty("gpg.passphrase", System.getProperties().getProperty("gpg.passphrase", System.getenv("GPG_PASSPHRASE")));
    }
}

