/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreAwareProjectManagerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutBuilderImpl;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.ui.ComboBoxModelEditor;
import com.intellij.util.ui.ListItemEditor;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.RepositoryItem;
import org.jetbrains.settingsRepository.RepositoryListEditorKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"createRepositoryListEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "deleteRepository", "", "settings-repository"})
public final class RepositoryListEditorKt {
    @NotNull
    public static final ConfigurableUi<IcsSettings> createRepositoryListEditor(@NotNull IcsManager icsManager2) {
        Intrinsics.checkParameterIsNotNull((Object)icsManager2, (String)"icsManager");
        ComboBoxModelEditor editor2 = new ComboBoxModelEditor((ListItemEditor)new ListItemEditor<RepositoryItem>(){

            @NotNull
            public Class<RepositoryItem> getItemClass() {
                return RepositoryItem.class;
            }

            @NotNull
            public RepositoryItem clone(@NotNull RepositoryItem item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new RepositoryItem(item.getUrl());
            }
        });
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(editor2, deleteButton){
            final /* synthetic */ ComboBoxModelEditor $editor;
            final /* synthetic */ JButton $deleteButton;

            public final void actionPerformed(ActionEvent it) {
                block0: {
                    RepositoryItem repositoryItem;
                    RepositoryItem repositoryItem2 = (RepositoryItem)this.$editor.getModel().getSelected();
                    if (repositoryItem2 == null) break block0;
                    RepositoryItem it2 = repositoryItem = repositoryItem2;
                    this.$editor.getModel().remove((Object)it2);
                    this.$deleteButton.setEnabled(this.$editor.getModel().getSelected() != null);
                }
            }
            {
                this.$editor = comboBoxModelEditor;
                this.$deleteButton = jButton;
            }
        });
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor2, deleteButton, icsManager2){
            private Row noRepositoryRow;
            private Row repositoryRow;
            final /* synthetic */ ComboBoxModelEditor $editor;
            final /* synthetic */ JButton $deleteButton;
            final /* synthetic */ IcsManager $icsManager;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            @NotNull
            public JPanel getComponent() {
                Row row;
                LayoutBuilder this_$iv$iv;
                Row row$iv$iv;
                String label$iv;
                LayoutBuilder this_$iv;
                LayoutBuilder builder$iv;
                LayoutBuilder $receiver;
                LCFlags[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                LayoutBuilder layoutBuilder = $receiver = (builder$iv = LayoutImplKt.createLayoutBuilder());
                String string = "Repository:";
                createRepositoryListEditor.2 var8_7 = this;
                void var9_8 = this_$iv;
                JLabel label$iv$iv = ComponentsKt.Label$default((String)label$iv, null, null, (boolean)false, (int)14, null);
                boolean separated$iv$iv = false;
                Row $receiver2 = row$iv$iv = LayoutBuilderImpl.DefaultImpls.newRow$default((LayoutBuilderImpl)this_$iv$iv.get$(), (JLabel)label$iv$iv, (ButtonGroup)this_$iv$iv.getButtonGroup(), (boolean)separated$iv$iv, (boolean)false, (int)8, null);
                $receiver2.hint("Use File -> Settings Repository... to configure");
                var8_7.noRepositoryRow = row = row$iv$iv;
                this_$iv = $receiver;
                label$iv = "Repository:";
                var8_7 = this;
                this_$iv$iv = this_$iv;
                label$iv$iv = ComponentsKt.Label$default((String)label$iv, null, null, (boolean)false, (int)14, null);
                separated$iv$iv = false;
                $receiver2 = row$iv$iv = LayoutBuilderImpl.DefaultImpls.newRow$default((LayoutBuilderImpl)this_$iv$iv.get$(), (JLabel)label$iv$iv, (ButtonGroup)this_$iv$iv.getButtonGroup(), (boolean)separated$iv$iv, (boolean)false, (int)8, null);
                Row.invoke$default((Row)$receiver2, (JComponent)((JComponent)this.$editor.getComboBox()), (CCFlags[])new CCFlags[0], (int)0, null, (int)6, null);
                Row.invoke$default((Row)$receiver2, (JComponent)this.$deleteButton, (CCFlags[])new CCFlags[0], (int)0, null, (int)6, null);
                var8_7.repositoryRow = row = row$iv$iv;
                JPanel panel$iv = ComponentsKt.Panel((String)title$iv, null);
                builder$iv.get$().build((Container)panel$iv, constraints$iv);
                return panel$iv;
            }

            public void apply(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List newList = this.$editor.apply();
                if (newList.isEmpty()) {
                    RepositoryListEditorKt.access$deleteRepository(this.$icsManager);
                }
            }

            public void reset(@NotNull IcsSettings settings) {
                RepositoryItem upstream;
                RepositoryItem repositoryItem;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                ArrayList<Object> list = new ArrayList<Object>();
                String string = this.$icsManager.getRepositoryManager().getUpstream();
                if (string != null) {
                    object = string;
                    String p1 = object;
                    repositoryItem = new RepositoryItem(p1);
                } else {
                    repositoryItem = null;
                }
                RepositoryItem repositoryItem2 = upstream = repositoryItem;
                if (repositoryItem2 != null) {
                    Object it = object = repositoryItem2;
                    list.add(it);
                }
                this.$editor.reset((List)list);
                this.$editor.getModel().setSelectedItem((Object)upstream);
                Row row = this.noRepositoryRow;
                if (row == null) {
                    Intrinsics.throwNpe();
                }
                row.setVisible(list.isEmpty());
                Row row2 = this.repositoryRow;
                if (row2 == null) {
                    Intrinsics.throwNpe();
                }
                object = list;
                Row row3 = row2;
                boolean bl = !object.isEmpty();
                row3.setVisible(bl);
                this.$deleteButton.setEnabled(this.$editor.getModel().getSelectedItem() != null);
            }
            {
                this.$editor = $captured_local_variable$0;
                this.$deleteButton = $captured_local_variable$1;
                this.$icsManager = $captured_local_variable$2;
            }
        };
    }

    private static final void deleteRepository(IcsManager icsManager2) {
        String title$iv;
        String string = "Syncing before delete Repository";
        boolean cancellable$iv = true;
        Project project$iv = null;
        ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv, project$iv, title$iv, cancellable$iv, icsManager2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ IcsManager $icsManager$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$icsManager$inlined = icsManager2;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(ProgressIndicator indicator) {
                ProgressIndicator indicator2 = indicator;
                indicator2.setIndeterminate(true);
                RepositoryManager repositoryManager = this.$icsManager$inlined.getRepositoryManager();
                if (!repositoryManager.canCommit()) {
                    IcsManagerKt.getLOG().info("Commit on repository delete skipped: repository is not committable");
                } else {
                    boolean asWarning$iv = true;
                    try {
                        RepositoryManager.Updater updater = repositoryManager.fetch(indicator2);
                        indicator2.checkCanceled();
                        updater.merge();
                        indicator2.checkCanceled();
                        if (!updater.getDefinitelySkipPush()) {
                            repositoryManager.push(indicator2);
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable e$iv) {
                        IcsManagerKt.getLOG().warn(e$iv);
                    }
                }
            }
        });
        title$iv = "Deleting Repository";
        cancellable$iv = false;
        project$iv = null;
        ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv, project$iv, title$iv, cancellable$iv, icsManager2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ IcsManager $icsManager$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$icsManager$inlined = icsManager2;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(ProgressIndicator indicator) {
                ProgressIndicator indicator2 = indicator;
                RepositoryManager repositoryManager = this.$icsManager$inlined.getRepositoryManager();
                indicator2.setIndeterminate(true);
                repositoryManager.deleteRepository();
                this.$icsManager$inlined.setRepositoryActive(false);
            }
        });
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)ApplicationManager.getApplication()));
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ComponentStoreImpl store = (ComponentStoreImpl)iComponentStore;
        StateStorageManager stateStorageManager = store.getStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        if (!StoreAwareProjectManagerKt.reloadAppStore((Set)((StateStorageManagerImpl)stateStorageManager).getCachedFileStorages())) {
            return;
        }
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1)deleteRepository.3.INSTANCE);
    }

    public static final /* synthetic */ void access$deleteRepository(@NotNull IcsManager icsManager2) {
        RepositoryListEditorKt.deleteRepository(icsManager2);
    }
}

