/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CreateCssClassLocalQuickFix
extends BaseGwtLocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.CreateCssClassLocalQuickFix");
    private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.css.class", new Object[0]);
    private final SmartPsiElementPointer<PsiElement> myPsiElementPointer;
    private final String myClassName;

    public CreateCssClassLocalQuickFix(@NotNull StylesheetFile stylesheetFile, String className) {
        if (stylesheetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheetFile", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "<init>"));
        }
        this((PsiElement)stylesheetFile, className);
    }

    public CreateCssClassLocalQuickFix(@NotNull XmlTag xmlTag, String className) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "<init>"));
        }
        this((PsiElement)xmlTag, className);
    }

    private CreateCssClassLocalQuickFix(@NotNull PsiElement psiElement, String className) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "<init>"));
        }
        super(GwtBundle.message("quickfix.name.create.css.class.0", className));
        this.myPsiElementPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement);
        this.myClassName = className;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "applyFix"));
        }
        PsiElement psiElement = this.myPsiElementPointer.getElement();
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)psiElement;
            List<StylesheetFile> stylesheetFiles = new UiStyleElement(xmlTag).getStylesheetFiles();
            if (stylesheetFiles.isEmpty()) {
                return;
            }
            if (stylesheetFiles.size() == 1) {
                this.applyFix(stylesheetFiles.get(0), project);
            } else {
                Editor editor = PsiUtilBase.findEditor((PsiElement)xmlTag);
                if (editor != null) {
                    StylesheetFile[] cssFilesArray = stylesheetFiles.toArray(StylesheetFile.EMPTY_ARRAY);
                    NavigationUtil.getPsiElementPopup((PsiElement[])cssFilesArray, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)"Choose CSS file", element -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "lambda$applyFix$1"));
                        }
                        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "lambda$null$0"));
                            }
                            this.applyFix((StylesheetFile)element, project);
                        });
                        return true;
                    }).showInBestPositionFor(editor);
                }
            }
        } else if (psiElement instanceof StylesheetFile) {
            this.applyFix((StylesheetFile)psiElement, project);
        } else {
            LOG.error("StylesheetFile or XmlTag expected. Found: " + psiElement);
        }
    }

    private void applyFix(@NotNull StylesheetFile cssFile, @NotNull Project project) {
        if (cssFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssFile", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "applyFix"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "applyFix"));
        }
        VirtualFile virtualFile = cssFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles()) {
            return;
        }
        try {
            CssStylesheet stylesheet = cssFile.getStylesheet();
            CssRuleset cssRuleset = CssElementFactory.getInstance((Project)project).createRuleset("." + this.myClassName + "{\n\n}\n", cssFile.getLanguage());
            stylesheet.addRuleset(cssRuleset);
            CssRuleset[] rulesets = stylesheet.getRulesets();
            CssRuleset added = rulesets[rulesets.length - 1];
            OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile, added.getBlock().getTextOffset());
            FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

