/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodCallPattern;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtCreateMethodCallInspection
extends BaseGwtInspection {
    private static final Key<PsiExpression> GWT_CREATE_ARGUMENT_KEY = Key.create((String)"GWT_CREATE_ARGUMENT");
    private static final PsiMethodCallPattern INCORRECT_CREATE_METHOD_CALL_PATTERN;

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtCreateMethodCallInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtCreateMethodCallInspection", "checkFile"));
        }
        if (!GwtCreateMethodCallInspection.shouldCheck((PsiElement)file)) {
            return null;
        }
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(file.getProject());
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List<GwtModule> gwtModules = gwtModulesManager.findGwtModulesByClientSourceFile(virtualFile);
        if (gwtModules.isEmpty()) {
            return null;
        }
        SmartList problemDescriptors = new SmartList();
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)problemDescriptors, manager, isOnTheFly){
            final /* synthetic */ List val$problemDescriptors;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$problemDescriptors = list;
                this.val$manager = inspectionManager;
                this.val$isOnTheFly = bl;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                ProcessingContext context = new ProcessingContext();
                if (INCORRECT_CREATE_METHOD_CALL_PATTERN.accepts((Object)expression, context)) {
                    PsiExpression argument = (PsiExpression)context.get(GWT_CREATE_ARGUMENT_KEY);
                    String message = GwtBundle.message("problem.description.only.class.literals.may.be.used.as.arguments.to.gwt.create", new Object[0]);
                    this.val$problemDescriptors.add(this.val$manager.createProblemDescriptor((PsiElement)argument, message, this.val$isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        });
        return !problemDescriptors.isEmpty() ? problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]) : null;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.incorrect.argument.of.gwt.create.method", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtCreateMethodCallInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtIncorrectArgumentOfGwtCreateMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtCreateMethodCallInspection", "getShortName"));
        }
        return "GwtIncorrectArgumentOfGwtCreateMethod";
    }

    static {
        PsiMethodPattern createMethodPattern = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("create")).definedInClass("com.google.gwt.core.client.GWT");
        INCORRECT_CREATE_METHOD_CALL_PATTERN = PsiJavaPatterns.psiExpression().methodCall((ElementPattern)createMethodPattern).withArguments(new ElementPattern[]{((PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiClassObjectAccessExpression.class))).save(GWT_CREATE_ARGUMENT_KEY)});
    }
}

