/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.gwt.maven.GwtDependenciesCache;
import com.intellij.gwt.maven.GwtMavenSdk;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.gwt.run.GwtClasspathUtil;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.run.HostedModeWarDirectoryGenerator;
import com.intellij.gwt.run.JavaCommandLineStateEx;
import com.intellij.gwt.run.remoteUi.GwtErrorFilter;
import com.intellij.gwt.run.remoteUi.RemoteUiConnection;
import com.intellij.gwt.run.remoteUi.RemoteUiView;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.build.common.DelegatingOutputLineReader;
import org.jetbrains.jps.gwt.build.common.OutputLineReader;
import org.jetbrains.jps.gwt.model.impl.sdk.JpsGwtDependenciesCache;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class GwtCommandLineState
extends JavaCommandLineStateEx {
    public static final Key<HostedModeWarDirectoryGenerator> GWT_GENERATOR_KEY = Key.create((String)"GWT_GENERATOR");
    public static final Key<GwtCommandLineState> GWT_CONFIGURATION_STATE_KEY = Key.create((String)"GWT_CONFIGURATION_STATE");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.run.GwtCommandLineState");
    @NonNls
    private static final String WEB_XML_PATH = "com/google/gwt/dev/etc/tomcat/webapps/ROOT/WEB-INF/web.xml";
    @NonNls
    private static final String APP_ENGINE_GENERATED_DIR = "WEB-INF/appengine-generated";
    @NonNls
    private static final String MODULE_DIR_MACRO = "$MODULE_DIR$";
    public static final FilenameFilter GWT_TEMP_FILES_FILTER = (dir, name) -> name.startsWith("gwt") && name.endsWith("byte-cache");
    private static final boolean SHOW_SHELL_WINDOW_FOR_DEV_MODE = SystemProperties.getBooleanProperty((String)"idea.gwt.show.shell.window.for.dev.mode", (boolean)false);
    private final GwtFacet myFacet;
    private final Module myModule;
    private final List<String> myGwtModules;
    private final Executor myExecutor;
    private final GwtDevModeServer myServer;
    private final String myRunConfigurationName;
    private final GwtRunConfiguration myRunConfiguration;
    @Nullable
    private RemoteUiConnection myUiConnection;
    private int myRemoteUiPort;
    private FrameStateListener myFrameListener;
    private final GwtRunConfiguration.GwtRunConfigurationState myRunConfigurationState;
    private String myOutputDirPath;
    private String myPatchedShellParameters;
    private ParametersList myPatchedShellParametersList;
    private final String myModuleDir;
    private File myAppEngineGeneratedDir;
    private Set<String> myOldGwtTempFiles;

    public GwtCommandLineState(@NotNull GwtFacet facet, @NotNull ExecutionEnvironment environment, @NotNull GwtRunConfiguration configuration, @NotNull GwtDevModeServer server, @NotNull Executor executor) throws ExecutionException {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/run/GwtCommandLineState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/gwt/run/GwtCommandLineState", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/gwt/run/GwtCommandLineState", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/gwt/run/GwtCommandLineState", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/gwt/run/GwtCommandLineState", "<init>"));
        }
        super(environment);
        this.myFacet = facet;
        this.myModule = this.myFacet.getModule();
        this.myRunConfiguration = configuration;
        this.myGwtModules = configuration.getState().getGwtModules();
        this.myExecutor = executor;
        this.myRunConfigurationState = configuration.getState();
        this.myRunConfigurationName = environment.getRunProfile().getName();
        this.myServer = server;
        this.myModuleDir = PathMacroUtil.getModuleDir((String)this.myModule.getModuleFilePath());
        if (this.isUseRemoteUi()) {
            this.myUiConnection = new RemoteUiConnection(configuration, facet.getSdkVersion(), this.myRunConfigurationState.OPEN_IN_BROWSER, this.myRunConfigurationState.START_JAVASCRIPT_DEBUGGER, WebBrowserManager.getInstance().findBrowserById(this.myRunConfigurationState.BROWSER));
            try {
                this.myRemoteUiPort = this.myUiConnection.open();
            }
            catch (IOException e) {
                throw new ExecutionException("Cannot create socket: " + e.getMessage(), (Throwable)e);
            }
        }
        this.initOutputDir();
    }

    public Module getModule() {
        return this.myModule;
    }

    private boolean isUseRemoteUi() {
        return this.myFacet.getSdkVersion().isOutOfProcessHostedModeSupported() && !SHOW_SHELL_WINDOW_FOR_DEV_MODE;
    }

    @Override
    protected void onException() {
        File[] tempFiles;
        File appEngineDir;
        if (this.myUiConnection != null) {
            this.myUiConnection.close();
        }
        if (this.myFrameListener != null) {
            FrameStateManager.getInstance().removeListener(this.myFrameListener);
        }
        if (this.myAppEngineGeneratedDir != null && !this.myModule.isDisposed() && (appEngineDir = new File(this.getOutputDir() + FileUtil.toSystemDependentName((String)"/WEB-INF/appengine-generated"))).isDirectory()) {
            try {
                FileUtil.copyDir((File)appEngineDir, (File)this.myAppEngineGeneratedDir);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        if ((tempFiles = new File(FileUtil.getTempDirectory()).listFiles(GWT_TEMP_FILES_FILTER)) != null) {
            for (File file : tempFiles) {
                if (this.myOldGwtTempFiles.contains(file.getName())) continue;
                FileUtil.delete((File)file);
            }
        }
    }

    @Override
    protected JavaParameters createJavaParametersImpl() throws ExecutionException {
        JavaParameters params = new JavaParameters();
        if (this.getWorkingDirectoryPath() != null) {
            params.setWorkingDirectory(this.getWorkingDirectoryPath());
        } else {
            params.setWorkingDirectory(this.getOutputDir());
        }
        PathsList sources = GwtClasspathUtil.getSourceRootsOfGwtModules(this.myModule, true);
        PathsList classPath = params.getClassPath();
        for (String path : sources.getPathList()) {
            classPath.add(path);
        }
        GwtVersion sdkVersion = this.myFacet.getSdkVersion();
        JavaParametersUtil.configureModule((Module)this.myModule, (JavaParameters)params, (int)7, (String)this.myRunConfigurationState.ALTERNATIVE_JRE_PATH);
        if (SystemInfo.isMac) {
            if (!sdkVersion.isOutOfProcessHostedModeSupported()) {
                params.getVMParametersList().add("-XstartOnFirstThread");
            }
            params.getVMParametersList().add("-Dapple.awt.UIElement=true");
        }
        this.addParametersString(params.getVMParametersList(), this.myRunConfigurationState.VM_PARAMETERS);
        ParametersList programParameters = params.getProgramParametersList();
        if (sdkVersion.isDevModeSupportsOutputStyleOption()) {
            programParameters.add("-style");
            programParameters.add(((GwtFacetConfiguration)this.myFacet.getConfiguration()).getOutputStyle().getId());
        }
        this.addParametersString(programParameters, this.myPatchedShellParameters);
        if (this.myUiConnection != null) {
            programParameters.add("-remoteUI");
            programParameters.add(this.myRemoteUiPort + ":IntelliJIdea");
        }
        String runPage = this.myRunConfigurationState.RUN_PAGE;
        if (sdkVersion.isModulesToLoadSpecifiedInDevMode()) {
            if (!StringUtil.isEmptyOrSpaces((String)runPage)) {
                programParameters.add("-startupUrl");
                programParameters.add(runPage);
            }
            this.addGwtModules(programParameters);
        } else {
            programParameters.add(runPage);
        }
        params.setupEnvs(this.myRunConfigurationState.ENVIRONMENT_VARIABLES, this.myRunConfigurationState.PASS_PARENT_ENVS);
        GwtSdk sdk = ((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk();
        classPath.addFirst(sdk.getDevJarPath());
        if (!GwtCommandLineState.containsUserJar(classPath)) {
            classPath.add(sdk.getUserJarPath());
        }
        boolean addDefaultAdditionalCompilerJars = true;
        if ("maven".equals(((GwtFacetConfiguration)this.myFacet.getConfiguration()).getGwtSdkType())) {
            GwtDependenciesCache gwtDependenciesCache = GwtDependenciesCache.getInstance(this.myModule.getProject());
            try {
                List jars = gwtDependenciesCache.getAdditionalCompilerJars(((GwtMavenSdk)sdk).getGwtSdkPaths());
                if (jars != null) {
                    addDefaultAdditionalCompilerJars = false;
                    classPath.addAll(jars);
                }
            }
            catch (JpsGwtDependenciesCache.GwtDependenciesFileNotFoundException e) {
                Notification notification = new Notification(GwtBundle.message("gwt.notification.display.id", new Object[0]), "", e.getMessage(), MessageType.WARNING.toNotificationType(), null).setImportant(false);
                notification.notify(this.myModule.getProject());
            }
        }
        if (addDefaultAdditionalCompilerJars) {
            classPath.addAll(sdk.getAdditionalCompilerJars());
        }
        if (this.myRunConfigurationState.USE_SUPER_DEV_MODE) {
            File sdmLauncher = GwtCommandLineState.getSuperDevModeLauncherLegacyJar();
            if (sdkVersion.isLegacyJarForNewSuperDevModeRequired() && !sdmLauncher.exists()) {
                LOG.error("Cannot start SuperDevMode: " + sdmLauncher.getAbsolutePath() + " doesn't exist");
            } else {
                classPath.addFirst(sdk.getCodeServerJarPath());
                if (sdkVersion.isLegacyJarForNewSuperDevModeRequired()) {
                    classPath.addFirst(sdmLauncher.getAbsolutePath());
                }
                programParameters.addAt(0, "-superDevMode");
            }
        } else if (sdkVersion.isSuperDevModeUsedByDefault()) {
            programParameters.addAt(0, "-nosuperDevMode");
        }
        params.setMainClass(sdkVersion.getDevModeClass());
        this.myServer.patchParameters(params, this.getOutputDir().getAbsolutePath(), this.myFacet);
        return params;
    }

    private void addGwtModules(ParametersList programParameters) {
        if (this.myGwtModules != null) {
            programParameters.addAll(this.myGwtModules);
        } else {
            for (GwtModule module : GwtModulesManager.getInstance(this.myModule.getProject()).getCompilableGwtModules(this.myModule, false)) {
                programParameters.add(module.getQualifiedName());
            }
        }
    }

    private Collection<GwtModule> getGwtModules() {
        GwtModulesManager modulesManager = GwtModulesManager.getInstance(this.myModule.getProject());
        if (this.myGwtModules != null) {
            ArrayList<GwtModule> modules = new ArrayList<GwtModule>();
            for (String module : this.myGwtModules) {
                ContainerUtil.addIfNotNull(modules, (Object)modulesManager.findGwtModuleByQualifiedName(module, this.myModule.getModuleScope(false)));
            }
            return modules;
        }
        return modulesManager.getCompilableGwtModules(this.myModule, false);
    }

    private static boolean containsUserJar(PathsList classPath) {
        for (String path : classPath.getPathList()) {
            String name = PathUtil.getFileName((String)path);
            if (!name.startsWith("gwt-user") || !name.endsWith(".jar")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static File getSuperDevModeLauncherLegacyJar() {
        File pluginClassesRoot = new File(PathUtil.getJarPathForClass(GwtCommandLineState.class));
        if (pluginClassesRoot.isFile()) {
            File file = new File(pluginClassesRoot.getParentFile(), "sdm-launcher/superdevmode-launcher-legacy.jar");
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtCommandLineState", "getSuperDevModeLauncherLegacyJar"));
            }
            return file;
        }
        File pluginHome = PluginPathManager.getPluginHome((String)"GwtStudio");
        File file = new File(pluginHome, "lib/superdevmode-launcher-legacy.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtCommandLineState", "getSuperDevModeLauncherLegacyJar"));
        }
        return file;
    }

    private File getOutputDir() {
        return new File(this.myOutputDirPath);
    }

    private File getTempOutputDir() {
        return new File(GwtCompilerPaths.getOutputRoot(this.myModule), "run");
    }

    private void initOutputDir() {
        String sourceLevel;
        ParametersList programParameters = new ParametersList();
        programParameters.addParametersString(this.myRunConfigurationState.SHELL_PARAMETERS);
        String outputDirParameterName = this.myFacet.getSdkVersion().getCompilerOutputDirParameterName();
        String outputDirPath = null;
        boolean hasOutputDirParameter = programParameters.hasParameter(outputDirParameterName);
        if (hasOutputDirParameter) {
            List parametersList = programParameters.getList();
            int index = parametersList.indexOf(outputDirParameterName);
            String string = outputDirPath = index + 1 == parametersList.size() ? null : (String)parametersList.get(index + 1);
            if (outputDirPath == null || outputDirPath.startsWith("-")) {
                outputDirPath = null;
                hasOutputDirParameter = false;
            }
        }
        if (!hasOutputDirParameter) {
            programParameters.add(outputDirParameterName);
            outputDirPath = new File(this.getTempOutputDir(), "www").getAbsolutePath();
            String patchedOutputDir = this.myServer.patchWarDirectoryPath(outputDirPath);
            FileUtil.createDirectory((File)new File(patchedOutputDir));
            programParameters.add(patchedOutputDir);
        }
        if ((sourceLevel = ((GwtFacetConfiguration)this.myFacet.getConfiguration()).getClientLanguageLevelString()) != null) {
            programParameters.add("-sourceLevel", sourceLevel);
        }
        this.myPatchedShellParametersList = programParameters;
        this.myPatchedShellParameters = ParametersList.join((List)programParameters.getParameters());
        this.myOutputDirPath = outputDirPath;
    }

    private String getWorkingDirectoryPath() {
        return StringUtil.nullize((String)this.myRunConfigurationState.WORKING_DIRECTORY);
    }

    @Override
    @NotNull
    public ExecutionResult executeImpl(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/gwt/run/GwtCommandLineState", "executeImpl"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/gwt/run/GwtCommandLineState", "executeImpl"));
        }
        this.getOutputDir().mkdirs();
        if (this.getWorkingDirectoryPath() != null) {
            new File(this.getWorkingDirectoryPath()).mkdirs();
        }
        if (this.myRunConfigurationState.CUSTOM_WEB_XML != null) {
            File targetWebXml = new File(this.getOutputDir().getAbsolutePath() + "/tomcat/webapps/ROOT/WEB-INF/web.xml".replace('/', File.separatorChar));
            try {
                FileUtilRt.createParentDirs((File)targetWebXml);
                FileUtil.copy((File)new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)this.myRunConfigurationState.CUSTOM_WEB_XML))), (File)targetWebXml);
                this.patchWebXml(targetWebXml);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            catch (JDOMException e) {
                LOG.info((Throwable)e);
            }
        }
        HostedModeWarDirectoryGenerator generator = null;
        WebFacet webFacet = this.myFacet.getWebFacet();
        if (this.myFacet.getSdkVersion().isHostedModeRequiresWebXml() && !this.hasNoServerParameter()) {
            String explodedPath;
            Collection artifacts;
            Artifact artifact;
            generator = this.createDevModeWarDirectoryGenerator(this.getOutputDir(), new File(this.getTempOutputDir(), "files.dat"));
            if (this.myRunConfigurationState.USE_SUPER_DEV_MODE) {
                Collection<GwtModule> modules = this.getGwtModules();
                GlobalSearchScope scope = this.myModule.getModuleWithDependenciesScope().intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)this.myModule.getProject()));
                Collection<GwtModule> inheritedModules = GwtModulesManager.getInstance(this.myModule.getProject()).findAllInheritedModules(modules, scope);
                HashSet<GwtModule> allModules = new HashSet<GwtModule>(modules.size() + inheritedModules.size());
                allModules.addAll(modules);
                allModules.addAll(inheritedModules);
                for (GwtModule module : allModules) {
                    for (VirtualFile file : module.getPublicRoots(false)) {
                        generator.addFile(file, module.getOutputName());
                    }
                }
            }
            if (webFacet != null && (artifact = (Artifact)ContainerUtil.getFirstItem((Collection)(artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, WebArtifactUtil.getInstance().getExplodedWarArtifactType())), null)) != null && (explodedPath = artifact.getOutputPath()) != null && explodedPath.length() > 0) {
                this.myAppEngineGeneratedDir = new File(FileUtil.toSystemDependentName((String)(explodedPath + "/" + APP_ENGINE_GENERATED_DIR)));
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myAppEngineGeneratedDir);
                if (file != null) {
                    WriteAction.run(() -> file.refresh(false, true));
                    generator.addFile(file, APP_ENGINE_GENERATED_DIR);
                }
            }
            generator.generate(this.myModule.getProject());
        }
        if (generator != null) {
            this.myFrameListener = new MyFrameStateListener(generator);
            FrameStateManager.getInstance().addListener(this.myFrameListener);
        }
        ConsoleView mainConsole = this.getConsoleBuilder().filters(new Filter[]{new GwtErrorFilter(this.myModule)}).getConsole();
        Object view = this.myUiConnection != null ? new RemoteUiView(this.myModule.getProject(), mainConsole, this.myUiConnection, this.myExecutor.getId().equals(DefaultDebugExecutor.EXECUTOR_ID)) : mainConsole;
        this.myOldGwtTempFiles = ContainerUtil.set((Object[])((Object[])ObjectUtils.notNull((Object)new File(FileUtil.getTempDirectory()).list(GWT_TEMP_FILES_FILTER), (Object)ArrayUtil.EMPTY_STRING_ARRAY)));
        if (Boolean.parseBoolean(System.getProperty("idea.gwt.clear.unit.cache.before.run", "true"))) {
            File unitCacheDir = new File(this.getTempOutputDir(), "gwt-unitCache");
            LOG.debug("Clearing " + unitCacheDir.getAbsolutePath());
            FileUtil.delete((File)unitCacheDir);
        }
        OSProcessHandler processHandler = this.startProcess();
        mainConsole.attachToProcess((ProcessHandler)processHandler);
        processHandler.putUserData(GWT_GENERATOR_KEY, (Object)generator);
        processHandler.putUserData(GWT_CONFIGURATION_STATE_KEY, (Object)this);
        processHandler.addProcessListener((ProcessListener)new GwtDevModeProcessListener());
        processHandler.addProcessListener((ProcessListener)new GwtDevModeTerminationProcessListener());
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)view, (ProcessHandler)processHandler, this.createActions(mainConsole, (ProcessHandler)processHandler, executor));
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtCommandLineState", "executeImpl"));
        }
        return defaultExecutionResult;
    }

    private boolean hasNoServerParameter() {
        return this.myPatchedShellParametersList.hasParameter("-noserver") || this.myPatchedShellParametersList.hasParameter("-nostartServer");
    }

    private HostedModeWarDirectoryGenerator createDevModeWarDirectoryGenerator(File warDirectory, File cacheFile) {
        HostedModeWarDirectoryGenerator generator = new HostedModeWarDirectoryGenerator(warDirectory, cacheFile);
        ArrayList webFacets = new ArrayList();
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)this.myModule).withoutSdk().productionOnly().runtimeOnly().recursively();
        enumerator.forEachModule(module -> {
            GwtFacet facet = GwtFacet.getInstance(module);
            if (facet != null) {
                ContainerUtil.addIfNotNull((Collection)webFacets, (Object)facet.getWebFacet());
            } else {
                webFacets.addAll(WebFacet.getInstances((Module)module));
            }
            return true;
        });
        for (WebFacet webFacet : webFacets) {
            for (WebRoot webRoot : webFacet.getWebRoots()) {
                VirtualFile dir = webRoot.getFile();
                if (dir == null) continue;
                generator.addFile(dir, webRoot.getRelativePath());
            }
        }
        PathsList classpath = enumerator.getPathsList();
        VirtualFile gwtUserJar = ((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk().getUserJar();
        boolean gwtServletJarFound = false;
        String servletJarPath = FileUtil.toSystemIndependentName((String)((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk().getServletJarPath());
        VirtualFile gwtServletJar = LocalFileSystem.getInstance().findFileByPath(servletJarPath);
        for (VirtualFile file : classpath.getVirtualFiles()) {
            if (file.isDirectory()) {
                generator.addFile(file, "WEB-INF/classes");
                continue;
            }
            if (gwtUserJar != null && gwtUserJar.equals(file)) continue;
            generator.addFile(file, "WEB-INF/lib/" + file.getName());
            if (!file.equals(gwtServletJar)) continue;
            gwtServletJarFound = true;
        }
        if (!gwtServletJarFound && gwtServletJar != null) {
            generator.addFile(gwtServletJar, "WEB-INF/lib/" + gwtServletJar.getName());
        }
        return generator;
    }

    @Nullable
    public RemoteUiConnection getUiConnection() {
        return this.myUiConnection;
    }

    public String getRunConfigurationName() {
        return this.myRunConfigurationName;
    }

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        AnAction action;
        Object[] actions = super.createActions(console, processHandler, executor);
        if (this.myFacet.getSdkVersion().isHostedModeRequiresWebXml() && (action = ActionManager.getInstance().getAction("javaee.UpdateRunningApplication")) != null) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)action);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtCommandLineState", "createActions"));
            }
            return anActionArray;
        }
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtCommandLineState", "createActions"));
        }
        return actions;
    }

    private void patchWebXml(File webXml) throws IOException, JDOMException {
        File devJar = new File(((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk().getDevJarPath());
        if (!devJar.exists()) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(devJar);){
            Element target;
            ZipEntry zipEntry = zipFile.getEntry(WEB_XML_PATH);
            InputStream input = zipFile.getInputStream(zipEntry);
            Document document = JDOMUtil.loadDocument((InputStream)input);
            Element targetRoot = target = JDOMUtil.load((File)webXml);
            ReadAction.run(() -> this.deleteGwtServlets(targetRoot));
            for (Element child : document.getRootElement().getChildren()) {
                Element copy = child.clone();
                copy.setNamespace(targetRoot.getNamespace());
                for (Element grandChild : copy.getChildren()) {
                    grandChild.setNamespace(targetRoot.getNamespace());
                }
                targetRoot.addContent(copy);
            }
            JdomKt.write((Parent)target, (Path)webXml.toPath(), (String)SystemProperties.getLineSeparator());
        }
    }

    private void deleteGwtServlets(Element root) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        ArrayList<Element> toRemove = new ArrayList<Element>();
        HashSet<String> servletNamesToRemove = new HashSet<String>();
        for (Element servlet : root.getChildren("servlet", root.getNamespace())) {
            PsiClass psiClass;
            String className = servlet.getChildTextTrim("servlet-class", root.getNamespace());
            if (className == null || !RemoteServiceUtil.isRemoteServiceImplementation(psiClass = psiFacade.findClass(className, scope))) continue;
            toRemove.add(servlet);
            servletNamesToRemove.add(servlet.getChildTextTrim("servlet-name", root.getNamespace()));
        }
        for (Element mapping : root.getChildren("servlet-mapping", root.getNamespace())) {
            String servletName = mapping.getChildTextTrim("servlet-name", root.getNamespace());
            if (!servletNamesToRemove.contains(servletName)) continue;
            toRemove.add(mapping);
        }
        for (Element element : toRemove) {
            root.removeContent((Content)element);
        }
    }

    private void addParametersString(ParametersList list, String params) {
        for (String param : ParametersList.parse((String)params)) {
            this.addParameter(list, param);
        }
    }

    private void addParameter(ParametersList list, String param) {
        list.add(this.expandModuleDir(param));
    }

    private String expandModuleDir(String value) {
        if (this.myModuleDir != null && value.contains(MODULE_DIR_MACRO)) {
            return value.replace(MODULE_DIR_MACRO, this.myModuleDir);
        }
        return value;
    }

    private class MyFrameStateListener
    extends FrameStateListener.Adapter {
        private final HostedModeWarDirectoryGenerator myGenerator;

        public MyFrameStateListener(HostedModeWarDirectoryGenerator generator) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/gwt/run/GwtCommandLineState$MyFrameStateListener", "<init>"));
            }
            this.myGenerator = generator;
        }

        public void onFrameDeactivated() {
            if (((GwtCommandLineState)GwtCommandLineState.this).myRunConfiguration.getState().UPDATE_RESOURCES_ON_FRAME_DEACTIVATION) {
                this.myGenerator.updateResources(GwtCommandLineState.this.myModule.getProject(), GwtCommandLineState.this.myRunConfigurationName);
            }
        }
    }

    private static class GwtDevModeProcessListener
    extends ProcessAdapter {
        private boolean myOpenUrl;
        private final OutputLineReader myLineReader = new DelegatingOutputLineReader(this::parseLine);

        private GwtDevModeProcessListener() {
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                this.myLineReader.parseOutput(event.getText());
            }
        }

        private void parseLine(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/gwt/run/GwtCommandLineState$GwtDevModeProcessListener", "parseLine"));
            }
            if (line.endsWith("please browse to")) {
                this.myOpenUrl = true;
            } else if (!line.equals("the following URL:")) {
                if (this.myOpenUrl) {
                    BrowserUtil.browse((String)line);
                }
                this.myOpenUrl = false;
            }
        }
    }

    private class GwtDevModeTerminationProcessListener
    extends ProcessAdapter {
        private GwtDevModeTerminationProcessListener() {
        }

        public void processTerminated(ProcessEvent event) {
            GwtCommandLineState.this.onException();
        }
    }
}

