/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentList, JSFunctionWithSubstitutor, JSExpression> {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{JSCallExpression.class});
    private static final Set<Class<?>> ourStopSearch = Collections.singleton(JSFunction.class);
    private static final int MAX_CANCELED_RETRY_COUNT = 5;

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<Class<?>> set = ourStopSearch;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof JSFunctionItem) {
            LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
            if (o instanceof JSFunction) {
                for (PsiElement el : DefinitionsScopedSearch.search((PsiElement)((JSFunction)o))) {
                    if (!(el instanceof JSFunction)) continue;
                    JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, (JSFunctionItem)((JSFunction)el), null);
                }
            }
            ArrayList<JSFunctionWithSubstitutor> result = new ArrayList<JSFunctionWithSubstitutor>(typedSignatures.size() + 1);
            result.add(new JSFunctionWithSubstitutor((JSFunctionItem)o, null));
            ContainerUtil.addAll(result, typedSignatures.values());
            return ArrayUtil.toObjectArray(result);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static void doAddSignature(@NotNull Map<String, JSFunctionWithSubstitutor> typedSignatures, @NotNull Map<String, JSFunctionWithSubstitutor> untypedSignatures, @NotNull Set<String> untypedKeysForTypedSignatures, @NotNull JSFunctionItem functionItem, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (typedSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedSignatures", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (untypedSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untypedSignatures", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (untypedKeysForTypedSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untypedKeysForTypedSignatures", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (functionItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionItem", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        String typedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)false, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text;
        String untypedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)true, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text;
        if (typedSignature.equals(untypedSignature)) {
            if (!untypedSignatures.containsKey(untypedSignature)) {
                untypedSignatures.put(untypedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            }
        } else if (!typedSignatures.containsKey(typedSignature)) {
            typedSignatures.put(typedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            untypedKeysForTypedSignatures.add(untypedSignature);
        }
    }

    public Object[] getParametersForDocumentation(JSFunctionWithSubstitutor p, ParameterInfoContext context) {
        return p.myFunctionItem.getParameters();
    }

    public JSArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "findElementForParameterInfo"));
        }
        JSArgumentList argList = JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
        if (argList == null) {
            return null;
        }
        if (this.skipTypeScript() && DialectDetector.isTypeScript((PsiElement)argList)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Stream<JSFunctionWithSubstitutor> resultStream = this.fillSignaturesForArgumentList(context, argList);
            if (resultStream != null) {
                context.setItemsToShow(resultStream.toArray());
                return argList;
            }
            context.setItemsToShow(null);
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "lambda$findElementForParameterInfo$1"));
            }
            int canceledCount = 0;
            while (canceledCount < 5) {
                boolean isInvalid = (Boolean)ReadAction.compute(() -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "lambda$null$0"));
                    }
                    if (!argList.isValid() || JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset()) != argList) {
                        return true;
                    }
                    Editor editor = context.getEditor();
                    return context.getProject().isDisposed() || editor.isDisposed();
                });
                if (isInvalid) {
                    return;
                }
                ProgressIndicatorBase indicator = new ProgressIndicatorBase();
                boolean success = this.runInReadActionWithWritePriority(context, argList, (ProgressIndicator)indicator);
                if (success) {
                    return;
                }
                if (!indicator.isCanceled()) continue;
                ++canceledCount;
            }
        });
        return null;
    }

    private boolean runInReadActionWithWritePriority(@NotNull CreateParameterInfoContext context, @NotNull JSArgumentList argList, @NotNull ProgressIndicator indicator) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "runInReadActionWithWritePriority"));
        }
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/javascript/JSParameterInfoHandler", "runInReadActionWithWritePriority"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/JSParameterInfoHandler", "runInReadActionWithWritePriority"));
        }
        return ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "lambda$runInReadActionWithWritePriority$3"));
            }
            if (argList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/javascript/JSParameterInfoHandler", "lambda$runInReadActionWithWritePriority$3"));
            }
            Stream<JSFunctionWithSubstitutor> resultStream = this.fillSignaturesForArgumentList(context, argList);
            if (resultStream != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "lambda$null$2"));
                    }
                    if (argList == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/javascript/JSParameterInfoHandler", "lambda$null$2"));
                    }
                    context.setItemsToShow(resultStream.toArray());
                    this.showParameterInfo(argList, context);
                });
            }
        }, indicator);
    }

    @Nullable
    public static JSArgumentList findArgumentList(PsiFile file, int offset) {
        JSCallExpression callExpression;
        JSArgumentList argList = (JSArgumentList)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSArgumentList.class, (Class[])new Class[]{JSStatement.class, JSFunctionExpression.class});
        if (argList == null && (callExpression = (JSCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSCallExpression.class, (Class[])new Class[]{JSStatement.class})) != null) {
            argList = callExpression.getArgumentList();
        }
        return argList;
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentList argList) {
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/javascript/JSParameterInfoHandler", "fillSignaturesForArgumentList"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression parent = (JSCallExpression)psiElement;
        JSExpression methodExpression = JSUtils.unparenthesize(parent.getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression) {
            return this.fillSignaturesForReferenceExpression(parent, methodExpression);
        }
        if (methodExpression instanceof JSSuperExpression) {
            PsiElement clazz = methodExpression.getReference().resolve();
            if (clazz instanceof JSFunction) {
                return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunction)clazz), null));
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunctionExpression)methodExpression), null));
        }
        return null;
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForReferenceExpression(@NotNull JSCallExpression parent, @NotNull JSExpression methodExpression) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/JSParameterInfoHandler", "fillSignaturesForReferenceExpression"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/javascript/JSParameterInfoHandler", "fillSignaturesForReferenceExpression"));
        }
        ResolveResult[] resolveResults = ((JSReferenceExpression)methodExpression).multiResolve(true);
        if (resolveResults.length <= 0) {
            return null;
        }
        Collection<PsiElement> elements = JSResolveResult.toElements(resolveResults, false);
        if (elements.size() == 0) {
            return null;
        }
        elements = JSParameterInfoHandler.getElementsWithConstructors(parent, elements);
        LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>(resolveResults.length);
        LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
        HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
        JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
        ArrayList<JSFunctionItem> items = JSParameterInfoHandler.getFunctionItems(parent, methodExpression, elements);
        JSTypeSubstitutor typeSubstitutor = JSParameterInfoHandler.getTypeSubstitutor(methodExpression, qualifier, items);
        for (JSFunctionItem functionItem : items) {
            JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, functionItem, typeSubstitutor);
        }
        Stream typedStream = typedSignatures.values().stream();
        Stream.Builder untypedStreamBuilder = Stream.builder();
        for (Map.Entry entry : untypedSignatures.entrySet()) {
            if (untypedKeysForTypedSignatures.contains(entry.getKey())) continue;
            untypedStreamBuilder.add(entry.getValue());
        }
        return Stream.concat(typedStream, untypedStreamBuilder.build());
    }

    @NotNull
    private static ArrayList<JSFunctionItem> getFunctionItems(@NotNull JSCallExpression parent, @NotNull JSExpression methodExpression, @NotNull Collection<PsiElement> elements) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionItems"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionItems"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionItems"));
        }
        ArrayList items = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            Collection<? extends JSFunctionItem> functionItems = JSParameterInfoHandler.getFunctionItems(parent, methodExpression, element);
            if (functionItems.size() == 0) continue;
            items.addAll(functionItems);
        }
        ArrayList arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionItems"));
        }
        return arrayList;
    }

    @Nullable
    private static JSTypeSubstitutor getTypeSubstitutor(JSExpression methodExpression, @Nullable JSExpression qualifier, @NotNull List<JSFunctionItem> items) {
        JSNamespace namespace;
        JSType qualifierType;
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/javascript/JSParameterInfoHandler", "getTypeSubstitutor"));
        }
        JSFunctionItem firstFunction = (JSFunctionItem)ContainerUtil.getFirstItem(items);
        if (firstFunction instanceof TypeScriptFunction) {
            return TypeScriptGenericTypesEvaluator.getTypeSubstitutorForMember((JSElement)ContainerUtil.getFirstItem(items), (PsiElement)methodExpression);
        }
        if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, true, false)) != null) {
            return (JSTypeSubstitutor)namespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY);
        }
        return null;
    }

    private static Collection<PsiElement> getElementsWithConstructors(JSCallExpression parent, Collection<PsiElement> elements) {
        if (parent instanceof JSNewExpression) {
            ArrayList newElements = ContainerUtil.newArrayListWithCapacity((int)elements.size());
            for (PsiElement element : elements) {
                if (element instanceof JSClass) {
                    ResolveResult[] constructorResults;
                    JSClass jsClass = (JSClass)element;
                    for (ResolveResult result : constructorResults = JSClassUtils.resolveES6Constructor(jsClass, parent.getMethodExpression())) {
                        PsiElement resultConstructor = result.getElement();
                        if (resultConstructor == null) continue;
                        newElements.add(resultConstructor);
                    }
                    continue;
                }
                newElements.add(element);
            }
            elements = newElements;
        }
        return elements;
    }

    @NotNull
    private static Collection<? extends JSFunctionItem> getFunctionItems(JSCallExpression parent, JSExpression methodExpression, PsiElement element) {
        JSFunctionItem functionItem = JSParameterInfoHandler.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
        if (functionItem == null) {
            JSType jsType = JSTypeUtils.getTypeOfElement(element);
            if ((jsType = JSTypeUtils.getValuableType(jsType)) != null) {
                JSType functionType = JSTypeUtils.getFunctionType(jsType, parent instanceof JSNewExpression).findAny().orElse(null);
                if (functionType instanceof JSGenericTypeImpl) {
                    functionType = ((JSGenericTypeImpl)functionType).getType();
                }
                if (functionType != null) {
                    PsiElement sourceElement = jsType.getSource().getSourceElement();
                    if (sourceElement instanceof JSFunctionItem) {
                        functionItem = (JSFunctionItem)sourceElement;
                    } else {
                        PsiElement functionSourceElement;
                        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
                        if (holder != null && !holder.isECMA4 && (functionSourceElement = functionType.getSource().getSourceElement()) instanceof JSFunctionItem) {
                            functionItem = (JSFunctionItem)functionSourceElement;
                        }
                    }
                }
            }
        }
        if (functionItem instanceof TypeScriptFunction) {
            Collection<? extends JSFunctionItem> collection = JSParameterInfoHandler.getFunctionWithOverloadSignatures((TypeScriptFunction)functionItem);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionItems"));
            }
            return collection;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)functionItem);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionItems"));
        }
        return list;
    }

    @NotNull
    private static Collection<? extends JSFunctionItem> getFunctionWithOverloadSignatures(@NotNull TypeScriptFunction functionItem) {
        TypeScriptFunction implementation;
        if (functionItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionItem", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionWithOverloadSignatures"));
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        boolean isOverloadImpl = functionItem.isOverloadImplementation();
        if (!isOverloadImpl) {
            result.add(functionItem);
        }
        result.addAll(TypeScriptPsiUtil.getAllOverloads(functionItem));
        TypeScriptFunction typeScriptFunction = implementation = isOverloadImpl ? functionItem : TypeScriptPsiUtil.getOverloadImplementation(functionItem);
        if (implementation != null) {
            result.remove(implementation);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getFunctionWithOverloadSignatures"));
        }
        return linkedHashSet;
    }

    public void showParameterInfo(@NotNull JSArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterOwner", "com/intellij/javascript/JSParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() != parameterOwner) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JSTokenTypes.COMMA);
        context.setCurrentParameter(currentParameterIndex);
    }

    @NotNull
    public String getParameterCloseChars() {
        if (",){" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getParameterCloseChars"));
        }
        return ",){";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(JSFunctionWithSubstitutor pair, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "updateUI"));
        }
        JSFunctionItem p = pair.myFunctionItem;
        if (!(p instanceof JSImplicitFunctionImpl) && !p.isValid()) {
            return;
        }
        JSParameterItem[] params = p.getParameters();
        int currentParameterIndex = context.getCurrentParameterIndex() >= 0 ? context.getCurrentParameterIndex() : params.length;
        JSParameterItem parameter = currentParameterIndex < params.length ? params[currentParameterIndex] : null;
        SignatureInfo signatureInfo = JSParameterInfoHandler.buildSignature(p, false, currentParameterIndex, pair.myTypeSubstitutor);
        String name = signatureInfo.text;
        String currentParameterSignature = parameter != null ? JSParameterInfoHandler.getSignatureForParameter(parameter, pair.myTypeSubstitutor) : null;
        int highlightStart = parameter != null ? signatureInfo.selectedParameterStart : 0;
        int highlightEnd = parameter != null ? highlightStart + currentParameterSignature.length() : 0;
        context.setupUIComponentPresentation(name, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunctionCarefully(@NotNull PsiElement resolveResult, @Nullable PsiElement methodExpression) {
        PsiElement module;
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/javascript/JSParameterInfoHandler", "calculatePossibleFunctionCarefully"));
        }
        if (resolveResult instanceof JSParameter && (module = JSAmdPsiUtil.findReferencedModule((JSParameter)resolveResult)) != null) {
            resolveResult = module;
        }
        return JSPsiImplUtils.calculatePossibleFunction(resolveResult, methodExpression);
    }

    @NotNull
    private static SignatureInfo buildSignature(@NotNull JSFunctionItem function, boolean skipType, int selectedParameterIndex, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/javascript/JSParameterInfoHandler", "buildSignature"));
        }
        JSParameterItem[] params = function.getParameters();
        SignatureInfo info = new SignatureInfo();
        if (params.length > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                if (selectedParameterIndex == i) {
                    info.selectedParameterStart = result.toString().length();
                }
                result.append(JSParameterInfoHandler.getSignatureForParameter(params[i], skipType, typeSubstitutor));
            }
            if (function.isReferencesArguments()) {
                result.append(", ...");
            }
            info.text = result.toString();
        } else {
            String signature = function.isReferencesArguments() ? "..." : CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            info.text = signature;
        }
        SignatureInfo signatureInfo = info;
        if (signatureInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "buildSignature"));
        }
        return signatureInfo;
    }

    private static String getSignatureForParameter(JSParameterItem p, boolean skipType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSParameterTypeDecorator decorator = p.getTypeDecorator();
        JSType type = p.getTypeIncludingOverridden();
        if (type != null) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor);
        }
        String initializerText = p instanceof JSParameter ? ((JSParameter)p).getLiteralOrReferenceInitializerText() : null;
        DialectOptionHolder holder = p instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)p) : null;
        if (!(skipType |= p instanceof JSDestructuringParameter && ((JSDestructuringParameter)p).getTypeElement() == null) && type != null) {
            boolean needOptional;
            String s = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            boolean isActionScript = holder != null && holder.isECMA4;
            boolean isTypeScript = holder != null && holder.isTypeScript;
            boolean useColonTypeNotation = isTypeScript || isActionScript;
            StringBuilder result = new StringBuilder();
            boolean bl = needOptional = p.isOptional() && initializerText == null;
            if (useColonTypeNotation) {
                if (p.isRest()) {
                    result.append("... ");
                    result.append(p.getName());
                } else {
                    result.append(p.getName());
                    if (needOptional) {
                        result.append('?');
                    }
                }
                result.append(":");
                if (isTypeScript) {
                    result.append(" ");
                }
                result.append(JSLookupUtilImpl.getShortName(s));
            } else {
                result.append("[");
                if (decorator.isRest()) {
                    result.append("...");
                }
                result.append(s);
                if (needOptional) {
                    result.append(", optional");
                }
                result.append("] ").append(p.getName());
            }
            if (initializerText != null) {
                result.append(" = ");
                result.append(initializerText);
            }
            return result.toString();
        }
        String res = p.getName();
        if (p.isRest()) {
            res = "... " + res;
        }
        if (p.isOptional() && decorator.isExplicitlyDeclared()) {
            res = "[optional] " + res;
        }
        if (initializerText != null) {
            res = res + " = " + initializerText;
        }
        return res;
    }

    public static String getSignatureForParameter(JSParameterItem p) {
        return JSParameterInfoHandler.getSignatureForParameter(p, null);
    }

    public static String getSignatureForParameter(JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor) {
        return JSParameterInfoHandler.getSignatureForParameter(p, false, typeSubstitutor);
    }

    @NotNull
    public JSExpression[] getActualParameters(@NotNull JSArgumentList jsArgumentList) {
        if (jsArgumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsArgumentList", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameters"));
        }
        JSExpression[] jSExpressionArray = jsArgumentList.getArguments();
        if (jSExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameters"));
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Class<JSArgumentList> getArgumentListClass() {
        if (JSArgumentList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgumentListClass"));
        }
        return JSArgumentList.class;
    }

    protected boolean skipTypeScript() {
        return true;
    }

    private static class SignatureInfo {
        String text;
        int selectedParameterStart = -1;

        private SignatureInfo() {
        }
    }
}

