/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.modules.PackageJsonDocumentDependencies;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonDependencies {
    private final Map<String, String> myDependencies;
    private final Map<String, String> myDevDependencies;
    private final Map<String, String> myOptionalDependencies;

    public PackageJsonDependencies(@NotNull Map<String, String> dependencies, @NotNull Map<String, String> devDependencies, @NotNull Map<String, String> optionalDependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "<init>"));
        }
        if (devDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devDependencies", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "<init>"));
        }
        if (optionalDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionalDependencies", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "<init>"));
        }
        this.myDependencies = ImmutableMap.copyOf(dependencies);
        this.myDevDependencies = ImmutableMap.copyOf(devDependencies);
        this.myOptionalDependencies = ImmutableMap.copyOf(optionalDependencies);
    }

    @NotNull
    public Map<String, String> getDependencies() {
        Map<String, String> map = this.myDependencies;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "getDependencies"));
        }
        return map;
    }

    @NotNull
    public Map<String, String> getDevDependencies() {
        Map<String, String> map = this.myDevDependencies;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "getDevDependencies"));
        }
        return map;
    }

    @NotNull
    public Map<String, String> getOptionalDependencies() {
        Map<String, String> map = this.myOptionalDependencies;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "getOptionalDependencies"));
        }
        return map;
    }

    public boolean isEmpty() {
        return this.myDependencies.isEmpty() && this.myDevDependencies.isEmpty() && this.myOptionalDependencies.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageJsonDependencies that = (PackageJsonDependencies)o;
        return this.myDependencies.equals(that.myDependencies) && this.myDevDependencies.equals(that.myDevDependencies) && this.myOptionalDependencies.equals(that.myOptionalDependencies);
    }

    public int hashCode() {
        int result = this.myDependencies.hashCode();
        result = 31 * result + this.myDevDependencies.hashCode();
        result = 31 * result + this.myOptionalDependencies.hashCode();
        return result;
    }

    @Nullable
    public static PackageJsonDependencies getOrCreate(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "getOrCreate"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependencies", "getOrCreate"));
        }
        return PackageJsonDocumentDependencies.getInstance().getForFile(project, packageJson);
    }
}

