/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesVerifier;
import com.intellij.javascript.nodejs.packageJson.PackageJsonGetDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.PackageJsonSeveralFilesAction;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakValueHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang.StringEscapeUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PackageJsonUpdateNotifier", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PackageJsonUpdateNotifier
implements PersistentStateComponent<Element> {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Dependencies from package.json", NotificationDisplayType.STICKY_BALLOON, false, null);
    private static final String PACKAGE_JSON_HREF = "package.json";
    private static final String DISMISSED = "dismissed";
    private static final long MERGING_DELAY_MILLIS = 1000L;
    private final Project myProject;
    private final ProjectFileIndex myFileIndex;
    private final Set<VirtualFile> myDismissedFiles;
    private final Set<VirtualFile> myOpenedPackageJsonFiles;
    private final Map<VirtualFile, Notification> myShownNotifications;
    private final VolatileNotNullLazyValue<Boolean> myNodeInterpreterFound;
    private final Alarm mySchedulingAlarm;
    private final Set<VirtualFile> myScheduledPackageJsonFiles;

    public PackageJsonUpdateNotifier(@NotNull Project project, @NotNull ProjectFileIndex fileIndex) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "<init>"));
        }
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "<init>"));
        }
        this.myDismissedFiles = Collections.synchronizedSet(new HashSet());
        this.myOpenedPackageJsonFiles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.myShownNotifications = new WeakValueHashMap();
        this.myScheduledPackageJsonFiles = new HashSet<VirtualFile>();
        this.myProject = project;
        this.myFileIndex = fileIndex;
        this.myNodeInterpreterFound = VolatileNotNullLazyValue.createValue(() -> {
            NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getDefault();
            return interpreter != null;
        });
        this.mySchedulingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    public void onPackageJsonContentChanged(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "onPackageJsonContentChanged"));
        }
        VirtualFile projectPackageJson = this.findProjectPackageJson(packageJson);
        if (projectPackageJson != null) {
            this.scheduleProcessing(projectPackageJson);
        }
    }

    public void onPackageJsonAdded(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "onPackageJsonAdded"));
        }
        VirtualFile projectPackageJson = this.findProjectPackageJson(packageJson);
        if (projectPackageJson != null) {
            this.scheduleProcessing(projectPackageJson);
        }
    }

    public void scheduleProcessing(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "scheduleProcessing"));
        }
        this.scheduleProcessing(Collections.singleton(packageJson), 1000L);
    }

    @Nullable
    private VirtualFile findProjectPackageJson(@NotNull VirtualFile packageJson) {
        VirtualFile projectPackageJson;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "findProjectPackageJson"));
        }
        if (this.myFileIndex.isInContent(packageJson)) {
            return packageJson;
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(packageJson);
        if (nodeModulesDir != null && (projectPackageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && this.myFileIndex.isInContent(projectPackageJson)) {
            return projectPackageJson;
        }
        return null;
    }

    private void scheduleProcessing(@NotNull Collection<VirtualFile> packageJsonFiles, long delayMillis) {
        if (packageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "scheduleProcessing"));
        }
        ReadAction.run(() -> {
            if (packageJsonFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "lambda$scheduleProcessing$3"));
            }
            if (!this.myProject.isDisposed()) {
                this.mySchedulingAlarm.cancelAllRequests();
                Set<VirtualFile> set = this.myScheduledPackageJsonFiles;
                synchronized (set) {
                    this.myScheduledPackageJsonFiles.addAll(packageJsonFiles);
                }
                this.mySchedulingAlarm.addRequest(() -> {
                    HashSet<VirtualFile> copy;
                    Set<VirtualFile> set = this.myScheduledPackageJsonFiles;
                    synchronized (set) {
                        copy = new HashSet<VirtualFile>(this.myScheduledPackageJsonFiles);
                        this.myScheduledPackageJsonFiles.clear();
                    }
                    ReadAction.run(() -> this.processPackageJsonFiles(copy));
                }, delayMillis);
            }
        });
    }

    @NotNull
    public static PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "getInstance"));
        }
        PackageJsonUpdateNotifier packageJsonUpdateNotifier = (PackageJsonUpdateNotifier)ServiceManager.getService((Project)project, PackageJsonUpdateNotifier.class);
        if (packageJsonUpdateNotifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "getInstance"));
        }
        return packageJsonUpdateNotifier;
    }

    public void onProjectOpened() {
        ArrayList packageJsonFiles = new ArrayList();
        ReadAction.run(() -> {
            if (!this.myProject.isDisposed()) {
                for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(contentRoot);
                        if (packageJson == null) continue;
                        packageJsonFiles.add(packageJson);
                    }
                }
            }
        });
        this.init((List<VirtualFile>)ImmutableList.copyOf(packageJsonFiles));
    }

    private void init(@NotNull List<VirtualFile> rootPackageJsonFiles) {
        if (rootPackageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPackageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "init"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (rootPackageJsonFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPackageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "lambda$init$5"));
            }
            List openedPackageJsonFiles = Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()).filter(PackageJsonUtil::isPackageJsonFile).collect(Collectors.toList());
            this.scheduleProcessing(ContainerUtil.union((Collection)rootPackageJsonFiles, openedPackageJsonFiles), 0L);
            this.myOpenedPackageJsonFiles.addAll(openedPackageJsonFiles);
            this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

                public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$1", "fileOpened"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$1", "fileOpened"));
                    }
                    if (PackageJsonUtil.isPackageJsonFile(file)) {
                        PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.add(file);
                        PackageJsonUpdateNotifier.this.scheduleProcessing(file);
                    }
                }

                public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$1", "fileClosed"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$1", "fileClosed"));
                    }
                    PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.remove(file);
                    if (PackageJsonUtil.isPackageJsonFile(file) && !PackageJsonUpdateNotifier.this.isRootFile(file)) {
                        PackageJsonUpdateNotifier.this.hideNotificationLater(file);
                    }
                }
            });
        }, this.myProject.getDisposed());
    }

    private void processPackageJsonFiles(@NotNull Set<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "processPackageJsonFiles"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        boolean externalUpdateRunning = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).isExternalUpdateRunning();
        for (VirtualFile file : packageJsonFiles) {
            PackageJsonDependencies deps;
            VirtualFile nodeModulesDir;
            ThreeState enabled = this.isPackageJsonNotificationEnabled(file);
            if (enabled == ThreeState.NO || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file)) == null && !this.isRootFile(file) && !this.myOpenedPackageJsonFiles.contains(file) || PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)file) || (deps = PackageJsonDependencies.getOrCreate(this.myProject, file)) == null || deps.isEmpty()) continue;
            if (externalUpdateRunning) {
                this.hideNotificationLater(file);
                continue;
            }
            if (PackageJsonUpdateNotifier.isNodeModulesUpdatingExternally(file)) {
                this.hideNotificationLater(file);
                continue;
            }
            if (nodeModulesDir != null) {
                boolean depsMatched = new PackageJsonDependenciesVerifier(this.myProject, file).verify();
                if (depsMatched) {
                    this.hideNotificationLater(file);
                    continue;
                }
                result.add(file);
                continue;
            }
            result.add(file);
        }
        if (!result.isEmpty() && ((Boolean)this.myNodeInterpreterFound.getValue()).booleanValue()) {
            this.showNotification(result);
        }
    }

    private boolean isRootFile(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "isRootFile"));
        }
        VirtualFile parent = packageJson.getParent();
        if (parent == null) {
            return false;
        }
        VirtualFile contentRoot = this.myFileIndex.getContentRootForFile(parent, false);
        return parent.equals(contentRoot);
    }

    @Nullable
    private ThreeState isPackageJsonNotificationEnabled(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "isPackageJsonNotificationEnabled"));
        }
        if (this.myDismissedFiles.contains(packageJson)) {
            return ThreeState.NO;
        }
        if (!this.isInWebModule(packageJson)) {
            return ThreeState.NO;
        }
        return null;
    }

    private static boolean isNodeModulesUpdatingExternally(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "isNodeModulesUpdatingExternally"));
        }
        File parent = VfsUtilCore.virtualToIoFile((VirtualFile)packageJson).getParentFile();
        if (parent == null) {
            return true;
        }
        return new File(parent, "node_modules" + File.separator + ".staging").isDirectory();
    }

    private void showNotification(@NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "showNotification"));
        }
        if (packageJsonFiles.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (packageJsonFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "lambda$showNotification$6"));
            }
            if (packageJsonFiles.size() > 1) {
                Notification notification = NOTIFICATION_GROUP.createNotification("Install Dependencies", "From " + packageJsonFiles.size() + " package.json files", NotificationType.INFORMATION, null);
                notification.addAction((AnAction)new PackageJsonSeveralFilesAction(this.myProject, packageJsonFiles, notification));
                notification.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification));
                notification.notify(this.myProject);
            } else {
                VirtualFile packageJson = (VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem((List)packageJsonFiles));
                if (this.isNotificationShownFor(packageJson)) {
                    return;
                }
                VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
                String packageJsonPath = JsbtUtil.getRelativePath(this.myProject, packageJson, false);
                if (nodeModulesDir == null) {
                    Notification notification = NOTIFICATION_GROUP.createNotification("Install Dependencies", "From " + PackageJsonUpdateNotifier.createLink(PACKAGE_JSON_HREF, packageJsonPath), NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener(packageJson));
                    notification.addAction((AnAction)new PackageJsonGetDependenciesAction(packageJson, true, notification));
                    notification.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification));
                    notification.notify(this.myProject);
                    this.register(packageJson, notification);
                } else {
                    Notification notification = NOTIFICATION_GROUP.createNotification("Update Dependencies", "From " + PackageJsonUpdateNotifier.createLink(PACKAGE_JSON_HREF, packageJsonPath), NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener(packageJson));
                    notification.addAction((AnAction)new PackageJsonGetDependenciesAction(packageJson, false, notification));
                    notification.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification));
                    notification.notify(this.myProject);
                    this.register(packageJson, notification);
                }
            }
        }, this.myProject.getDisposed());
    }

    private boolean isNotificationShownFor(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "isNotificationShownFor"));
        }
        Notification notification = this.myShownNotifications.get(packageJson);
        if (notification != null) {
            Balloon balloon = notification.getBalloon();
            return balloon != null && !balloon.isDisposed();
        }
        return false;
    }

    private void hideNotificationLater(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "hideNotificationLater"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (packageJson == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "lambda$hideNotificationLater$7"));
            }
            Notification notification = this.myShownNotifications.get(packageJson);
            if (notification != null && !notification.isExpired()) {
                notification.expire();
            }
        }, this.myProject.getDisposed());
    }

    private void register(final @NotNull VirtualFile packageJson, @NotNull Notification notification) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "register"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "register"));
        }
        Balloon balloon = notification.getBalloon();
        if (balloon != null) {
            this.myShownNotifications.put(packageJson, notification);
            balloon.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    PackageJsonUpdateNotifier.this.myShownNotifications.remove(packageJson);
                }
            });
        }
    }

    @NotNull
    private static String createLink(@NotNull String href, @NotNull String linkText) {
        if (href == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "href", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "createLink"));
        }
        if (linkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "createLink"));
        }
        String string = "<a href='" + StringEscapeUtils.escapeXml((String)href) + "'>" + StringEscapeUtils.escapeXml((String)linkText) + "</a>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "createLink"));
        }
        return string;
    }

    private boolean isInWebModule(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier", "isInWebModule"));
        }
        if (this.myFileIndex.getContentRootForFile(packageJson, true) == null) {
            return false;
        }
        Module module = this.myFileIndex.getModuleForFile(packageJson, true);
        if (module == null || !WebModuleTypeBase.isWebModule((Module)module)) {
            return false;
        }
        VirtualFile file = packageJson;
        while (this.myFileIndex.getModuleForFile(file, true) == module) {
            if (NodeModulesDirectoryManager.isNodeModulesDir(file)) {
                return false;
            }
            file = file.getParent();
        }
        return true;
    }

    @Nullable
    public Element getState() {
        Element root = new Element("root");
        ArrayList paths = ContainerUtil.newArrayList();
        for (VirtualFile file : this.myDismissedFiles) {
            if (!file.isValid()) continue;
            paths.add(file.getPath());
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)DISMISSED, (List)paths);
        return root;
    }

    public void loadState(Element state) {
        List paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)DISMISSED);
        paths = ContainerUtil.newArrayList((Iterable)paths);
        ArrayList<VirtualFile> dismissedFiles = new ArrayList<VirtualFile>();
        for (String path : paths) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null || !file.isValid() || !PackageJsonUtil.isPackageJsonFile(file)) continue;
            dismissedFiles.add(file);
        }
        this.myDismissedFiles.clear();
        this.myDismissedFiles.addAll(dismissedFiles);
    }

    private class MyNotificationListener
    implements NotificationListener {
        private final VirtualFile myPackageJson;

        public MyNotificationListener(VirtualFile packageJson) {
            if (packageJson == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$MyNotificationListener", "<init>"));
            }
            this.myPackageJson = packageJson;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            FileEditorManager fileManager;
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (fileManager = FileEditorManager.getInstance((Project)PackageJsonUpdateNotifier.this.myProject)) != null) {
                fileManager.openFile(this.myPackageJson, true);
            }
        }
    }

    private class PackageJsonDismissAction
    extends DumbAwareAction {
        private final Collection<VirtualFile> myPackageJsonFiles;
        private final Notification myNotification;

        public PackageJsonDismissAction(@NotNull Collection<VirtualFile> packageJsonFiles, Notification notification) {
            if (packageJsonFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$PackageJsonDismissAction", "<init>"));
            }
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$PackageJsonDismissAction", "<init>"));
            }
            super("Don't ask again");
            this.myPackageJsonFiles = packageJsonFiles;
            this.myNotification = notification;
        }

        public void actionPerformed(AnActionEvent e) {
            this.execute();
        }

        private void execute() {
            this.myNotification.expire();
            PackageJsonUpdateNotifier.this.myDismissedFiles.addAll(this.myPackageJsonFiles);
        }
    }
}

