/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorConsoleFilter
extends NodeStackTraceFilter {
    public ProtractorConsoleFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "<init>"));
        }
        super(project, baseDir);
    }

    @Override
    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        int endInd;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "parse"));
        }
        if (line.startsWith("[") && (endInd = line.indexOf("] ")) != -1) {
            int skippedPrefixLength = endInd + 2;
            List<FileHyperlinkRawData> links = this.doParse(line.substring(skippedPrefixLength));
            ArrayList<FileHyperlinkRawData> result = new ArrayList<FileHyperlinkRawData>();
            for (FileHyperlinkRawData link : links) {
                result.add(new FileHyperlinkRawData(link.getFilePath(), link.getDocumentLine(), link.getDocumentColumn(), link.getHyperlinkStartInd() + skippedPrefixLength, link.getHyperlinkEndInd() + skippedPrefixLength));
            }
            ArrayList<FileHyperlinkRawData> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "parse"));
            }
            return arrayList;
        }
        List<FileHyperlinkRawData> list = this.doParse(line);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "parse"));
        }
        return list;
    }

    @NotNull
    private List<FileHyperlinkRawData> doParse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "doParse"));
        }
        List<FileHyperlinkRawData> links = super.parse(line);
        if (!links.isEmpty()) {
            List<FileHyperlinkRawData> list = links;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "doParse"));
            }
            return list;
        }
        List list = NodeConsoleAdditionalFilter.FINDER.find(line);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "doParse"));
        }
        return list;
    }
}

