/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportedExportedDefaultBindingImpl;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportedBindingStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportedBindingImpl
extends ES6ImportedExportedDefaultBindingImpl<ES6ImportedBindingStub>
implements ES6ImportedBinding,
StubBasedPsiElement<ES6ImportedBindingStub> {
    public ES6ImportedBindingImpl(ASTNode node) {
        super(node);
    }

    @Nullable
    public Icon getIcon(int flags) {
        return PlatformIcons.IMPORT_ICON;
    }

    public ES6ImportedBindingImpl(ES6ImportedBindingStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.IMPORTED_BINDING);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6ImportedBinding((ES6ImportedBinding)this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "processDeclarations"));
        }
        return processor.execute((PsiElement)this, state);
    }

    @Override
    @NotNull
    public Collection<PsiElement> findReferencedElements() {
        if (!this.isNamespaceImport()) {
            Collection<PsiElement> collection = super.findReferencedElements();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
            }
            return collection;
        }
        PsiElement parent = this.getParent();
        if (!(parent instanceof ES6ImportDeclaration)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
            }
            return list;
        }
        ES6FromClause fromClause = ((ES6ImportDeclaration)parent).getFromClause();
        if (fromClause == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
            }
            return list;
        }
        Collection elements = fromClause.resolveReferencedElements();
        Collection<PsiElement> collection = ES6PsiUtil.getBindingAllPossibleExports(elements);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
        }
        return collection;
    }

    public boolean isNamespaceImport() {
        ES6ImportedBindingStub stub = (ES6ImportedBindingStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceImport();
        }
        return this.getNode().findChildByType(JSTokenTypes.MULT) != null;
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            return identifier.getTextOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public ES6ImportDeclaration getDeclaration() {
        return (ES6ImportDeclaration)super.getDeclaration();
    }

    public void delete() throws IncorrectOperationException {
        ES6ImportDeclaration declaration = this.getDeclaration();
        if (declaration == null) {
            super.delete();
            return;
        }
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        if (bindings.length == 1 && specifiers.length == 0) {
            declaration.delete();
        } else {
            JSChangeUtil.removeRangeWithRemovalOfCommas(this.getNode(), declaration.getNode());
        }
    }
}

