/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSStringUtil {
    public static final char SIMPLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';

    private JSStringUtil() {
    }

    public static boolean isSingleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return value != null && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'';
    }

    public static boolean isDoubleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return JSStringUtil.isDoubleQuotedString(value);
    }

    public static boolean isDoubleQuotedString(String value) {
        return value != null && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    public static String changeQuotes(String jsStringLiteral) {
        char newQuote;
        char oldQuote;
        if (jsStringLiteral.startsWith("'")) {
            oldQuote = '\'';
            newQuote = '\"';
        } else if (jsStringLiteral.startsWith("\"")) {
            oldQuote = '\"';
            newQuote = '\'';
        } else {
            return jsStringLiteral;
        }
        StringBuilder buffer = new StringBuilder(jsStringLiteral);
        boolean screened = false;
        int bufferIndex = 1;
        for (int i = 1; i < jsStringLiteral.length() - 1; ++i) {
            char c = jsStringLiteral.charAt(i);
            if (screened) {
                if (c == oldQuote) {
                    buffer.deleteCharAt(bufferIndex - 1);
                } else {
                    ++bufferIndex;
                }
                screened = false;
                continue;
            }
            if (c == '\\') {
                screened = true;
            } else if (c == newQuote) {
                buffer.insert(bufferIndex++, '\\');
            }
            ++bufferIndex;
        }
        buffer.setCharAt(0, newQuote);
        buffer.setCharAt(buffer.length() - 1, newQuote);
        return buffer.toString();
    }

    @NotNull
    public static String unescapeSimpleStringChars(@NotNull String chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/lang/javascript/JSStringUtil", "unescapeSimpleStringChars"));
        }
        int index = 0;
        StringBuilder outChars = new StringBuilder();
        block12: while (index < chars.length()) {
            char c = chars.charAt(index);
            ++index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index >= chars.length()) break;
            c = chars.charAt(index);
            ++index;
            if (c == 'u' || c == 'x') {
                outChars.append('\\').append(c);
                continue;
            }
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    continue block12;
                }
                case 't': {
                    outChars.append('\t');
                    continue block12;
                }
                case 'n': {
                    outChars.append('\n');
                    continue block12;
                }
                case 'f': {
                    outChars.append('\f');
                    continue block12;
                }
                case 'r': {
                    outChars.append('\r');
                    continue block12;
                }
                case '\"': {
                    outChars.append('\"');
                    continue block12;
                }
                case '/': {
                    outChars.append('/');
                    continue block12;
                }
                case '\n': {
                    outChars.append('\n');
                    continue block12;
                }
                case '\'': {
                    outChars.append('\'');
                    continue block12;
                }
                case '\\': {
                    outChars.append('\\');
                    continue block12;
                }
            }
            outChars.append(c);
        }
        String string = outChars.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSStringUtil", "unescapeSimpleStringChars"));
        }
        return string;
    }

    public static void escapeSimpleStringChars(@NotNull String str, char quote, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/lang/javascript/JSStringUtil", "escapeSimpleStringChars"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lang/javascript/JSStringUtil", "escapeSimpleStringChars"));
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            char ch = str.charAt(idx);
            if (ch == '\\') {
                char next;
                char c = next = idx < str.length() - 1 ? str.charAt(idx + 1) : (char)'\u0000';
                if (next == 'u' || next == 'x') {
                    buffer.append(ch);
                    continue;
                }
                buffer.append("\\\\");
                continue;
            }
            if (ch == quote) {
                buffer.append("\\").append(ch);
                continue;
            }
            if (escapeTemplateStringArg && ch == '{') {
                char prev;
                char c = prev = idx > 0 ? str.charAt(idx - 1) : (char)'\u0000';
                if (prev == '$') {
                    buffer.append("\\").append(ch);
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            if (escapeWhitespace) {
                if (ch == '\b') {
                    buffer.append("\\b");
                    continue;
                }
                if (ch == '\t') {
                    buffer.append("\\t");
                    continue;
                }
                if (ch == '\f') {
                    buffer.append("\\f");
                    continue;
                }
                if (ch == '\r') {
                    buffer.append("\\r");
                    continue;
                }
            }
            if (escapeNewlines && ch == '\n') {
                buffer.append("\\n");
                continue;
            }
            buffer.append(ch);
        }
    }
}

