/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowJSShowTypeInfoAction
extends JSShowTypeInfoAction {
    @Override
    @NotNull
    public String getInformationHint(@NotNull PsiElement element) {
        FlowJSServerService service;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
        }
        PsiFile file = element.getContainingFile();
        if (FlowJSShowTypeInfoAction.useService(file) && (service = FlowJSServerManager.getService(file)) != null) {
            FlowJSServerService.saveSyncAllUnsavedFiles(file);
            Document document = file.getViewProvider().getDocument();
            if (document != null) {
                String string = service.getTypeOfElement(element, file.getVirtualFile(), document);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
                }
                return string;
            }
        }
        String string = element instanceof JSElement ? super.getInformationHint(element) : "<unknown>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getErrorHint() {
        String string = JSBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getErrorHint"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
        }
        if (FlowJSShowTypeInfoAction.useService(elementAt.getContainingFile())) {
            List<PsiElement> list = Collections.singletonList(elementAt);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
            }
            return list;
        }
        List<PsiElement> list = super.getExpressionsAt(elementAt);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
        }
        return list;
    }

    private static boolean useService(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "useService"));
        }
        return FlowJSServerManager.getService(file) != null && FlowJSSettingsManager.areOtherServicesEnabled(file.getProject());
    }
}

