/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.lang.javascript.bower.BowerInstalledPackage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerInstalledPackagesParser {
    private BowerInstalledPackagesParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<BowerInstalledPackage> parse(@NotNull String jsonContent) throws IOException {
        if (jsonContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonContent", "com/intellij/lang/javascript/bower/BowerInstalledPackagesParser", "parse"));
        }
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonContent));
        JsonParser jsonParser = new JsonParser();
        jsonReader.setLenient(false);
        JsonElement element = jsonParser.parse(jsonReader);
        List<BowerInstalledPackage> list = BowerInstalledPackagesParser.doParsePackages(element);
        List<BowerInstalledPackage> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerInstalledPackagesParser", "parse"));
        }
        return list2;
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    private static List<BowerInstalledPackage> doParsePackages(@NotNull JsonElement element) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/bower/BowerInstalledPackagesParser", "doParsePackages"));
        }
        if (!element.isJsonObject()) {
            throw new IOException("Unexpected root element");
        }
        JsonObject root = element.getAsJsonObject();
        JsonElement dependenciesElement = root.get("dependencies");
        if (dependenciesElement == null || !dependenciesElement.isJsonObject()) {
            throw new IOException("Top level 'dependencies' object key not found");
        }
        JsonObject dependenciesObject = dependenciesElement.getAsJsonObject();
        ArrayList packages = ContainerUtil.newArrayList();
        for (Map.Entry entry : dependenciesObject.entrySet()) {
            BowerInstalledPackage pkg;
            JsonElement packageElement = (JsonElement)entry.getValue();
            if (packageElement == null || !packageElement.isJsonObject() || (pkg = BowerInstalledPackagesParser.parsePackage(packageElement.getAsJsonObject())) == null) continue;
            packages.add(pkg);
        }
        ArrayList arrayList = packages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerInstalledPackagesParser", "doParsePackages"));
        }
        return arrayList;
    }

    @Nullable
    private static BowerInstalledPackage parsePackage(@NotNull JsonObject pkgObject) throws IOException {
        JsonElement updateElement;
        JsonObject pkgMetaObject;
        if (pkgObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgObject", "com/intellij/lang/javascript/bower/BowerInstalledPackagesParser", "parsePackage"));
        }
        String name = null;
        String _release = null;
        String target = null;
        String latest = null;
        JsonObject endpointObject = JsonUtil.getChildAsObject((JsonObject)pkgObject, (String)"endpoint");
        if (endpointObject != null) {
            name = JsonUtil.getString((JsonObject)endpointObject, (String)"name");
        }
        if ((pkgMetaObject = JsonUtil.getChildAsObject((JsonObject)pkgObject, (String)"pkgMeta")) != null) {
            if (name == null) {
                name = JsonUtil.getString((JsonObject)pkgMetaObject, (String)"name");
            }
            _release = JsonUtil.getString((JsonObject)pkgMetaObject, (String)"_release");
        }
        if ((updateElement = pkgObject.get("update")) != null && updateElement.isJsonObject()) {
            JsonObject updateObject = updateElement.getAsJsonObject();
            target = JsonUtil.getString((JsonObject)updateObject, (String)"target");
            latest = JsonUtil.getString((JsonObject)updateObject, (String)"latest");
        }
        if (name != null && !name.isEmpty()) {
            return new BowerInstalledPackage(name, (String)ObjectUtils.chooseNotNull((Object)target, (Object)_release), latest);
        }
        return null;
    }
}

