/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower.browsePackages;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.javascript.bower.BowerPackageBasicInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackageSearcher {
    private static final Logger LOG = Logger.getInstance(BowerPackageSearcher.class);
    private static final String FILE_NAME = "popular-bower-packages.json";
    static final String NAME_PROP = "name";
    static final String DESCRIPTION_PROP = "description";
    private static final BowerPackageSearcher INSTANCE = new BowerPackageSearcher();
    private volatile WeakReference<List<BowerPackageBasicInfo>> myInfosRef;

    @NotNull
    public static BowerPackageSearcher getInstance() {
        BowerPackageSearcher bowerPackageSearcher = INSTANCE;
        if (bowerPackageSearcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "getInstance"));
        }
        return bowerPackageSearcher;
    }

    public List<BowerPackageBasicInfo> findPopularPackagesByPrefix(@NotNull String packageNamePrefix, int limit, @NotNull Condition<BowerPackageBasicInfo> filter) {
        if (packageNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNamePrefix", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "findPopularPackagesByPrefix"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "findPopularPackagesByPrefix"));
        }
        List<BowerPackageBasicInfo> infos = (List<BowerPackageBasicInfo>)SoftReference.dereference(this.myInfosRef);
        if (infos == null) {
            try {
                long startTime = System.nanoTime();
                infos = BowerPackageSearcher.loadPopularPackages();
                LOG.info("Popular bower package list (" + infos.size() + ") loaded in " + TimeoutUtil.getDurationMillis((long)startTime) + " ms");
            }
            catch (IOException e) {
                LOG.warn("Cannot parse popular bower package list from popular-bower-packages.json", (Throwable)e);
                infos = Collections.emptyList();
            }
            this.myInfosRef = new WeakReference<List<BowerPackageBasicInfo>>(infos);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (BowerPackageBasicInfo info : infos) {
            if (!info.getName().startsWith(packageNamePrefix) || !filter.value((Object)info)) continue;
            result.add(info);
            if (result.size() < limit) continue;
            break;
        }
        return result;
    }

    public void findPackagesByPrefix(@Nullable ProgressIndicator indicator, @NotNull String packageNamePrefix, int limit, @NotNull Condition<BowerPackageBasicInfo> filter, @NotNull Consumer<BowerPackageBasicInfo> consumer) throws IOException {
        List result;
        if (packageNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNamePrefix", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "findPackagesByPrefix"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "findPackagesByPrefix"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "findPackagesByPrefix"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                result = (List)ApplicationUtil.runWithCheckCanceled(() -> {
                    if (packageNamePrefix == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNamePrefix", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "lambda$findPackagesByPrefix$0"));
                    }
                    return BowerPackageSearcher.doFindPackagesByPrefix(indicator, packageNamePrefix, limit);
                }, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            result = BowerPackageSearcher.doFindPackagesByPrefix(indicator, packageNamePrefix, limit);
        }
        for (BowerPackageBasicInfo info : result) {
            if (!filter.value((Object)info)) continue;
            consumer.consume((Object)info);
        }
    }

    @NotNull
    static List<BowerPackageBasicInfo> doFindPackagesByPrefix(@Nullable ProgressIndicator indicator, @NotNull String packageNamePrefix, int limit) throws IOException {
        List<BowerPackageBasicInfo> list;
        if (packageNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNamePrefix", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "doFindPackagesByPrefix"));
        }
        String url = "https://libraries.io/api/bower-search?q=" + URLUtil.encodeURIComponent((String)packageNamePrefix) + "&per_page=" + limit;
        try {
            long startNano = System.nanoTime();
            String content = HttpRequests.request((String)url).readString(indicator);
            List<BowerPackageBasicInfo> infos = BowerPackageSearcher.parse(content);
            LOG.info("Found " + infos.size() + " packages matching '" + packageNamePrefix + "*' in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms (" + url + ")");
            list = infos;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch packages for '" + packageNamePrefix + "'", e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "doFindPackagesByPrefix"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<BowerPackageBasicInfo> loadPopularPackages() throws IOException {
        InputStream stream = BowerPackageSearcher.class.getResourceAsStream(FILE_NAME);
        if (stream != null) {
            InputStreamReader reader = new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET);
            List<BowerPackageBasicInfo> list = BowerPackageSearcher.parse(new String(FileUtil.adaptiveLoadText((Reader)reader)));
            List<BowerPackageBasicInfo> list2 = list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "loadPopularPackages"));
            }
            return list2;
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close stream", (Throwable)e);
                }
            }
        }
        throw new IOException("Cannot find popular-bower-packages.json");
    }

    @NotNull
    private static List<BowerPackageBasicInfo> parse(@NotNull String text) throws IOException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "parse"));
        }
        JsonReader reader = new JsonReader((Reader)new StringReader(text));
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            List<BowerPackageBasicInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "parse"));
            }
            return list;
        }
        reader.beginArray();
        ArrayList result = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            BowerPackageBasicInfo info = BowerPackageSearcher.readPackage(reader);
            if (info == null) continue;
            result.add(info);
        }
        reader.endArray();
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "parse"));
        }
        return arrayList;
    }

    @Nullable
    private static BowerPackageBasicInfo readPackage(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher", "readPackage"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String name = null;
        String description = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (NAME_PROP.equals(key)) {
                name = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if (DESCRIPTION_PROP.equals(key)) {
                description = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return name != null ? new BowerPackageBasicInfo(name, description) : null;
    }
}

