/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.settings.JSRootConfigurationBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.MessageBus;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageLevelPusher
implements FilePropertyPusher<JSLanguageLevel> {
    public static final Key<JSLanguageLevel> KEY = Key.create((String)"JS_LANGUAGE_LEVEL");
    private static final FileAttribute PERSISTENCE = new FileAttribute("js_language_level_persistence", 2, true);

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevelUpdater", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "initExtra"));
        }
        this.updateJSLibraries(project, this.getImmediateValue(project, null));
    }

    @NotNull
    public Key<JSLanguageLevel> getFileDataKey() {
        Key<JSLanguageLevel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "getFileDataKey"));
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public JSLanguageLevel getDefaultValue() {
        JSLanguageLevel jSLanguageLevel = JSLanguageLevel.DEFAULT;
        if (jSLanguageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "getDefaultValue"));
        }
        return jSLanguageLevel;
    }

    @Nullable
    public JSLanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "getImmediateValue"));
        }
        return JSRootConfiguration.getInstance(project).getLanguageLevel();
    }

    @Nullable
    public JSLanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "getImmediateValue"));
        }
        return JSRootConfiguration.getInstance(module.getProject()).getLanguageLevel();
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "acceptsFile"));
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "acceptsDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "acceptsDirectory"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull JSLanguageLevel level) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "persistAttribute"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "persistAttribute"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "persistAttribute"));
        }
        if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(fileOrDir)) {
            return;
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        JSLanguageLevel oldLanguageLevel = JSLanguageLevel.DEFAULT;
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtilRt.readINT((DataInput)iStream);
                if (oldLevelOrdinal >= 0 && oldLevelOrdinal < JSLanguageLevel.values().length) {
                    oldLanguageLevel = JSLanguageLevel.values()[oldLevelOrdinal];
                }
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtilRt.writeINT((DataOutput)oStream, (int)level.ordinal());
        oStream.close();
        if (JSRootConfigurationBase.requiresReparse(oldLanguageLevel, level)) {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, JSLanguageLevelPusher::isIndexedFile);
        }
    }

    private static boolean isIndexedFile(VirtualFile child) {
        return !child.isDirectory() && JavaScriptIndex.ourIndexedFilesFilter.acceptInput(child);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "afterRootsChanged"));
        }
        this.updateJSLibraries(project, this.getImmediateValue(project, null));
    }

    public void updateJSLibraries(@NotNull Project project, JSLanguageLevel languageLevel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "updateJSLibraries"));
        }
        if (project.isDefault()) {
            return;
        }
        Collection<VirtualFile> files = this.getApplicableLibraryFiles(project);
        Logger.getInstance(JSLanguageLevelPusher.class).debug("Pushing " + (Object)((Object)languageLevel) + "\n" + StringUtil.join(files, (String)"\n"));
        Application application = ApplicationManager.getApplication();
        Runnable action = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "lambda$updateJSLibraries$1"));
            }
            application.runReadAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "lambda$null$0"));
                }
                if (project.isDisposed()) {
                    return;
                }
                for (VirtualFile file : files) {
                    if (!file.isValid()) continue;
                    this.markRecursively(project, file, languageLevel);
                }
            });
        };
        if (application.isUnitTestMode()) {
            action.run();
        } else {
            application.executeOnPooledThread(action);
        }
    }

    @NotNull
    public Collection<VirtualFile> getApplicableLibraryFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "getApplicableLibraryFiles"));
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (ScriptingLibraryModel model : mappings.getMappings().values()) {
            if (model instanceof ScriptingLibraryMappings.CompoundLibrary) {
                for (ScriptingLibraryModel libraryModel : ((ScriptingLibraryMappings.CompoundLibrary)model).getLibraries()) {
                    files.addAll(libraryModel.getAllFiles());
                }
                continue;
            }
            files.addAll(model.getAllFiles());
        }
        files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "getApplicableLibraryFiles"));
        }
        return arrayList;
    }

    private void markRecursively(Project project, @NotNull VirtualFile file, JSLanguageLevel languageLevel) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher", "markRecursively"));
        }
        PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance((Project)project);
        FileBasedIndex.iterateRecursively((VirtualFile)file, fileOrDir -> {
            updater.findAndUpdateValue(fileOrDir, (FilePropertyPusher)this, (Object)languageLevel);
            return true;
        }, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (Set)new HashSet(), (ProjectFileIndex)ProjectRootManager.getInstance((Project)project).getFileIndex());
    }
}

