/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitComment(PsiComment comment) {
                if (DialectDetector.languageOfElement((PsiElement)comment) != JavaScriptSupportLoader.FLOW_JS) {
                    return;
                }
                int flowIndex = comment.getText().indexOf("@flow");
                if (flowIndex == -1) {
                    return;
                }
                FlowJSConfigService service = FlowJSConfigService.getService(holder.getProject());
                if (service == null) {
                    return;
                }
                PsiFile file = comment.getContainingFile();
                PsiComment flagComment = FlowJSAnnotation.findFlowFlagComment(file);
                if (flagComment != comment) {
                    return;
                }
                if (!service.getConfigOfFile(file.getVirtualFile()).isEmpty()) {
                    return;
                }
                SmartList fixes = new SmartList();
                VirtualFile currentDir = file.getContainingDirectory().getVirtualFile();
                fixes.add(new FlowJSConfigQuickFix(currentDir, JSBundle.message((String)"js.flowjs.config.inspection.to.current.path.name", (Object[])new Object[0])));
                VirtualFile baseDir = file.getProject().getBaseDir();
                if (!Objects.equals(baseDir, currentDir)) {
                    fixes.add(new FlowJSConfigQuickFix(baseDir, JSBundle.message((String)"js.flowjs.config.inspection.to.project.path.name", (Object[])new Object[0])));
                }
                TextRange range = new TextRange(flowIndex, flowIndex + "@flow".length());
                holder.registerProblem((PsiElement)comment, range, JSBundle.message((String)"js.flowjs.config.inspection.message", (Object[])new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigInspection", "createVisitor"));
        }
        return psiElementVisitor;
    }

    private static class FlowJSConfigQuickFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final VirtualFile dir;
        @NotNull
        private final String name;

        public FlowJSConfigQuickFix(@NotNull VirtualFile dir, @NotNull String name) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "<init>"));
            }
            this.dir = dir;
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.inspection.group.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "getFamilyName"));
            }
            return string;
        }

        private void createConfigFile() {
            File file = new File(this.dir.getPath() + File.separator + ".flowconfig");
            FileUtil.createIfDoesntExist((File)file);
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{this.dir});
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "applyFix"));
            }
            List<String> flowExecutableFiles = FlowJSServerService.calcPossibleFlowExecutableFiles(project);
            if (flowExecutableFiles.isEmpty()) {
                this.createConfigFile();
            } else {
                for (String path : flowExecutableFiles) {
                    if (FlowJSServerService.isFlowServerAvailable(path, project) != null) continue;
                    GeneralCommandLine line = new GeneralCommandLine();
                    line.setExePath(path);
                    line.addParameter("init");
                    line.setWorkDirectory(this.dir.getCanonicalPath());
                    try {
                        OSProcessHandler handler = new OSProcessHandler(line);
                        handler.startNotify();
                        if (handler.waitFor()) {
                            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{this.dir});
                        }
                        return;
                    }
                    catch (ExecutionException executionException) {
                    }
                }
                this.createConfigFile();
            }
        }
    }
}

