/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSErrorInspection
extends JSInspection
implements CustomSuppressableInspectionTool,
PairedUnfairLocalInspectionTool {
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "getBatchSuppressActions"));
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        return SuppressIntentionAction.EMPTY_ARRAY;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "isSuppressedFor"));
        }
        return false;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        if (this.myOnTheFly) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "createVisitor"));
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                FlowJSServerService service = FlowJSServerManager.getService(file);
                if (service == null) {
                    return;
                }
                if (!FlowJSAnnotation.isFlowAnnotation(file)) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                if (document == null) {
                    return;
                }
                Future<List<JSAnnotationError>> highlight = service.highlight(file, null);
                List<JSAnnotationError> errors = JSLanguageServiceUtil.awaitFuture(highlight);
                if (errors != null) {
                    FlowJSErrorInspection.reportErrors(errors, file, document, holder);
                }
                super.visitFile(file);
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "createVisitor"));
        }
        return psiElementVisitor;
    }

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "getInspectionForBatchShortName"));
        }
        return string;
    }

    public static void reportErrors(@NotNull List<JSAnnotationError> annotationResult, @NotNull PsiFile file, @NotNull Document document, @NotNull ProblemsHolder holder) {
        if (annotationResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResult", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "reportErrors"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "reportErrors"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "reportErrors"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flow/FlowJSErrorInspection", "reportErrors"));
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        for (JSAnnotationError result : annotationResult) {
            JSLanguageServiceUtil.PsiElementInfo info;
            if (StringUtil.isEmpty((String)result.getAbsoluteFilePath()) || !FileUtil.pathsEqual((String)result.getAbsoluteFilePath(), (String)virtualFile.getCanonicalPath()) || (info = JSLanguageServiceUtil.getElementInfo(file, document, result)) == null) continue;
            PsiElement element = info.getElement();
            holder.registerProblem((PsiElement)(element != null ? element : file), info.getRange(), result.getDescription(), new LocalQuickFix[0]);
        }
    }
}

