/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.FormattingMode;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFormatterUtil {
    private JSFormatterUtil() {
    }

    public static boolean isInlineEndOfLineComment(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/JSFormatterUtil", "isInlineEndOfLineComment"));
        }
        if (node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            ASTNode prev = node.getTreePrev();
            return !(prev.getPsi() instanceof PsiWhiteSpace) || !prev.textContains('\n');
        }
        return false;
    }

    public static boolean isEnterAtNewArgument(@NotNull FormattingMode formattingMode, @Nullable ASTNode child) {
        if (formattingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingMode", "com/intellij/lang/javascript/formatter/JSFormatterUtil", "isEnterAtNewArgument"));
        }
        if (formattingMode != FormattingMode.ADJUST_INDENT_ON_ENTER || child == null) {
            return false;
        }
        return child.getElementType() != JSTokenTypes.LPAR && (child.getElementType() != JSTokenTypes.RPAR || FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.COMMA, (IElementType[])new IElementType[]{TokenType.ERROR_ELEMENT}));
    }
}

