/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndentOptionsEditor
extends SmartIndentOptionsEditor {
    private JCheckBox myIndentOptionsCheckBox;
    private JCheckBox myUseChainedCallsGroupIndent;
    private final Language myDialect;

    public JSIndentOptionsEditor(@Nullable Language dialect) {
        this.myDialect = dialect;
    }

    protected void addComponents() {
        super.addComponents();
        this.myIndentOptionsCheckBox = new JCheckBox("Indent chained methods");
        this.myIndentOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSIndentOptionsEditor.this.myUseChainedCallsGroupIndent.setEnabled(JSIndentOptionsEditor.this.myIndentOptionsCheckBox.isSelected());
            }
        });
        this.add(this.myIndentOptionsCheckBox);
        this.myUseChainedCallsGroupIndent = new JCheckBox("Indent all chained calls in a group");
        this.add(this.myUseChainedCallsGroupIndent);
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        return super.isModified(settings, options) || this.myIndentOptionsCheckBox.isSelected() != jsSettings.INDENT_CHAINED_CALLS || this.myUseChainedCallsGroupIndent.isSelected() != jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS;
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        jsSettings.INDENT_CHAINED_CALLS = this.myIndentOptionsCheckBox.isSelected();
        jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS = this.myUseChainedCallsGroupIndent.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSIndentOptionsEditor", "reset"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/formatter/JSIndentOptionsEditor", "reset"));
        }
        super.reset(settings, options);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        this.myIndentOptionsCheckBox.setSelected(jsSettings.INDENT_CHAINED_CALLS);
        this.myUseChainedCallsGroupIndent.setSelected(jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS);
        this.myUseChainedCallsGroupIndent.setEnabled(jsSettings.INDENT_CHAINED_CALLS);
    }
}

