/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.impl.JSArgumentListImpl;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAmdPsiUtil {
    static final String DEFINE_CALL_LOCAL_ALIAS_KEY = "def";
    static final String AMD_MODULE_NAME_MARK = "amd";
    private static final TokenSet CALL_EXPRESSION_TOKEN_SET;
    private static final TokenSet STOP_AT_WHEN_SEARCHING_DEFINE_TOKEN_SET;

    @Nullable
    public static PsiElement findReferencedModule(@NotNull JSParameter amdModuleParameter) {
        if (amdModuleParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "amdModuleParameter", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "findReferencedModule"));
        }
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(amdModuleParameter);
        if (amdModuleReference == null) {
            return null;
        }
        PsiReference[] references = amdModuleReference.getReferences();
        if (references.length == 0) {
            return null;
        }
        Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)amdModuleParameter, references);
        for (PsiElement resolve : modules) {
            if (!(resolve instanceof JSFile)) continue;
            Collection<PsiElement> callExpressionStatements = JSStubBasedPsiTreeUtil.findDescendants(resolve, CALL_EXPRESSION_TOKEN_SET, STOP_AT_WHEN_SEARCHING_DEFINE_TOKEN_SET);
            for (PsiElement statement : callExpressionStatements) {
                Collection descendants;
                assert (statement instanceof JSCallExpression);
                JSElementIndexingData indexingData = ((JSCallExpression)statement).getIndexingData();
                Map userStrings = indexingData != null ? indexingData.getUserStrings() : null;
                String localAlias = userStrings != null ? (String)userStrings.get(DEFINE_CALL_LOCAL_ALIAS_KEY) : null;
                if (localAlias == null || (descendants = JSStubBasedPsiTreeUtil.findDescendants(statement, JSElementTypes.FUNCTION_EXPRESSIONS, JSElementTypes.FUNCTION_EXPRESSIONS)).size() != 1) continue;
                PsiElement functionExpression = (PsiElement)descendants.iterator().next();
                assert (functionExpression instanceof JSFunctionExpression);
                if (!localAlias.isEmpty()) {
                    return JSStubBasedPsiTreeUtil.resolveLocally(localAlias, functionExpression);
                }
                Collection expressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)functionExpression), JSFunctionExpression.class);
                if (expressions.isEmpty()) continue;
                return (PsiElement)ContainerUtil.getFirstItem(expressions);
            }
        }
        return null;
    }

    public static boolean isDefineCall(@NotNull JSCallExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "isDefineCall"));
        }
        return JSAmdPsiUtil.isDefineCall(node.getNode());
    }

    public static boolean isDefineCall(@NotNull ASTNode callNode) {
        String name;
        if (callNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callNode", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "isDefineCall"));
        }
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression(callNode);
        if (methodExpression != null && methodExpression.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(methodExpression) == null && ("define".equals(name = JSReferenceExpressionImpl.getReferenceName(methodExpression)) || "require".equals(name))) {
            return JSAmdPsiUtil.getModuleInitializer(callNode) != null;
        }
        return false;
    }

    @Nullable
    public static JSExpression getModuleInitializer(@NotNull JSCallExpression defineCall) {
        if (defineCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defineCall", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "getModuleInitializer"));
        }
        ASTNode moduleInitializer = JSAmdPsiUtil.getModuleInitializer(defineCall.getNode());
        return moduleInitializer != null ? (JSExpression)moduleInitializer.getPsi() : null;
    }

    @Nullable
    private static ASTNode getModuleInitializer(@NotNull ASTNode callExpressionNode) {
        if (callExpressionNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpressionNode", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "getModuleInitializer"));
        }
        ASTNode argumentList = JSCallExpressionImpl.getArgumentList(callExpressionNode);
        if (argumentList == null) {
            return null;
        }
        ASTNode[] arguments = JSArgumentListImpl.getArguments(argumentList);
        ASTNode candidate = null;
        if (arguments.length == 1) {
            candidate = arguments[0];
        } else if (arguments.length == 2 && (arguments[0].getElementType() == JSElementTypes.ARRAY_LITERAL_EXPRESSION || JSLiteralExpressionImpl.isQuotedLiteral(arguments[0]))) {
            candidate = arguments[1];
        } else if (arguments.length == 3 && JSLiteralExpressionImpl.isQuotedLiteral(arguments[0]) && arguments[1].getElementType() == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            candidate = arguments[2];
        }
        return candidate != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(candidate.getElementType()) ? candidate : null;
    }

    @NotNull
    public static String unifyModuleName(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "unifyModuleName"));
        }
        String text = literalExpression.getText();
        String unquoted = StringUtil.unquoteString((String)text);
        String string = "module:" + unquoted;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "unifyModuleName"));
        }
        return string;
    }

    public static boolean isAmdModuleName(@NotNull JSImplicitElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "isAmdModuleName"));
        }
        return AMD_MODULE_NAME_MARK.equals(element.getUserString());
    }

    @Nullable
    public static JSQualifiedName getNamespaceForAmdModuleElements(@NotNull JSFunction initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "getNamespaceForAmdModuleElements"));
        }
        Pair<JSLiteralExpression, JSArrayLiteralExpression> requireArguments = JSAmdPsiUtil.getRequireArguments(initializer);
        if (requireArguments != null) {
            String name = requireArguments.first != null ? JSAmdPsiUtil.unifyModuleName((JSLiteralExpression)requireArguments.first) : "exports";
            return JSQualifiedNameImpl.create(name, null);
        }
        return null;
    }

    @Nullable
    public static String getNamespaceFromExplicitModuleName(@NotNull JSCallExpression defineCall) {
        Collection implicitElements;
        JSElementIndexingData indexingData;
        if (defineCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defineCall", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "getNamespaceFromExplicitModuleName"));
        }
        JSLiteralExpression explicitName = JSAmdPsiUtil.getExplicitModuleNameLiteral(defineCall);
        if (explicitName != null && (indexingData = explicitName.getIndexingData()) != null && (implicitElements = indexingData.getImplicitElements()) != null) {
            for (JSImplicitElement element : implicitElements) {
                if (!JSAmdPsiUtil.isAmdModuleName(element)) continue;
                return element.getName();
            }
        }
        return null;
    }

    @Nullable
    public static String getExplicitModuleName(@NotNull JSCallExpression defineCall) {
        if (defineCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defineCall", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "getExplicitModuleName"));
        }
        String name = JSAmdPsiUtil.getNamespaceFromExplicitModuleName(defineCall);
        return name != null ? StringUtil.trimStart((String)name, (String)"module:") : null;
    }

    @Nullable
    private static JSLiteralExpression getExplicitModuleNameLiteral(@NotNull JSCallExpression defineCall) {
        if (defineCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defineCall", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "getExplicitModuleNameLiteral"));
        }
        assert (defineCall instanceof StubBasedPsiElementBase);
        StubElement stub = ((StubBasedPsiElementBase)defineCall).getStub();
        JSLiteralExpression explicitName = null;
        if (stub == null) {
            JSExpression[] arguments = defineCall.getArguments();
            if (arguments[0] instanceof JSLiteralExpression) {
                explicitName = (JSLiteralExpression)arguments[0];
            }
        } else {
            StubElement firstChild;
            PsiElement psi;
            List stubs = stub.getChildrenStubs();
            if (stubs.size() > 0 && (psi = (firstChild = (StubElement)stubs.get(0)).getPsi()) instanceof JSLiteralExpression) {
                explicitName = (JSLiteralExpression)psi;
            }
        }
        return explicitName;
    }

    @Nullable
    public static Pair<JSLiteralExpression, JSArrayLiteralExpression> getRequireArguments(@NotNull JSFunction function) {
        PsiElement grandParent;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil", "getRequireArguments"));
        }
        PsiElement parent = function.getParent();
        PsiElement psiElement = grandParent = parent instanceof JSArgumentList ? parent.getParent() : null;
        if (grandParent instanceof JSCallExpression && JSAmdPsiUtil.isDefineCall((JSCallExpression)grandParent)) {
            JSLiteralExpression moduleName = null;
            JSArrayLiteralExpression deps = null;
            JSExpression[] arguments = ((JSCallExpression)grandParent).getArguments();
            if (arguments[0] instanceof JSLiteralExpression) {
                moduleName = (JSLiteralExpression)arguments[0];
            }
            if (moduleName == null && arguments[0] instanceof JSArrayLiteralExpression) {
                deps = (JSArrayLiteralExpression)arguments[0];
            } else if (moduleName != null && arguments[1] instanceof JSArrayLiteralExpression) {
                deps = (JSArrayLiteralExpression)arguments[1];
            }
            return Pair.create((Object)moduleName, deps);
        }
        return null;
    }

    static {
        JSElementIndexingData.ourUserStringKeysRegisty.registerUserString(DEFINE_CALL_LOCAL_ALIAS_KEY);
        CALL_EXPRESSION_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CALL_EXPRESSION});
        STOP_AT_WHEN_SEARCHING_DEFINE_TOKEN_SET = TokenSet.andNot((TokenSet)JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.EXPRESSION_STATEMENT}));
    }
}

