/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.XmlEmmetParser;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXEmmetParser
extends XmlEmmetParser {
    public JSXEmmetParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        super(tokens, callback, generator, surroundWithTemplate);
    }

    @Nullable
    public ZenCodingNode parse() {
        String key;
        TemplateToken token;
        ZenCodingNode node = super.parse();
        if (node instanceof TemplateNode && (token = ((TemplateNode)node).getTemplateToken()) != null && token.getAttributes().isEmpty() && !ReactXmlExtension.isComponentName(key = token.getKey()) && this.myCallback.findApplicableTemplate(key) == null && !this.isKnownHtml5Tag(key)) {
            return null;
        }
        return node;
    }

    @NotNull
    protected String getClassAttributeName() {
        if ("className" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXEmmetParser", "getClassAttributeName"));
        }
        return "className";
    }

    protected boolean setTemplate(TemplateToken token, TemplateImpl template) {
        boolean result = super.setTemplate(token, template);
        if (result) {
            String templateString;
            int indexOf;
            String templateText;
            XmlTag tag = token.getXmlTag();
            TemplateImpl tokenTemplate = token.getTemplate();
            if (tag != null && tokenTemplate != null && HtmlUtil.isSingleHtmlTag((String)tag.getName()) && StringUtil.endsWithChar((CharSequence)(templateText = tokenTemplate.getTemplateText()), (char)'>') && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)"/>") && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)("</" + tag.getName() + ">")) && (indexOf = (templateString = tokenTemplate.getString()).lastIndexOf(">")) >= 0) {
                TemplateImpl newTemplate = tokenTemplate.copy();
                newTemplate.setString(templateString.substring(0, indexOf) + "/>" + templateString.substring(indexOf + 1));
                newTemplate.parseSegments();
                result = super.setTemplate(token, newTemplate);
            }
            if (result) {
                JSXEmmetParser.replaceUnsupportedAttributes(token);
            }
        }
        return result;
    }

    private static void replaceUnsupportedAttributes(TemplateToken token) {
        final XmlTag tag = token.getXmlTag();
        if (tag != null) {
            tag.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlAttribute(XmlAttribute attribute) {
                    if ("class".equalsIgnoreCase(attribute.getName())) {
                        WriteCommandAction.runWriteCommandAction((Project)tag.getProject(), () -> attribute.setName("className"));
                    } else if ("for".equalsIgnoreCase(attribute.getName())) {
                        WriteCommandAction.runWriteCommandAction((Project)tag.getProject(), () -> attribute.setName("htmlFor"));
                    }
                }
            });
        }
    }

    private boolean isKnownHtml5Tag(@NotNull String tag) {
        XmlNSDescriptor nsDescriptor;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/JSXEmmetParser", "isKnownHtml5Tag"));
        }
        if (Arrays.stream(HtmlUtil.getCustomTagDescriptors((PsiElement)this.myCallback.getContext())).anyMatch(t -> {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/JSXEmmetParser", "lambda$isKnownHtml5Tag$0"));
            }
            return tag.equalsIgnoreCase(t.getName());
        })) {
            return true;
        }
        XmlTag htmlTag = XmlElementFactory.getInstance((Project)this.myCallback.getProject()).createHTMLTagFromText("<!doctype html><div></div>");
        XmlElementDescriptor htmlTagDescriptor = htmlTag.getDescriptor();
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = htmlTagDescriptor != null ? htmlTagDescriptor.getNSDescriptor() : null;
        if (nsDescriptor != null) {
            XmlDocument document = ((XmlFile)htmlTag.getContainingFile()).getDocument();
            for (XmlElementDescriptor descriptor2 : nsDescriptor.getRootElementsDescriptors(document)) {
                if (descriptor2 instanceof HtmlUtil.CustomXmlTagDescriptor || !tag.equalsIgnoreCase(descriptor2.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

