/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionExpressionToArrowFunctionQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    @NotNull
    private final SmartPsiElementPointer<JSFunctionExpression> myPointer;

    public JSFunctionExpressionToArrowFunctionQuickFix(@NotNull SmartPsiElementPointer<JSFunctionExpression> pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "<init>"));
        }
        this.myPointer = pointer;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.to.arrow.function", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.arrow.function", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "isAvailable"));
        }
        JSFunctionExpression functionExpression = (JSFunctionExpression)this.myPointer.getElement();
        if (functionExpression == null || !functionExpression.isValid()) {
            return false;
        }
        if (JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression) || PsiTreeUtil.findChildOfType((PsiElement)functionExpression, JSThisExpression.class) != null) {
            return false;
        }
        NameChecker nameChecker = new NameChecker(functionExpression);
        return nameChecker.check();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "invoke"));
        }
        this.applyImpl(project);
    }

    private void applyImpl(@NotNull Project project) {
        boolean wrapWithParenthesis;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "applyImpl"));
        }
        JSFunctionExpression functionExpression = (JSFunctionExpression)this.myPointer.getElement();
        if (functionExpression == null || !functionExpression.isValid()) {
            return;
        }
        NameChecker nameChecker = new NameChecker(functionExpression);
        if (!nameChecker.check()) {
            return;
        }
        nameChecker.rebindReferencesIfNeeded();
        JSBlockStatement functionExpressionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)functionExpression, JSBlockStatement.class);
        String shortBodyText = functionExpressionBody == null ? null : JSFunctionExpressionToArrowFunctionQuickFix.getShortBodyText(functionExpressionBody);
        JSFunctionExpression arrowFunction = JSChangeUtil.createArrowFunctionWithSameParameters(project, (JSFunction)functionExpression, shortBodyText);
        if (shortBodyText == null) {
            JSBlockStatement arrowFunctionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)arrowFunction, JSBlockStatement.class);
            JSChangeUtil.replaceStatement((JSStatement)arrowFunctionBody, (JSStatement)functionExpressionBody);
        }
        JSExpression expression = JSChangeUtil.replaceExpression((JSExpression)functionExpression, (JSExpression)((wrapWithParenthesis = functionExpression.getParent() instanceof JSReferenceExpression) ? JSChangeUtil.wrapInParentheses(project, (JSExpression)arrowFunction) : arrowFunction));
        JSRefactoringUtil.reformatElementWithoutBody((PsiElement)expression, (PsiElement)expression);
    }

    private static String getShortBodyText(@NotNull JSBlockStatement block) {
        JSSourceElement statement;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "getShortBodyText"));
        }
        List elements = ContainerUtil.filter((Object[])block.getChildren(), element -> JSChangeUtil.isStatementOrComment(element));
        if (elements.size() == 1 && elements.get(0) instanceof JSSourceElement && (statement = (JSSourceElement)elements.get(0)) instanceof JSReturnStatement && ((JSReturnStatement)statement).getExpression() != null) {
            JSExpression expression = ((JSReturnStatement)statement).getExpression();
            if (expression instanceof JSObjectLiteralExpression) {
                return "(" + expression.getText() + ")";
            }
            return expression.getText();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix", "applyFix"));
        }
        this.applyImpl(project);
    }

    static class NameChecker {
        private static final Key<Pair<Boolean, String>> NOT_USED_OUTSIDE_ITSELF = Key.create((String)"JavaScript.JSFunctionExpression.To.Arrow.Function.Not.Used.Outside.Itself");
        private final JSFunctionExpression functionExpression;
        private String myNewNameIfRenameNeeded;

        public NameChecker(JSFunctionExpression functionExpression) {
            this.functionExpression = functionExpression;
        }

        public boolean check() {
            ASTNode nameNode = JSPsiImplUtils.findNameIdentifierOfFunction(this.functionExpression.getNode(), true);
            if (nameNode == null) {
                return true;
            }
            JSQualifiedNamedElement assignedTo = this.functionExpression.getElementAssignedTo();
            if (assignedTo != null && Comparing.equal((String)assignedTo.getName(), (String)nameNode.getText())) {
                return true;
            }
            Pair<Boolean, String> data = (Pair<Boolean, String>)this.functionExpression.getUserData(NOT_USED_OUTSIDE_ITSELF);
            if (data == null) {
                data = NameChecker.calculateNotUsedOutsideItself(this.functionExpression, assignedTo);
                this.functionExpression.putUserData(NOT_USED_OUTSIDE_ITSELF, data);
            }
            this.myNewNameIfRenameNeeded = (String)data.getSecond();
            return Boolean.TRUE.equals(data.getFirst());
        }

        private static Pair<Boolean, String> calculateNotUsedOutsideItself(@NotNull JSFunctionExpression functionExpression, @Nullable JSQualifiedNamedElement assignedTo) {
            if (functionExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix$NameChecker", "calculateNotUsedOutsideItself"));
            }
            Collection references = ReferencesSearch.search((PsiElement)functionExpression, (SearchScope)GlobalSearchScope.fileScope((PsiFile)functionExpression.getContainingFile())).findAll();
            if (assignedTo == null) {
                return Pair.create((Object)references.isEmpty(), null);
            }
            for (PsiReference reference : references) {
                if (!(reference instanceof PsiElement) || PsiTreeUtil.isAncestor((PsiElement)functionExpression, (PsiElement)((PsiElement)reference), (boolean)false)) continue;
                return Pair.create((Object)false, null);
            }
            if (!references.isEmpty()) {
                return Pair.create((Object)true, (Object)assignedTo.getName());
            }
            return Pair.create((Object)true, null);
        }

        public void rebindReferencesIfNeeded() {
            if (this.myNewNameIfRenameNeeded != null && this.functionExpression.getElementAssignedTo() != null) {
                Collection references = ReferencesSearch.search((PsiElement)this.functionExpression, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.functionExpression.getContainingFile())).findAll();
                for (PsiReference reference : references) {
                    if (!(reference instanceof PsiElement)) continue;
                    reference.bindToElement((PsiElement)this.functionExpression.getElementAssignedTo());
                }
            }
        }
    }
}

